/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntityDrive;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySakuraEndManager
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    private static final DataParameter<Integer> ThrowerEntityID = EntityDataManager.func_187226_a(EntitySakuraEndManager.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySakuraEndManager(World par1World) {
        super(par1World);
        this.field_70173_aa = 0;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(ThrowerEntityID, (Object)0);
    }

    int getThrowerEntityID() {
        return (Integer)this.func_184212_Q().func_187225_a(ThrowerEntityID);
    }

    void setThrowerEntityID(int id) {
        this.func_184212_Q().func_187227_b(ThrowerEntityID, (Object)id);
    }

    public EntitySakuraEndManager(World par1World, EntityLivingBase entityLiving) {
        this(par1World);
        this.thrower = entityLiving;
        this.setThrowerEntityID(this.thrower.func_145782_y());
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(64.0f, 32.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
    }

    public void func_70071_h_() {
        EntityPlayer player;
        ItemStack stack;
        if (this.thrower == null && this.getThrowerEntityID() != 0) {
            this.thrower = this.field_70170_p.func_73045_a(this.getThrowerEntityID());
        }
        if (this.blade.func_190926_b() && this.getThrower() != null && this.getThrower() instanceof EntityPlayer && (stack = (player = (EntityPlayer)this.getThrower()).func_184586_b(EnumHand.MAIN_HAND)).func_77973_b() instanceof ItemSlashBlade) {
            this.blade = stack;
        }
        if (this.field_70173_aa == 1 && this.getThrower() != null) {
            ReflectionAccessHelper.setVelocity(this.getThrower(), 0.0, 0.0, 0.0);
            if (this.getThrower() != null) {
                this.getThrower().func_184185_a(SoundEvents.field_187603_D, 1.0f, 1.0f);
            }
            this.doAttack(ItemSlashBlade.ComboSequence.SlashEdge);
        }
        if (this.field_70173_aa >= 5) {
            if (!this.blade.func_190926_b()) {
                NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                ItemSlashBlade bladeItem = (ItemSlashBlade)this.blade.func_77973_b();
                ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.ReturnEdge);
                if (this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
                    bladeItem.doSwingItem(this.blade, (EntityLivingBase)this.getThrower());
                    this.getThrower().func_184185_a(SoundEvents.field_187603_D, 1.0f, 1.0f);
                }
                this.doAttack(ItemSlashBlade.ComboSequence.ReturnEdge);
            }
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            this.func_70106_y();
        }
    }

    public void doAttack(ItemSlashBlade.ComboSequence combo) {
        EntityDrive entityDrive;
        if (this.blade.func_190926_b()) {
            return;
        }
        if (!(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            return;
        }
        ItemSlashBlade itemBlade = (ItemSlashBlade)this.blade.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (!(this.getThrower() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
        double dAmbit = 0.5;
        AxisAlignedBB bb = itemBlade.getBBofCombo(this.blade, combo, entityLiving);
        bb = bb.func_72314_b(0.0, dAmbit, 0.0);
        List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
        list.removeAll(this.alreadyHitEntity);
        this.alreadyHitEntity.addAll(list);
        for (Entity curEntity : list) {
            boolean isDestruction = true;
            if (curEntity instanceof EntityFireball) {
                isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), 1.0f);
            } else if (curEntity instanceof EntityArrow) {
                if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                    isDestruction = false;
                }
            } else if (curEntity instanceof IThrowableEntity) {
                if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                    isDestruction = false;
                }
            } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                isDestruction = false;
            }
            if (!isDestruction) continue;
            ReflectionAccessHelper.setVelocity(curEntity, 0.0, 0.0, 0.0);
            curEntity.func_70106_y();
            for (int var1 = 0; var1 < 10; ++var1) {
                Random rand = this.getRand();
                double var2 = rand.nextGaussian() * 0.02;
                double var4 = rand.nextGaussian() * 0.02;
                double var6 = rand.nextGaussian() * 0.02;
                double var8 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
            }
            StylishRankManager.doAttack(this.thrower);
        }
        list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
        list.removeAll(this.alreadyHitEntity);
        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.Spear);
        if (!this.blade.func_190926_b()) {
            NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
            for (Entity curEntity : list) {
                curEntity.field_70172_ad = 0;
                if (this.thrower instanceof EntityPlayer) {
                    itemBlade.attackTargetEntity(this.blade, curEntity, (EntityPlayer)this.thrower, true);
                    continue;
                }
                EntityDamageSource ds = new EntityDamageSource("mob", this.getThrower());
                curEntity.func_70097_a((DamageSource)ds, 10.0f);
                if (this.blade.func_190926_b() || !(curEntity instanceof EntityLivingBase)) continue;
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
            }
        }
        if ((entityDrive = new EntityDrive(this.field_70170_p, entityLiving, 0.5f, true, 90.0f - Math.abs(combo.swingDirection))) != null) {
            entityDrive.setInitialSpeed(0.1f);
            entityDrive.setLifeTime(20);
            this.field_70170_p.func_72838_d((Entity)entityDrive);
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        this.thrower = entity;
    }
}

