/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.EntitySummonedSwordBase;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySpiralSwords
extends EntitySummonedSwordBase {
    private static final DataParameter<Boolean> HAS_FIRED = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> ROT_OFFSET = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> HOLDID = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROT_PITCH = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROT_YAW = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> ROT_TICKS = EntityDataManager.func_187226_a(EntitySpiralSwords.class, (DataSerializer)DataSerializers.field_187192_b);
    static final int waitTime = 7;
    int life = 2;

    public EntitySpiralSwords(World par1World) {
        super(par1World);
        this.setInterval(0);
    }

    public EntitySpiralSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntitySpiralSwords(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll, float rotOffset) {
        super(par1World, entityLiving, AttackLevel, roll);
        this.setRotOffset(rotOffset);
        this.faceEntityStandby();
        this.setDriveVector(1.0f, true);
        this.mountEntity(this.getThrower());
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(HAS_FIRED, (Object)false);
        this.func_184212_Q().func_187214_a(ROT_OFFSET, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(HOLDID, (Object)0);
        this.func_184212_Q().func_187214_a(ROT_PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ROT_YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(ROT_TICKS, (Object)30);
    }

    public boolean hasFired() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_FIRED);
    }

    public void setHasFired(boolean hasFired) {
        this.func_184212_Q().func_187227_b(HAS_FIRED, (Object)hasFired);
    }

    public float getRotOffset() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_OFFSET)).floatValue();
    }

    public void setRotOffset(float rotOffset) {
        this.func_184212_Q().func_187227_b(ROT_OFFSET, (Object)Float.valueOf(rotOffset));
    }

    public int getHoldId() {
        return (Integer)this.func_184212_Q().func_187225_a(HOLDID);
    }

    public void setHoldId(int id) {
        this.func_184212_Q().func_187227_b(HOLDID, (Object)id);
    }

    public int getRotTicks() {
        return (Integer)this.func_184212_Q().func_187225_a(ROT_TICKS);
    }

    public void setRotTicks(int ticks) {
        this.func_184212_Q().func_187227_b(ROT_TICKS, (Object)ticks);
    }

    public float getRotPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_PITCH)).floatValue();
    }

    public void setRotPitch(float rotPitch) {
        this.func_184212_Q().func_187227_b(ROT_PITCH, (Object)Float.valueOf(rotPitch));
    }

    public float getRotYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(ROT_YAW)).floatValue();
    }

    public void setRotYaw(float rotYaw) {
        this.func_184212_Q().func_187227_b(ROT_YAW, (Object)Float.valueOf(rotYaw));
    }

    @Override
    public void func_70098_U() {
        if (this.getLifeTime() < this.field_70173_aa) {
            this.func_82142_c(true);
            this.field_70128_L = true;
        }
        if (this.hasFired()) {
            if (this.ridingEntity2 == this.thrower) {
                this.ridingEntity2 = null;
            } else {
                super.func_70098_U();
            }
            return;
        }
        Entity ridingEntity = this.ridingEntity2;
        this.faceEntityStandby();
        if (ridingEntity.field_70128_L) {
            this.setInterval(this.field_70173_aa + 7);
            this.setLifeTime(this.field_70173_aa + 30);
            this.setHasFired(true);
            this.func_130014_f_().func_72866_a((Entity)this, true);
            return;
        }
        if (!this.func_130014_f_().field_72995_K) {
            long holdid = ridingEntity.getEntityData().func_74763_f("SB.SPHOLDID");
            if (holdid != (long)this.getHoldId()) {
                this.setInterval(this.field_70173_aa + 7);
                this.setLifeTime(this.field_70173_aa + 30);
                this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187524_aN, SoundCategory.NEUTRAL, 0.35f, 0.2f);
                this.setHasFired(true);
                this.func_130014_f_().func_72866_a((Entity)this, true);
                return;
            }
            if (this.getInterval() < this.field_70173_aa) {
                this.setHasFired(true);
                this.func_130014_f_().func_72866_a((Entity)this, true);
                return;
            }
        }
        this.setMotionVector(1.0f, false);
        RayTraceResult movingobjectposition = this.getRayTraceResult();
        if (movingobjectposition != null && this.onImpact(movingobjectposition)) {
            return;
        }
        this.doTargeting();
    }

    @Override
    protected void initRotation() {
        super.initRotation();
        if (this.ridingEntity2 == null && !this.hasFired() && this.getThrower() != null && this.func_130014_f_().field_72995_K) {
            this.mountEntity(this.getThrower());
        }
    }

    @Override
    public void spawnParticle() {
        super.spawnParticle();
        if (this.hasFired()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.PORTAL, this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
    }

    @Override
    protected boolean onImpact(RayTraceResult mop) {
        boolean result = false;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(EntitySelectorDestructable.getInstance())) {
                this.destructEntity(target);
                return true;
            }
            if (mop.hitInfo.equals(EntitySelectorAttackable.getInstance())) {
                this.attackEntity(target);
            }
        } else {
            if (this.field_70173_aa < this.getInterval()) {
                return false;
            }
            if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                    ((EntityPlayer)this.getThrower()).func_71009_b((Entity)this);
                }
                this.func_70106_y();
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean doTargeting() {
        return false;
    }

    private void faceEntityStandby() {
        int ticks = this.field_70173_aa;
        if (this.getInterval() - 7 < ticks) {
            ticks = this.getInterval() - 7;
        }
        double rotParTick = 360.0 / (double)this.getRotTicks();
        double offset = this.getRotOffset();
        double degYaw = (double)ticks * rotParTick + offset;
        double yaw = Math.toRadians(degYaw);
        Matrix4d rotMat = new Matrix4d();
        rotMat.setIdentity();
        double thRot = 0.0;
        if (this.getThrower() != null) {
            thRot = this.getThrower().field_70177_z;
        }
        Matrix4d rotA = new Matrix4d();
        rotA.rotY(Math.toRadians((double)this.getRotYaw() - thRot));
        rotMat.mul(rotA);
        Matrix4d rotA2 = new Matrix4d();
        rotA2.rotX(Math.toRadians(-this.getRotPitch()));
        rotMat.mul(rotA2);
        double pitch = 7.5;
        rotA = new Matrix4d();
        rotA.rotY(-Math.toRadians((double)ticks * 5.0 % 360.0));
        rotMat.mul(rotA);
        Matrix4d rot = new Matrix4d();
        rot.rotZ(Math.toRadians(7.5));
        rotMat.mul(rot);
        rot = new Matrix4d();
        rot.rotY(yaw);
        rotMat.mul(rot);
        Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        rotMat.transform(vector3d);
        vector3d.normalize();
        vector3d.scale(1.5);
        Vec3d pos = new Vec3d(vector3d.x, vector3d.y, vector3d.z);
        if (this.getThrower() != null) {
            pos = pos.func_178787_e(this.getThrower().func_174791_d());
            pos = pos.func_72441_c(0.0, (double)this.getThrower().func_70047_e() / 3.0, 0.0);
        }
        Vector3d rot2 = new Vector3d();
        this.rotate(rotMat, rot2);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        this.func_70101_b((float)Math.toDegrees(rot2.y), (float)Math.toDegrees(rot2.x));
    }

    public final void rotate(Matrix4d m, Vector3d rot) {
        Vector3d unit = new Vector3d(0.0, 0.0, 1.0);
        Vector3d vector3d = new Vector3d(0.0, 0.0, 1.0);
        m.transform(vector3d);
        vector3d.normalize();
        Vector3d yawBase = new Vector3d(vector3d);
        yawBase.y = 0.0;
        double yaw = 0.0;
        if (0.0 != yawBase.length()) {
            yawBase.normalize();
            yaw = unit.dot(yawBase);
            yaw = Math.acos(yaw);
            Vector3d cx = new Vector3d();
            cx.cross(unit, yawBase);
            yaw = Math.signum(cx.y) * yaw;
            if (Math.abs(yaw) < 0.3) {
                Vector3d xUnit = new Vector3d(1.0, 0.0, 0.0);
                yaw = xUnit.dot(yawBase);
                yaw = Math.acos(yaw);
                cx.cross(xUnit, yawBase);
                yaw = Math.signum(cx.y) * yaw + 1.5707963267948966;
            }
            Matrix4d invYaw = new Matrix4d();
            invYaw.rotY(-yaw);
            invYaw.transform(vector3d);
            vector3d.x = 0.0;
            vector3d.normalize();
        }
        double pitch = unit.dot(vector3d);
        pitch = Math.acos(pitch);
        Vector3d cx = new Vector3d();
        cx.cross(unit, vector3d);
        pitch = Math.signum(cx.x) * pitch;
        if (Math.abs(pitch) < 0.3) {
            Vector3d yUnit = new Vector3d(0.0, 1.0, 0.0);
            pitch = yUnit.dot(vector3d);
            pitch = Math.acos(pitch);
            cx.cross(yUnit, vector3d);
            pitch = Math.signum(cx.x) * pitch - 1.5707963267948966;
        }
        rot.y = -yaw;
        rot.x = pitch;
    }

    public void setMotionVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.field_70177_z / 180.0f * (float)Math.PI;
        float fPitDtoR = this.field_70125_A / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    @Override
    protected void attackEntity(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70173_aa % 3 != 0) {
                return;
            }
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (!this.blade.func_190926_b() && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                ReflectionAccessHelper.setVelocity(target, 0.0, 0.0, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
            if (--this.life <= 0) {
                this.func_70106_y();
            }
        }
    }
}

