/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.ability.UntouchableTime;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityStingerManager
extends Entity
implements IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    private static final DataParameter<Boolean> SINGLE_HIT = EntityDataManager.func_187226_a(EntityStingerManager.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntityStingerManager.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THROWER_ENTITY_ID = EntityDataManager.func_187226_a(EntityStingerManager.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntityStingerManager(World par1World) {
        super(par1World);
    }

    public EntityStingerManager(World par1World, EntityLivingBase entityLiving, boolean isSingleHit) {
        this(par1World, entityLiving);
        this.setIsSingleHit(isSingleHit);
    }

    public EntityStingerManager(World par1World, EntityLivingBase entityLiving) {
        this(par1World);
        this.setThrower((Entity)entityLiving);
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        this.field_70173_aa = 0;
        this.func_70105_a(2.0f, 2.0f);
        this.func_70012_b(this.thrower.field_70165_t, this.thrower.field_70163_u, this.thrower.field_70161_v, this.thrower.field_70177_z, this.thrower.field_70125_A);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(SINGLE_HIT, (Object)false);
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(THROWER_ENTITY_ID, (Object)0);
    }

    public boolean isSingleHit() {
        return (Boolean)this.func_184212_Q().func_187225_a(SINGLE_HIT);
    }

    public void setIsSingleHit(boolean isSingleHit) {
        this.func_184212_Q().func_187227_b(SINGLE_HIT, (Object)isSingleHit);
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public int getThrowerEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(THROWER_ENTITY_ID);
    }

    public void setThrowerEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(THROWER_ENTITY_ID, (Object)entityid);
    }

    public void func_70071_h_() {
        if (this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
            double distance;
            Entity target;
            NBTTagCompound tag;
            int targetId;
            ItemStack stack;
            EntityLivingBase owner = (EntityLivingBase)this.getThrower();
            if (this.blade.func_190926_b() && !(stack = owner.func_184614_ca()).func_190926_b() && stack.func_77973_b() instanceof ItemSlashBlade) {
                this.blade = stack;
            }
            if (this.field_70173_aa == 1) {
                double playerDist = 1.5;
                if (!owner.field_70122_E) {
                    playerDist *= (double)0.35f;
                }
                ReflectionAccessHelper.setVelocity((Entity)owner, -Math.sin(Math.toRadians(owner.field_70177_z)) * playerDist, owner.field_70181_x, Math.cos(Math.toRadians(owner.field_70177_z)) * playerDist);
                UntouchableTime.setUntouchableTime((Entity)owner, 5, false);
            }
            if (!this.blade.func_190926_b() && (targetId = ItemSlashBlade.TargetEntityId.get(tag = ItemSlashBlade.getItemTagCompound(this.blade)).intValue()) != 0 && (target = this.field_70170_p.func_73045_a(targetId)) != null && (distance = target.func_70068_e(this.getThrower())) < 3.0) {
                owner.field_70179_y = 0.0;
                owner.field_70159_w = 0.0;
                owner.field_70181_x = 0.0;
                this.field_70173_aa = this.getLifeTime();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getThrower() != null) {
            double dAmbit = 1.5;
            AxisAlignedBB bb = new AxisAlignedBB(this.thrower.field_70165_t - dAmbit, this.thrower.field_70163_u - dAmbit, this.thrower.field_70161_v - dAmbit, this.thrower.field_70165_t + dAmbit, this.thrower.field_70163_u + dAmbit, this.thrower.field_70161_v + dAmbit);
            if (this.getThrower() instanceof EntityLivingBase) {
                EntityLivingBase entityLiving = (EntityLivingBase)this.getThrower();
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorDestructable.getInstance());
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
                list.removeAll(this.alreadyHitEntity);
                this.alreadyHitEntity.addAll(list);
                for (Entity curEntity : list) {
                    boolean isDestruction = true;
                    if (curEntity instanceof EntityFireball) {
                        isDestruction = ((EntityFireball)curEntity).field_70235_a != null && ((EntityFireball)curEntity).field_70235_a.func_145782_y() == entityLiving.func_145782_y() ? false : !curEntity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)entityLiving), 1.0f);
                    } else if (curEntity instanceof EntityArrow) {
                        if (((EntityArrow)curEntity).field_70250_c != null && ((EntityArrow)curEntity).field_70250_c.func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof IThrowableEntity) {
                        if (((IThrowableEntity)curEntity).getThrower() != null && ((IThrowableEntity)curEntity).getThrower().func_145782_y() == entityLiving.func_145782_y()) {
                            isDestruction = false;
                        }
                    } else if (curEntity instanceof EntityThrowable && ((EntityThrowable)curEntity).func_85052_h() != null && ((EntityThrowable)curEntity).func_85052_h().func_145782_y() == entityLiving.func_145782_y()) {
                        isDestruction = false;
                    }
                    if (!isDestruction) continue;
                    ReflectionAccessHelper.setVelocity(curEntity, 0.0, 0.0, 0.0);
                    curEntity.func_70106_y();
                    for (int var1 = 0; var1 < 10; ++var1) {
                        Random rand = this.getRand();
                        double var2 = rand.nextGaussian() * 0.02;
                        double var4 = rand.nextGaussian() * 0.02;
                        double var6 = rand.nextGaussian() * 0.02;
                        double var8 = 10.0;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, curEntity.field_70165_t + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var2 * var8, curEntity.field_70163_u + (double)(rand.nextFloat() * curEntity.field_70131_O) - var4 * var8, curEntity.field_70161_v + (double)(rand.nextFloat() * curEntity.field_70130_N * 2.0f) - (double)curEntity.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
                    }
                    StylishRankManager.doAttack(this.thrower);
                }
            }
            if (this.isSingleHit() || this.field_70173_aa % 3 == 0) {
                List list = this.field_70170_p.func_175674_a(this.getThrower(), bb, EntitySelectorAttackable.getInstance());
                list.removeAll(this.alreadyHitEntity);
                if (this.isSingleHit()) {
                    this.alreadyHitEntity.addAll(list);
                }
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.RapidSlash);
                if (!this.blade.func_190926_b()) {
                    NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                    for (Entity curEntity : list) {
                        curEntity.field_70172_ad = 0;
                        if (this.thrower instanceof EntityPlayer) {
                            ItemSlashBlade itemBlade = (ItemSlashBlade)this.blade.func_77973_b();
                            itemBlade.attackTargetEntity(this.blade, curEntity, (EntityPlayer)this.thrower, true);
                            continue;
                        }
                        EntityDamageSource ds = new EntityDamageSource("mob", this.getThrower());
                        curEntity.func_70097_a((DamageSource)ds, 10.0f);
                        if (this.blade.func_190926_b() || !(curEntity instanceof EntityLivingBase)) continue;
                        ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)curEntity, (EntityLivingBase)this.thrower);
                    }
                }
            }
        }
        if (this.field_70173_aa >= this.getLifeTime()) {
            this.alreadyHitEntity.clear();
            this.alreadyHitEntity = null;
            if (!this.blade.func_190926_b()) {
                NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(this.blade);
                ItemSlashBlade bladeItem = (ItemSlashBlade)this.blade.func_77973_b();
                ItemSlashBlade.setComboSequence(tag, ItemSlashBlade.ComboSequence.Stinger);
                if (this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
                    bladeItem.doSwingItem(this.blade, (EntityLivingBase)this.getThrower());
                    this.getThrower().func_184185_a(SoundEvents.field_187539_bB, 0.5f, 2.5f);
                }
            }
            this.func_70106_y();
        }
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double par1, double par3, double par5) {
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.func_130014_f_().func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }
}

