/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import java.util.List;
import mods.flammpfeil.slashblade.entity.EntitySummonedSwordBase;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySummonedBlade
extends EntitySummonedSwordBase {
    public long hitTime = 0L;
    public float hitStopFactor = 0.0f;

    public EntitySummonedBlade(World par1World) {
        super(par1World);
        this.setInterval(0);
        this.hitStopFactor = this.field_70146_Z.nextFloat();
    }

    public EntitySummonedBlade(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        super(par1World, entityLiving, AttackLevel);
    }

    public EntitySummonedBlade(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll) {
        super(par1World, entityLiving, AttackLevel, roll);
        float dist = 1.0f;
        int dirFactor = this.field_70146_Z.nextInt(6);
        float rotBase = 30.0f;
        float[] rolls = new float[]{180.0f + rotBase, -180.0f, 180.0f - rotBase, -rotBase, 0.0f, rotBase};
        this.setRoll(rolls[dirFactor]);
        int[][] pattern = new int[][]{{1, 1}, {1, 0}, {1, -1}, {-1, 1}, {-1, 0}, {-1, -1}};
        double yaw = Math.toRadians(-this.thrower.field_70177_z + (float)(90 * pattern[dirFactor][0]));
        double x = Math.sin(yaw);
        double y = (float)pattern[dirFactor][1] * 0.5f;
        double z = Math.cos(yaw);
        x *= (double)dist;
        y *= (double)dist;
        z *= (double)dist;
        Vec3d vec = this.thrower.func_70040_Z();
        if (vec != null) {
            x -= vec.field_72450_a;
            y -= vec.field_72448_b;
            z -= vec.field_72449_c;
        }
        this.func_70012_b(this.thrower.field_70165_t + x, this.thrower.field_70163_u + (double)(this.thrower.func_70047_e() / 2.0f) + y, this.thrower.field_70161_v + z, this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.iniYaw = this.thrower.field_70177_z;
        this.iniPitch = this.thrower.field_70125_A;
        this.setDriveVector(1.75f);
    }

    @Override
    protected boolean onImpact(RayTraceResult mop) {
        boolean result = true;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(EntitySelectorAttackable.getInstance())) {
                this.attackEntity(target);
            } else {
                this.destructEntity(target);
            }
            this.hitTime = this.func_130014_f_().func_82737_E();
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public void calculateSpeed() {
    }

    @Override
    public boolean doTargeting() {
        Entity target;
        int targetid = this.getTargetEntityId();
        if (targetid == 0) {
            double expandFactor = 15.0;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(expandFactor, expandFactor, expandFactor));
            list.removeAll(this.alreadyHitEntity);
            double tmpDistance = 15.0;
            Entity pointedEntity = null;
            EntityLivingBase viewer = null;
            if (this.getThrower() != null && this.getThrower() instanceof EntityLivingBase) {
                viewer = (EntityLivingBase)this.getThrower();
            }
            if (viewer != null) {
                for (Entity entity : list) {
                    double d3;
                    if (entity == null || !entity.func_70067_L() || !EntitySelectorAttackable.getInstance().apply((Object)entity) || !viewer.func_70685_l(entity) || !((d3 = (double)this.func_70032_d(entity)) < tmpDistance) && tmpDistance != 0.0) continue;
                    if (entity == this.func_184187_bx() && !entity.canRiderInteract()) {
                        if (tmpDistance != 0.0) continue;
                        pointedEntity = entity;
                        continue;
                    }
                    pointedEntity = entity;
                    tmpDistance = d3;
                }
            }
            if (pointedEntity != null) {
                this.setTargetEntityId(pointedEntity.func_145782_y());
            }
        }
        if (targetid != 0 && this.getInterval() < this.field_70173_aa && (target = this.field_70170_p.func_73045_a(targetid)) != null) {
            if (Float.isNaN(this.iniPitch) && this.thrower != null) {
                this.iniYaw = this.thrower.field_70177_z;
                this.iniPitch = this.thrower.field_70125_A;
            }
            float lastYaw = this.iniYaw;
            float lastPitch = this.iniPitch;
            this.faceEntity(this, target, 10.0f, 10.0f);
            float lastSpeed = (float)new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72433_c();
            float speedFactor = Math.abs(this.iniYaw - lastYaw) / 10.0f + Math.abs(this.iniPitch - lastPitch) / 10.0f;
            speedFactor = 1.0f - Math.min(speedFactor, 0.75f);
            speedFactor = (0.75f * speedFactor + lastSpeed * 9.0f) / 10.0f;
            this.setDriveVector(speedFactor, false);
        }
        return true;
    }
}

