/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorAttackable;
import mods.flammpfeil.slashblade.entity.selector.EntitySelectorDestructable;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.util.ReflectionAccessHelper;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IThrowableEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySummonedSwordBase
extends Entity
implements IProjectile,
IThrowableEntity {
    protected Entity thrower;
    protected ItemStack blade = ItemStack.field_190927_a;
    protected List<Entity> alreadyHitEntity = new ArrayList<Entity>();
    protected float AttackLevel = 0.0f;
    private static final DataParameter<Integer> THROWER_ENTITY_ID = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> LIFETIME = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> ROLL = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> TARGET_ENTITY_ID = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INTERVAL = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(EntitySummonedSwordBase.class, (DataSerializer)DataSerializers.field_187192_b);
    float speed = 0.0f;
    float iniYaw = Float.NaN;
    float iniPitch = Float.NaN;
    double hitX;
    double hitY;
    double hitZ;
    float hitYaw;
    float hitPitch;
    public Entity ridingEntity2 = null;

    public EntitySummonedSwordBase(World par1World) {
        super(par1World);
        this.field_70145_X = true;
        this.field_70173_aa = 0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntitySummonedSwordBase(World par1World, EntityLivingBase entityLiving, float AttackLevel, float roll) {
        this(par1World, entityLiving, AttackLevel);
        this.setRoll(roll);
    }

    public EntitySummonedSwordBase(World par1World, EntityLivingBase entityLiving, float AttackLevel) {
        this(par1World);
        this.AttackLevel = AttackLevel;
        this.setThrower((Entity)entityLiving);
        this.blade = entityLiving.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.blade.func_190926_b() && !(this.blade.func_77973_b() instanceof ItemSlashBlade)) {
            this.blade = ItemStack.field_190927_a;
        }
        this.alreadyHitEntity.clear();
        this.alreadyHitEntity.add(this.thrower);
        this.alreadyHitEntity.add(this.thrower.func_184187_bx());
        this.alreadyHitEntity.addAll(this.thrower.func_184188_bt());
        float dist = 2.0f;
        double ran = ((double)this.field_70146_Z.nextFloat() - 0.5) * 2.0;
        double yaw = Math.toRadians(-this.thrower.field_70177_z + 90.0f);
        double x = ran * Math.sin(yaw);
        double y = 1.0 - Math.abs(ran);
        double z = ran * Math.cos(yaw);
        this.func_70012_b(this.thrower.field_70165_t + (x *= (double)dist), this.thrower.field_70163_u + (y *= (double)dist), this.thrower.field_70161_v + (z *= (double)dist), this.thrower.field_70177_z, this.thrower.field_70125_A);
        this.iniYaw = this.thrower.field_70177_z;
        this.iniPitch = this.thrower.field_70125_A;
        this.setDriveVector(1.75f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(THROWER_ENTITY_ID, (Object)0);
        this.func_184212_Q().func_187214_a(LIFETIME, (Object)20);
        this.func_184212_Q().func_187214_a(ROLL, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(TARGET_ENTITY_ID, (Object)0);
        this.func_184212_Q().func_187214_a(INTERVAL, (Object)7);
        this.func_184212_Q().func_187214_a(COLOR, (Object)0x3333FF);
    }

    public int getThrowerEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(THROWER_ENTITY_ID);
    }

    public void setThrowerEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(THROWER_ENTITY_ID, (Object)entityid);
    }

    public int getTargetEntityId() {
        return (Integer)this.func_184212_Q().func_187225_a(TARGET_ENTITY_ID);
    }

    public void setTargetEntityId(int entityid) {
        this.func_184212_Q().func_187227_b(TARGET_ENTITY_ID, (Object)entityid);
    }

    public float getRoll() {
        return ((Float)this.func_184212_Q().func_187225_a(ROLL)).floatValue();
    }

    public void setRoll(float roll) {
        this.func_184212_Q().func_187227_b(ROLL, (Object)Float.valueOf(roll));
    }

    public int getLifeTime() {
        return (Integer)this.func_184212_Q().func_187225_a(LIFETIME);
    }

    public void setLifeTime(int lifetime) {
        this.func_184212_Q().func_187227_b(LIFETIME, (Object)lifetime);
    }

    public int getInterval() {
        return (Integer)this.func_184212_Q().func_187225_a(INTERVAL);
    }

    public void setInterval(int value) {
        this.func_184212_Q().func_187227_b(INTERVAL, (Object)value);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int value) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)value);
    }

    public boolean doTargeting() {
        Entity target;
        Entity rayEntity;
        if (this.field_70173_aa > this.getInterval()) {
            return false;
        }
        int targetid = this.getTargetEntityId();
        Entity owner = this.thrower;
        if (this.thrower == null) {
            owner = this;
        }
        if (targetid == 0 && (rayEntity = this.getRayTrace(owner, 30.0)) != null) {
            targetid = rayEntity.func_145782_y();
            this.setTargetEntityId(rayEntity.func_145782_y());
        }
        if (targetid == 0 && (rayEntity = this.getRayTrace(owner, 30.0, 5.0f, 5.0f)) != null) {
            targetid = rayEntity.func_145782_y();
            this.setTargetEntityId(rayEntity.func_145782_y());
        }
        if (targetid != 0 && (target = this.field_70170_p.func_73045_a(targetid)) != null) {
            if (Float.isNaN(this.iniPitch) && this.thrower != null) {
                this.iniYaw = this.thrower.field_70177_z;
                this.iniPitch = this.thrower.field_70125_A;
            }
            this.faceEntity(this, target, (float)this.field_70173_aa * 1.0f, (float)this.field_70173_aa * 1.0f);
            this.setDriveVector(1.75f, false);
        }
        return true;
    }

    public Entity getRayTrace(Entity owner, double reachMax) {
        return this.getRayTrace(owner, reachMax, 1.0f, 0.0f);
    }

    public Entity getRayTrace(Entity owner, double reachMax, float expandFactor, float expandBorder) {
        float par1 = 1.0f;
        RayTraceResult objectMouseOver = EntitySummonedSwordBase.rayTrace(owner, reachMax, par1);
        double reachMin = reachMax;
        Vec3d entityPos = EntitySummonedSwordBase.getPosition(owner);
        if (objectMouseOver != null) {
            reachMin = objectMouseOver.field_72307_f.func_72438_d(entityPos);
        }
        Vec3d lookVec = EntitySummonedSwordBase.getLook(owner, par1);
        Vec3d reachVec = entityPos.func_72441_c(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax);
        Entity pointedEntity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(lookVec.field_72450_a * reachMax, lookVec.field_72448_b * reachMax, lookVec.field_72449_c * reachMax).func_72314_b((double)expandFactor, (double)expandFactor, (double)expandFactor));
        list.removeAll(this.alreadyHitEntity);
        double tmpDistance = reachMin;
        EntityLivingBase viewer = owner instanceof EntityLivingBase ? (EntityLivingBase)owner : null;
        for (Entity entity : list) {
            double d3;
            if (entity == null || !entity.func_70067_L() || !EntitySelectorAttackable.getInstance().apply((Object)entity) || viewer != null && !viewer.func_70685_l(entity)) continue;
            float borderSize = entity.func_70111_Y() + expandBorder;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult movingobjectposition = axisalignedbb.func_72327_a(entityPos, reachVec);
            if (axisalignedbb.func_72318_a(entityPos)) {
                if (!(0.0 < tmpDistance) && tmpDistance != 0.0) continue;
                pointedEntity = entity;
                tmpDistance = 0.0;
                continue;
            }
            if (movingobjectposition == null || !((d3 = entityPos.func_72438_d(movingobjectposition.field_72307_f)) < tmpDistance) && tmpDistance != 0.0) continue;
            if (entity == this.func_184187_bx() && !entity.canRiderInteract()) {
                if (tmpDistance != 0.0) continue;
                pointedEntity = entity;
                continue;
            }
            pointedEntity = entity;
            tmpDistance = d3;
        }
        return pointedEntity;
    }

    public static RayTraceResult rayTrace(Entity owner, double par1, float par3) {
        Vec3d Vec3d2 = EntitySummonedSwordBase.getPosition(owner);
        Vec3d Vec3d1 = EntitySummonedSwordBase.getLook(owner, par3);
        Vec3d Vec3d22 = Vec3d2.func_72441_c(Vec3d1.field_72450_a * par1, Vec3d1.field_72448_b * par1, Vec3d1.field_72449_c * par1);
        return owner.field_70170_p.func_147447_a(Vec3d2, Vec3d22, false, false, true);
    }

    public static Vec3d getPosition(Entity owner) {
        return new Vec3d(owner.field_70165_t, owner.field_70163_u + (double)owner.func_70047_e(), owner.field_70161_v);
    }

    public static Vec3d getLook(Entity owner, float rotMax) {
        if (rotMax == 1.0f) {
            float f1 = MathHelper.func_76134_b((float)(-owner.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f2 = MathHelper.func_76126_a((float)(-owner.field_70177_z * ((float)Math.PI / 180) - (float)Math.PI));
            float f3 = -MathHelper.func_76134_b((float)(-owner.field_70125_A * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76126_a((float)(-owner.field_70125_A * ((float)Math.PI / 180)));
            return new Vec3d((double)(f2 * f3), (double)f4, (double)(f1 * f3));
        }
        float f1 = owner.field_70127_C + (owner.field_70125_A - owner.field_70127_C) * rotMax;
        float f2 = owner.field_70126_B + (owner.field_70177_z - owner.field_70126_B) * rotMax;
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        return new Vec3d((double)(f4 * f5), (double)f6, (double)(f3 * f5));
    }

    public void faceEntity(Entity viewer, Entity target, float yawStep, float pitchStep) {
        double d2;
        double d0 = target.field_70165_t - viewer.field_70165_t;
        double d1 = target.field_70161_v - viewer.field_70161_v;
        if (target instanceof EntityLivingBase) {
            EntityLivingBase entitylivingbase = (EntityLivingBase)target;
            d2 = entitylivingbase.field_70163_u + (double)entitylivingbase.func_70047_e() - (viewer.field_70163_u + (double)viewer.func_70047_e());
        } else {
            AxisAlignedBB boundingBox = target.func_174813_aQ();
            d2 = (boundingBox.field_72338_b + boundingBox.field_72337_e) / 2.0 - (viewer.field_70163_u + (double)viewer.func_70047_e());
        }
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
        float f2 = (float)(Math.atan2(d1, d0) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d2, d3) * 180.0 / Math.PI));
        this.iniPitch = this.updateRotation(this.iniPitch, f3, pitchStep);
        this.iniYaw = this.updateRotation(this.iniYaw, f2, yawStep);
    }

    private float updateRotation(float par1, float par2, float par3) {
        float f3 = MathHelper.func_76142_g((float)(par2 - par1));
        if (f3 > par3) {
            f3 = par3;
        }
        if (f3 < -par3) {
            f3 = -par3;
        }
        return par1 + f3;
    }

    public void setDriveVector(float fYVecOfset) {
        this.setDriveVector(fYVecOfset, true);
    }

    public void setDriveVector(float fYVecOfst, boolean init) {
        float fYawDtoR = this.iniYaw / 180.0f * (float)Math.PI;
        float fPitDtoR = this.iniPitch / 180.0f * (float)Math.PI;
        this.field_70159_w = -MathHelper.func_76126_a((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        this.field_70181_x = -MathHelper.func_76126_a((float)fPitDtoR) * fYVecOfst;
        this.field_70179_y = MathHelper.func_76134_b((float)fYawDtoR) * MathHelper.func_76134_b((float)fPitDtoR) * fYVecOfst;
        float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f3) * 180.0 / Math.PI);
        if (init) {
            this.speed = fYVecOfst;
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    public void func_70098_U() {
        Entity ridingEntity = this.ridingEntity2;
        if (ridingEntity.field_70128_L) {
            this.func_70106_y();
            return;
        }
        this.field_70165_t = ridingEntity.field_70165_t + (this.hitX * Math.cos(Math.toRadians(ridingEntity.field_70177_z)) - this.hitZ * Math.sin(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70163_u = ridingEntity.field_70163_u + this.hitY;
        this.field_70161_v = ridingEntity.field_70161_v + (this.hitX * Math.sin(Math.toRadians(ridingEntity.field_70177_z)) + this.hitZ * Math.cos(Math.toRadians(ridingEntity.field_70177_z)));
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.field_70125_A = ridingEntity.field_70125_A + this.hitPitch;
        this.field_70177_z = ridingEntity.field_70177_z + this.hitYaw;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (this.field_70173_aa >= 200) {
            if (!ridingEntity.field_70128_L && !this.field_70170_p.field_72995_K) {
                float magicDamage = Math.max(1.0f, this.AttackLevel / 2.0f);
                ridingEntity.field_70172_ad = 0;
                DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
                ridingEntity.func_70097_a(ds, magicDamage);
                if (!this.blade.func_190926_b() && ridingEntity instanceof EntityLivingBase) {
                    if (this.thrower != null) {
                        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.BreakPhantomSword);
                        ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)ridingEntity, (EntityLivingBase)this.thrower);
                    }
                    ReflectionAccessHelper.setVelocity(ridingEntity, 0.0, 0.0, 0.0);
                    ridingEntity.func_70024_g(0.0, 0.1, 0.0);
                    ((EntityLivingBase)ridingEntity).field_70737_aN = 1;
                }
            }
            this.func_70106_y();
        }
    }

    protected void initRotation() {
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
    }

    protected RayTraceResult getRayTraceResult() {
        Predicate[] selectors;
        Vec3d Vec3d2 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d Vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult movingobjectposition = this.field_70170_p.func_72933_a(Vec3d2, Vec3d1);
        Vec3d2 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (movingobjectposition != null) {
            IBlockState state = null;
            BlockPos pos = movingobjectposition.func_178782_a();
            if (pos != null) {
                state = this.field_70170_p.func_180495_p(pos);
            }
            if (state != null && state.func_185890_d((IBlockAccess)this.field_70170_p, pos) == null) {
                movingobjectposition = null;
            } else {
                Vec3d1 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
        }
        Entity entity = null;
        AxisAlignedBB bb = this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0);
        for (Predicate selector : selectors = new Predicate[]{EntitySelectorDestructable.getInstance(), EntitySelectorAttackable.getInstance()}) {
            Entity target;
            List list = this.field_70170_p.func_175674_a((Entity)this, bb, selector);
            list.removeAll(this.alreadyHitEntity);
            if (selector.equals(EntitySelectorAttackable.getInstance()) && this.getTargetEntityId() != 0 && (target = this.field_70170_p.func_73045_a(this.getTargetEntityId())) != null && target.func_174813_aQ().func_72326_a(bb)) {
                list.add(target);
            }
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (entity1 instanceof EntitySummonedSwordBase && ((EntitySummonedSwordBase)entity1).getThrower() == this.getThrower() || !entity1.func_70067_L()) continue;
                float f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(Vec3d1, Vec3d2);
                if (movingobjectposition1 == null || !((d1 = Vec3d1.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity == null) continue;
            movingobjectposition = new RayTraceResult(entity);
            movingobjectposition.hitInfo = selector;
            break;
        }
        if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
            if (entityplayer.field_71075_bZ.field_75102_a || this.getThrower() != null && this.getThrower() instanceof EntityPlayer && !((EntityPlayer)this.getThrower()).func_96122_a(entityplayer)) {
                movingobjectposition = null;
            }
        }
        return movingobjectposition;
    }

    public void doRotation() {
        if (this.doTargeting()) {
            return;
        }
        float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
    }

    public void normalizeRotation() {
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    protected void destructEntity(Entity target) {
        if (this.thrower == null) {
            return;
        }
        StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.DestructObject);
        boolean isDestruction = true;
        if (target instanceof EntityFireball) {
            if (((EntityFireball)target).field_70235_a != null && ((EntityFireball)target).field_70235_a.func_145782_y() == this.thrower.func_145782_y()) {
                isDestruction = false;
            } else if (this.thrower instanceof EntityLivingBase) {
                isDestruction = !target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)((EntityLivingBase)this.thrower)), this.AttackLevel);
            }
        } else if (target instanceof EntityArrow) {
            if (((EntityArrow)target).field_70250_c != null && ((EntityArrow)target).field_70250_c.func_145782_y() == this.thrower.func_145782_y()) {
                isDestruction = false;
            }
        } else if (target instanceof EntityThrowable && ((EntityThrowable)target).func_85052_h() != null && ((EntityThrowable)target).func_85052_h().func_145782_y() == this.thrower.func_145782_y()) {
            isDestruction = false;
        }
        if (isDestruction && target instanceof IThrowableEntity && ((IThrowableEntity)target).getThrower() != null && ((IThrowableEntity)target).getThrower().func_145782_y() == this.thrower.func_145782_y()) {
            isDestruction = false;
        }
        if (isDestruction) {
            ReflectionAccessHelper.setVelocity(target, 0.0, 0.0, 0.0);
            target.func_70106_y();
            for (int var1 = 0; var1 < 10; ++var1) {
                Random rand = this.getRand();
                double var2 = rand.nextGaussian() * 0.02;
                double var4 = rand.nextGaussian() * 0.02;
                double var6 = rand.nextGaussian() * 0.02;
                double var8 = 10.0;
                this.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, target.field_70165_t + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - var2 * var8, target.field_70163_u + (double)(rand.nextFloat() * target.field_70131_O) - var4 * var8, target.field_70161_v + (double)(rand.nextFloat() * target.field_70130_N * 2.0f) - (double)target.field_70130_N - var6 * var8, var2, var4, var6, new int[0]);
            }
        }
        StylishRankManager.doAttack(this.thrower);
        this.func_70106_y();
    }

    protected void attackEntity(Entity target) {
        if (this.thrower != null) {
            this.thrower.getEntityData().func_74768_a("LastHitSummonedSwords", this.func_145782_y());
        }
        this.mountEntity(target);
        if (!this.field_70170_p.field_72995_K) {
            float magicDamage = Math.max(1.0f, this.AttackLevel);
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (!this.blade.func_190926_b() && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                ReflectionAccessHelper.setVelocity(target, 0.0, 0.0, 0.0);
                target.func_70024_g(0.0, 0.1, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
        }
    }

    protected void blastAttackEntity(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            float magicDamage = 1.0f;
            target.field_70172_ad = 0;
            DamageSource ds = new EntityDamageSource("directMagic", this.getThrower()).func_76348_h().func_82726_p();
            target.func_70097_a(ds, magicDamage);
            if (!this.blade.func_190926_b() && target instanceof EntityLivingBase && this.thrower != null && this.thrower instanceof EntityLivingBase) {
                StylishRankManager.setNextAttackType(this.thrower, StylishRankManager.AttackTypes.PhantomSword);
                ((ItemSlashBlade)this.blade.func_77973_b()).func_77644_a(this.blade, (EntityLivingBase)target, (EntityLivingBase)this.thrower);
                ReflectionAccessHelper.setVelocity(target, 0.0, 0.0, 0.0);
                target.func_70024_g(0.0, 0.1, 0.0);
                ((EntityLivingBase)target).field_70737_aN = 1;
                ((ItemSlashBlade)this.blade.func_77973_b()).setDaunting((EntityLivingBase)target);
            }
        }
    }

    protected boolean onImpact(RayTraceResult mop) {
        boolean result = true;
        if (mop.field_72308_g != null) {
            Entity target = mop.field_72308_g;
            if (mop.hitInfo.equals(EntitySelectorAttackable.getInstance())) {
                this.attackEntity(target);
            } else {
                this.destructEntity(target);
            }
        } else if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            if (this.getThrower() != null && this.getThrower() instanceof EntityPlayer) {
                ((EntityPlayer)this.getThrower()).func_71009_b((Entity)this);
            }
            result = false;
        }
        return result;
    }

    public void spawnParticle() {
        if (this.func_70090_H()) {
            for (int l = 0; l < 4; ++l) {
                float trailLength = 0.25f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)trailLength, this.field_70163_u - this.field_70181_x * (double)trailLength, this.field_70161_v - this.field_70179_y * (double)trailLength, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
            }
        }
    }

    public void calculateSpeed() {
        float speedReductionFactor = 1.1f;
        if (this.func_70090_H()) {
            speedReductionFactor = 1.0f;
        }
        this.field_70159_w *= (double)speedReductionFactor;
        this.field_70181_x *= (double)speedReductionFactor;
        this.field_70179_y *= (double)speedReductionFactor;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.ridingEntity2 != null) {
            this.func_70098_U();
        } else {
            if (this.field_70173_aa >= this.getLifeTime()) {
                this.func_70106_y();
            }
            this.initRotation();
            RayTraceResult movingobjectposition = this.getRayTraceResult();
            if (movingobjectposition != null && this.onImpact(movingobjectposition)) {
                return;
            }
            this.calculateSpeed();
            this.doRotation();
            if (this.getInterval() < this.field_70173_aa) {
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.normalizeRotation();
            this.spawnParticle();
        }
    }

    public void func_70106_y() {
        if (this.thrower != null && this.thrower instanceof EntityPlayer) {
            ((EntityPlayer)this.thrower).func_71009_b((Entity)this);
        }
        this.field_70170_p.func_184148_a(null, this.field_70169_q, this.field_70167_r, this.field_70166_s, SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 0.25f, 1.6f);
        AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(1.0, 1.0, 1.0);
        List list = this.field_70170_p.func_175674_a((Entity)this, bb, EntitySelectorAttackable.getInstance());
        list.removeAll(this.alreadyHitEntity);
        for (Entity target : list) {
            if (target == null) continue;
            this.blastAttackEntity(target);
        }
        super.func_70106_y();
    }

    public Random getRand() {
        return this.field_70146_Z;
    }

    public boolean func_70038_c(double par1, double par3, double par5) {
        return false;
    }

    public void func_70091_d(MoverType moverType, double x, double y, double z) {
        super.func_70091_d(moverType, x, y, z);
    }

    protected void func_70081_e(int par1) {
    }

    public boolean func_70072_I() {
        return false;
    }

    public boolean func_70055_a(Material par1Material) {
        return false;
    }

    public boolean func_180799_ab() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b(float par1) {
        float f1 = 0.5f;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f1 > 1.0f) {
            f1 = 1.0f;
        }
        int i = super.func_70070_b(par1);
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f1 * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public float func_70013_c(float par1) {
        float f1 = super.func_70013_c(par1);
        float f2 = 0.9f;
        f2 = f2 * f2 * f2 * f2;
        return f1 * (1.0f - f2) + f2;
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public Entity func_184187_bx() {
        return this.ridingEntity2;
    }

    public void mountEntity(Entity par1Entity) {
        if (par1Entity != null) {
            this.hitYaw = this.field_70177_z - par1Entity.field_70177_z;
            this.hitPitch = this.field_70125_A - par1Entity.field_70125_A;
            this.hitX = this.field_70142_S - par1Entity.field_70165_t;
            this.hitY = this.field_70137_T - par1Entity.field_70163_u;
            this.hitZ = this.field_70136_U - par1Entity.field_70161_v;
            this.ridingEntity2 = par1Entity;
            this.field_70173_aa = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public void func_181015_d(BlockPos p_181015_1_) {
    }

    public boolean func_70027_ad() {
        return false;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public void func_70110_aj() {
    }

    public void func_70186_c(double v, double v2, double v3, float v4, float v5) {
    }

    public Entity getThrower() {
        int id;
        if (this.thrower == null && (id = this.getThrowerEntityId()) != 0) {
            this.thrower = this.func_130014_f_().func_73045_a(id);
        }
        return this.thrower;
    }

    public void setThrower(Entity entity) {
        if (entity != null) {
            this.setThrowerEntityId(entity.func_145782_y());
        }
        this.thrower = entity;
    }
}

