/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.entity.selector;

import com.google.common.base.Predicate;
import mods.flammpfeil.slashblade.core.ConfigEntityListManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraftforge.fml.common.registry.IThrowableEntity;

public final class EntitySelectorDestructable
implements Predicate<Entity> {
    private EntitySelectorDestructable() {
    }

    public static Predicate<Entity> getInstance() {
        return SingletonHolder.instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Entity input) {
        boolean result = false;
        String className = input.getClass().getSimpleName();
        if (ConfigEntityListManager.destructableTargets.containsKey(className)) {
            if (!input.func_70089_S()) return false;
            if (ConfigEntityListManager.destructableTargets.get(className) == false) return false;
            return true;
        }
        if (input instanceof IProjectile) return input.func_70089_S();
        if (input instanceof EntityTNTPrimed) return input.func_70089_S();
        if (input instanceof EntityFireball) return input.func_70089_S();
        if (!(input instanceof IThrowableEntity)) return result;
        return input.func_70089_S();
    }

    private static final class SingletonHolder {
        private static final Predicate<Entity> instance = new EntitySelectorDestructable();

        private SingletonHolder() {
        }
    }
}

