/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.specialeffect;

import java.util.Random;
import java.util.UUID;
import mods.flammpfeil.slashblade.ability.StylishRankManager;
import mods.flammpfeil.slashblade.capability.BladeCapabilityProvider;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.specialeffect.IRemovable;
import mods.flammpfeil.slashblade.specialeffect.ISpecialEffect;
import mods.flammpfeil.slashblade.specialeffect.SpecialEffects;
import mods.flammpfeil.slashblade.util.SlashBladeEvent;
import mods.flammpfeil.slashblade.util.SlashBladeHooks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class HFCustom
implements ISpecialEffect,
IRemovable {
    private static final String EffectKey = "HFCustom";
    public static int startupCost = 1000;
    public static int runningCost = 100;
    public static int energyCostBase = 200;
    public static final String tagEmpowered = "isEmpowered";

    private boolean useBlade(ItemSlashBlade.ComboSequence sequence) {
        if (sequence.useScabbard) {
            return false;
        }
        if (sequence == ItemSlashBlade.ComboSequence.None) {
            return false;
        }
        return sequence != ItemSlashBlade.ComboSequence.Noutou;
    }

    @SubscribeEvent
    public void onImpactEffectEvent(SlashBladeEvent.ImpactEffectEvent event) {
        if (!this.useBlade(event.sequence)) {
            return;
        }
        if (!SpecialEffects.isPlayer((Entity)event.user)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.user;
        switch (SpecialEffects.isEffective(player, event.blade, this)) {
            case None: {
                return;
            }
        }
        ItemStack blade = event.blade;
        if (!blade.hasCapability(BladeCapabilityProvider.ENERGY, null)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)blade.getCapability(BladeCapabilityProvider.ENERGY, null);
        if (storage == null) {
            return;
        }
        if (!HFCustom.isEmpowered(blade)) {
            return;
        }
        EntityLivingBase target = event.target;
        int effectLevel = ItemSlashBlade.getSpecialEffect(blade).func_74762_e(this.getEffectKey());
        int rank = StylishRankManager.getStylishRank((Entity)player);
        float damage = 0.5f * (float)(1 + rank + effectLevel);
        int usage = (int)((double)energyCostBase * Math.pow(1.2, rank + effectLevel));
        if (storage.extractEnergy(usage, false) == usage) {
            this.forceAttack(target, damage);
        }
    }

    @SubscribeEvent
    public void onUpdateItemSlashBlade(SlashBladeEvent.OnUpdateEvent event) {
        int check;
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!SpecialEffects.isPlayer(event.entity)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entity;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(event.blade);
        ItemStack blade = event.blade;
        switch (SpecialEffects.isEffective(player, event.blade, this)) {
            case None: {
                return;
            }
            case NonEffective: {
                break;
            }
        }
        this.updateEmpoweredState(player, blade);
        if (!HFCustom.isEmpowered(blade)) {
            return;
        }
        if (!blade.hasCapability(BladeCapabilityProvider.ENERGY, null)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)blade.getCapability(BladeCapabilityProvider.ENERGY, null);
        if (storage == null) {
            return;
        }
        if (player.field_70170_p instanceof WorldServer && player.field_70170_p.func_82737_E() % 10L == 0L && (player.func_184614_ca() != blade || !ItemSlashBlade.OnClick.get(tag).booleanValue() || !player.field_82175_bq && player.func_184607_cu() != null)) {
            storage.extractEnergy(runningCost, false);
            if (storage.getEnergyStored() <= 0) {
                this.setEmpoweredState(player, blade, false);
                return;
            }
            Random rand = player.func_70681_au();
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            ((WorldServer)player.field_70170_p).func_180505_a(EnumParticleTypes.FIREWORKS_SPARK, false, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, 1, d0, d1, d2, 0.25, new int[0]);
        }
        if (!this.useBlade(ItemSlashBlade.getComboSequence(tag))) {
            return;
        }
        PotionEffect haste = player.func_70660_b(MobEffects.field_76419_f);
        int n = haste != null ? (haste.func_76458_c() != 1 ? 3 : 4) : (check = 2);
        if (player.field_110158_av != check) {
            return;
        }
        blade.func_77972_a(1, (EntityLivingBase)player);
    }

    @Override
    public void register() {
        SlashBladeHooks.EventBus.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public int getDefaultRequiredLevel() {
        return 1;
    }

    @Override
    public String getEffectKey() {
        return EffectKey;
    }

    void forceAttack(EntityLivingBase target, float amount) {
        float health = target.func_110143_aJ();
        if (0.0f < health) {
            health = Math.max(1.0f, health - amount);
            target.func_70606_j(health);
        }
    }

    public static boolean isEmpowered(ItemStack blade) {
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(blade);
        return tag.func_74767_n(tagEmpowered);
    }

    public boolean canUse(ItemStack blade, EntityPlayer player) {
        UUID ownerid;
        boolean isOwner;
        NBTTagCompound tag = ItemSlashBlade.getItemTagCompound(blade);
        return !tag.func_186855_b("Owner") || (isOwner = (ownerid = tag.func_186857_a("Owner")).equals(player.func_110124_au()));
    }

    public boolean canEmpowered(ItemStack blade) {
        if (!blade.hasCapability(BladeCapabilityProvider.ENERGY, null)) {
            return false;
        }
        IEnergyStorage storage = (IEnergyStorage)blade.getCapability(BladeCapabilityProvider.ENERGY, null);
        if (storage == null) {
            return false;
        }
        return storage.getEnergyStored() >= startupCost;
    }

    public boolean setEmpoweredState(EntityPlayer player, ItemStack blade, boolean state) {
        if (HFCustom.isEmpowered(blade) == state) {
            return state;
        }
        boolean bl = state = state && this.canEmpowered(blade);
        if (state) {
            IEnergyStorage storage = (IEnergyStorage)blade.getCapability(BladeCapabilityProvider.ENERGY, null);
            storage.extractEnergy(startupCost, false);
        }
        blade.func_77983_a(tagEmpowered, (NBTBase)new NBTTagByte((byte)(state ? 1 : 0)));
        return state;
    }

    public void updateEmpoweredState(EntityPlayer player, ItemStack blade) {
        boolean newState;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        boolean currentState = HFCustom.isEmpowered(blade);
        if (this.canUse(blade, player)) {
            newState = currentState;
            if (player.func_184614_ca() == blade) {
                byte imputState = player.getEntityData().func_74771_c("SB.MCS");
                int imputStateMask = 96;
                if (96 == (imputState & 0x60)) {
                    newState = 16 != (imputState & 0x10);
                }
            }
        } else {
            newState = false;
        }
        if (currentState == (newState = this.setEmpoweredState(player, blade, newState))) {
            return;
        }
        if (newState) {
            player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70169_q, player.field_70167_r, player.field_70166_s, SoundEvents.field_187722_q, SoundCategory.NEUTRAL, 1.0f, 1.2f);
        }
        player.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70169_q, player.field_70167_r, player.field_70166_s, SoundEvents.field_187909_gi, SoundCategory.NEUTRAL, 0.25f, 2.0f);
    }

    @Override
    public boolean canCopy(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canRemoval(ItemStack stack) {
        return false;
    }
}

