--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.06.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.06.2019 - Release Version
V 1.1.0.0 @ 24.12.2019 - Optimise script and add mouse input support.

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefgt oder von der aktuellen Release-Form gendert werden.
An diesem Skript drfen ohne Genehmigung von GtX | Andy keine nderungen vorgenommen werden
]]


AnimalScreenExtended = {}

local AnimalScreenExtended_mt = Class(AnimalScreenExtended)

function AnimalScreenExtended.init()
    -- Only allow before mission creation.
    if g_currentMission == nil then

        FSBaseMission.loadMapFinished = Utils.prependedFunction(FSBaseMission.loadMapFinished, function()
            if g_animalScreen ~= nil and g_animalScreen.animalScreenExtended == nil then

                local animalScreenExtended = AnimalScreenExtended:new(g_animalScreen)
                g_animalScreen.animalScreenExtended = animalScreenExtended

                FSBaseMission.delete = Utils.appendedFunction(FSBaseMission.delete, animalScreenExtended.delete)

                print("  INFO: AnimalScreenExtended - Version 1.1.0.0 loaded successfully.")
            end
        end)

    end
end

function AnimalScreenExtended:new(animalScreen)
    local self = setmetatable({}, AnimalScreenExtended_mt)

    -- Hook up new 'AnimalScreen' functions.
    AnimalScreen.setNewTargetHeaderText_extended = AnimalScreenExtended.setNewTargetHeaderText_extended
    AnimalScreen.updateActionEvent_extended = AnimalScreenExtended.updateActionEvent_extended

    -- Inject functions
    AnimalScreen.onClose = Utils.appendedFunction(AnimalScreen.onClose, AnimalScreenExtended.onClose_extended)
    AnimalScreen.update = Utils.appendedFunction(AnimalScreen.update, AnimalScreenExtended.update_extended)
    AnimalScreen.updateChangedList = Utils.appendedFunction(AnimalScreen.updateChangedList, AnimalScreenExtended.updateChangedList_extended)

    animalScreen.elements[1].onOpenCallback = Utils.appendedFunction(animalScreen.elements[1].onOpenCallback, AnimalScreenExtended.onOpen_extended)

    -- Try and add mouse support if game updates do not change the xml layout.
    animalScreen.moveButton = self:getValidElement(animalScreen, {"1", "2", "1", "4", "1"})
    if animalScreen.moveButton ~= nil then
        animalScreen.moveButton.onClickCallback = Utils.overwrittenFunction(animalScreen.moveButton.onClickCallback, AnimalScreenExtended.onClickOk_extended)
    end

    return self
end

function AnimalScreenExtended:delete()
    if g_animalScreen ~= nil and g_animalScreen.animalScreenExtended ~= nil then

        AnimalScreen.setNewTargetHeaderText_extended = nil
        AnimalScreen.updateActionEvent_extended = nil

        g_animalScreen.animalScreenExtended = nil
    end
end

function AnimalScreenExtended:getValidElement(animalScreen, elements)
    local element = animalScreen

    for i = 1, #elements do
        element = element["elements"]

        if element == nil then
            return
        end

        local index = tonumber(elements[i])
        element = element[index]
    end

    return element
end

-------------------
-- New Functions --
-------------------

function AnimalScreenExtended.setNewTargetHeaderText_extended(dialog)
    if dialog.targetDataSource.data ~= nil then
        dialog.ase_numOfAnimals = #dialog.targetDataSource.data
    end

    dialog.headerTarget.text = string.format("%s (%d / %d)", dialog.ase_oldHeaderTarget, dialog.ase_numOfAnimals, dialog.ase_maxNumOfAnimals)
end

function AnimalScreenExtended.actionEventReturn(dialog, actionName, inputValue, callbackState, isAnalog)
    if not dialog.ase_mouseButtonPressed then
        if inputValue == 1 then
            dialog:updateActionEvent_extended()
        else
            dialog.ase_pressedCounter = -1
        end
    end
end

function AnimalScreenExtended.updateActionEvent_extended(dialog)
    if dialog.ase_pressedCounter ~= nil and dialog.ase_pressedCounter < 0 then
        dialog.ase_movingTextX = dialog.headerTarget:getTextPositionX()

        local height, _ = dialog.buttonApply:getTextHeight()
        if height == nil then
            height = 0.02
        end

        dialog.ase_movingTextY = dialog.buttonApply:getTextPositionY(height, 0)
        dialog.ase_movingTextSize = dialog.buttonApply.textSize

        dialog.ase_selectedState = dialog.isSourceSelected
        dialog.ase_pressedCountDown = 2
        dialog.ase_pressedCounter = 0
        dialog.ase_totalHoldTime = 0
    end
end

------------------------
-- Injected Functions --
------------------------

function AnimalScreenExtended.updateChangedList_extended(dialog, listElement, fallbackListElement, restoreSelection)
    if restoreSelection then
        dialog:setNewTargetHeaderText_extended()
    end

    if dialog.ase_pressedCounter == -2 then
        dialog.ase_totalHoldTime = Utils.getNoNil(dialog.ase_totalHoldTime, 0) + 1

        if dialog.ase_totalHoldTime > 20 then
            dialog.ase_pressedCounter = 1.9
        else
            dialog.ase_pressedCounter = 1.7
        end
    end
end

function AnimalScreenExtended.update_extended(dialog, dt)
    if dialog.moveButton ~= nil then
        if dialog.moveButton.mouseDown then
            if not dialog.ase_mouseButtonPressed then
                dialog.ase_mouseButtonPressed = true
                dialog:updateActionEvent_extended()
            end
        else
            if dialog.ase_mouseButtonPressed then
                dialog.ase_mouseButtonPressed = false
                dialog.ase_pressedCounter = -1
            end
        end
    end

    if dialog.ase_pressedCounter ~= nil and dialog.ase_pressedCounter >= 0 then
        if dialog.isSourceSelected == dialog.ase_selectedState then
            dialog.ase_pressedCounter = dialog.ase_pressedCounter + (dt * 0.001)

            if dialog.ase_pressedCounter > 2 then
                dialog.ase_pressedCounter = -2

                if dialog.ase_mouseButtonPressed then
                    dialog.ase_blockMouseInput = true
                end

                if dialog.isSourceSelected then
                    dialog.animalController:moveToTarget(dialog.listSource.selectedIndex)
                else
                    dialog.animalController:moveToSource(dialog.listTarget.selectedIndex)
                end

                dialog.sourceDataSource:notifyChange()
                dialog.targetDataSource:notifyChange()
            end

            if dialog.ase_maxNumOfAnimals ~= nil and dialog.ase_numOfAnimals ~= nil then
                if dialog.ase_numOfAnimals < dialog.ase_maxNumOfAnimals then
                    local x = dialog.ase_movingTextX or 0.698
                    local y = dialog.ase_movingTextY or 0.126
                    local size = dialog.ase_movingTextSize or 0.018

                    setTextBold(true)

                    if dialog.ase_pressedCountDown > 0 then
                        dialog.ase_pressedCountDown = dialog.ase_pressedCountDown - (dt * 0.001)
                        if dialog.ase_pressedCountDown < 1.7 then
                            renderText(x, y, size, string.format("PRESSED %.1f", dialog.ase_pressedCountDown))
                            dialog.ase_movingDots = 0
                        end
                    else
                        if dialog.ase_movingDots == nil or dialog.ase_movingDots <= 0.4 then
                            renderText(x, y, size, "MOVING")
                            if dialog.ase_movingDots == nil then
                                dialog.ase_movingDots = (dt * 0.001)
                            else
                                dialog.ase_movingDots = dialog.ase_movingDots + (dt * 0.001)
                            end
                        elseif dialog.ase_movingDots >= 0.4 and dialog.ase_movingDots <= 0.9 then
                            renderText(x, y, size, "MOVING.")
                            dialog.ase_movingDots = dialog.ase_movingDots + (dt * 0.001)
                        elseif dialog.ase_movingDots >= 0.9 and dialog.ase_movingDots <= 1.3 then
                            renderText(x, y, size, "MOVING..")
                            dialog.ase_movingDots = dialog.ase_movingDots + (dt * 0.001)
                        elseif dialog.ase_movingDots >= 1.3 and dialog.ase_movingDots <= 1.7 then
                            renderText(x, y, size, "MOVING...")
                            dialog.ase_movingDots = dialog.ase_movingDots + (dt * 0.001)
                            if dialog.ase_movingDots >= 1.7 then
                                renderText(x, y, size, "MOVING")
                                dialog.ase_movingDots = (dt * 0.001)
                            end
                        end
                    end

                    setTextBold(false)
                end
            end
        else
            dialog.ase_pressedCounter = -1
        end
    end
end

function AnimalScreenExtended.onOpen_extended(dialog)
    dialog.ase_pressedCounter = -1

    dialog.ase_oldHeaderTarget = dialog.headerTarget.text

    dialog.ase_numOfAnimals = 0
    dialog.ase_maxNumOfAnimals = 0

    dialog.ase_blockMouseInput = false

    if dialog.animalController ~= nil and dialog.animalController.husbandry ~= nil then
        local animalsModule = dialog.animalController.husbandry:getModuleByName("animals")

        if animalsModule ~= nil then
            dialog.ase_maxNumOfAnimals = animalsModule:getMaxNumOfAnimals()
        end
    end

    dialog:setNewTargetHeaderText_extended()

    local valid, eventId = g_inputBinding:registerActionEvent(InputAction.MENU_ACCEPT, dialog, AnimalScreenExtended.actionEventReturn, false, false, true, true, nil)
    g_inputBinding:setActionEventTextVisibility(eventId, false)
    dialog.animalScreenExtendedEventId = eventId
end

function AnimalScreenExtended.onClose_extended(dialog, element)
    g_inputBinding:removeActionEvent(dialog.animalScreenExtendedEventId)
    dialog.animalScreenExtendedEventId = nil

    dialog.ase_pressedCounter = -1

    dialog.headerTarget.text = dialog.ase_oldHeaderTarget
    dialog.ase_oldHeaderTarget = nil
end

function AnimalScreenExtended.onClickOk_extended(dialog, superFunc)
    if dialog.ase_blockMouseInput then
        dialog.ase_blockMouseInput = false

        return true
    end

    return superFunc(dialog)
end

AnimalScreenExtended.init()
