/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.internal.asm;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONPathCompilerReflect;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.ObjBoolConsumer;
import com.alibaba.fastjson2.function.ObjByteConsumer;
import com.alibaba.fastjson2.function.ObjCharConsumer;
import com.alibaba.fastjson2.function.ObjFloatConsumer;
import com.alibaba.fastjson2.function.ObjShortConsumer;
import com.alibaba.fastjson2.internal.asm.ClassReader;
import com.alibaba.fastjson2.internal.asm.TypeCollector;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReader1;
import com.alibaba.fastjson2.reader.ObjectReader10;
import com.alibaba.fastjson2.reader.ObjectReader11;
import com.alibaba.fastjson2.reader.ObjectReader12;
import com.alibaba.fastjson2.reader.ObjectReader2;
import com.alibaba.fastjson2.reader.ObjectReader3;
import com.alibaba.fastjson2.reader.ObjectReader4;
import com.alibaba.fastjson2.reader.ObjectReader5;
import com.alibaba.fastjson2.reader.ObjectReader6;
import com.alibaba.fastjson2.reader.ObjectReader7;
import com.alibaba.fastjson2.reader.ObjectReader8;
import com.alibaba.fastjson2.reader.ObjectReader9;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.UnsafeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriter1;
import com.alibaba.fastjson2.writer.ObjectWriter10;
import com.alibaba.fastjson2.writer.ObjectWriter11;
import com.alibaba.fastjson2.writer.ObjectWriter12;
import com.alibaba.fastjson2.writer.ObjectWriter2;
import com.alibaba.fastjson2.writer.ObjectWriter3;
import com.alibaba.fastjson2.writer.ObjectWriter4;
import com.alibaba.fastjson2.writer.ObjectWriter5;
import com.alibaba.fastjson2.writer.ObjectWriter6;
import com.alibaba.fastjson2.writer.ObjectWriter7;
import com.alibaba.fastjson2.writer.ObjectWriter8;
import com.alibaba.fastjson2.writer.ObjectWriter9;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.time.format.DateTimeParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;

public class ASMUtils {
    static Map<Class, String> descMapping;
    static Map<Class, String> typeMapping;
    static final AtomicReference<char[]> descCacheRef;

    public static String type(Class<?> clazz) {
        String type = typeMapping.get(clazz);
        if (type != null) {
            return type;
        }
        if (clazz.isArray()) {
            return "[" + ASMUtils.desc(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        return clazz.getName().replace('.', '/');
    }

    public static String desc(Class<?> clazz) {
        String className;
        String desc = descMapping.get(clazz);
        if (desc != null) {
            return desc;
        }
        if (clazz.isPrimitive()) {
            return typeMapping.get(clazz);
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            switch (componentType.getName()) {
                case "com.alibaba.fastjson2.writer.FieldWriter": {
                    return "[Lcom/alibaba/fastjson2/writer/FieldWriter;";
                }
                case "com.alibaba.fastjson2.reader.FieldReader": {
                    return "[Lcom/alibaba/fastjson2/reader/FieldReader;";
                }
            }
            return "[" + ASMUtils.desc(componentType);
        }
        switch (className = clazz.getName()) {
            case "java.util.Date": {
                return "Ljava/util/Date;";
            }
            case "java.lang.String": {
                return "Ljava/lang/String;";
            }
            case "com.alibaba.fastjson2.writer.ObjectWriter": {
                return "Lcom/alibaba/fastjson2/writer/ObjectWriter;";
            }
            case "com.alibaba.fastjson2.JSONWriter": {
                return "Lcom/alibaba/fastjson2/JSONWriter;";
            }
            case "com.alibaba.fastjson2.writer.FieldWriter": {
                return "Lcom/alibaba/fastjson2/writer/FieldWriter;";
            }
            case "com.alibaba.fastjson2.JSONReader": {
                return "Lcom/alibaba/fastjson2/JSONReader;";
            }
            case "com.alibaba.fastjson2.reader.FieldReader": {
                return "Lcom/alibaba/fastjson2/reader/FieldReader;";
            }
            case "com.alibaba.fastjson2.reader.ObjectReader": {
                return "Lcom/alibaba/fastjson2/reader/ObjectReader;";
            }
            case "java.util.function.Supplier": {
                return "Ljava/util/function/Supplier;";
            }
            case "com.alibaba.fastjson2.schema.JSONSchema": {
                return "Lcom/alibaba/fastjson2/schema/JSONSchema;";
            }
            case "com.alibaba.fastjson2.annotation.JSONType": {
                return "Lcom/alibaba/fastjson2/annotation/JSONType;";
            }
        }
        char[] chars = descCacheRef.getAndSet(null);
        if (chars == null) {
            chars = new char[512];
        }
        chars[0] = 76;
        className.getChars(0, className.length(), chars, 1);
        for (int i = 1; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            chars[i] = 47;
        }
        chars[className.length() + 1] = 59;
        String str = new String(chars, 0, className.length() + 2);
        descCacheRef.compareAndSet(null, chars);
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] lookupParameterNames(AccessibleObject methodOrCtor) {
        String className;
        String resourceName;
        InputStream is;
        int paramCount;
        Class<Object> declaringClass;
        String name;
        Class<?>[] types;
        if (methodOrCtor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrCtor;
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            Class declaringClass2 = constructor.getDeclaringClass();
            if (declaringClass2 == DateTimeParseException.class) {
                if (parameterTypes.length == 3) {
                    if (parameterTypes[0] == String.class && parameterTypes[1] == CharSequence.class && parameterTypes[2] == Integer.TYPE) {
                        return new String[]{"message", "parsedString", "errorIndex"};
                    }
                } else if (parameterTypes.length == 4 && parameterTypes[0] == String.class && parameterTypes[1] == CharSequence.class && parameterTypes[2] == Integer.TYPE && parameterTypes[3] == Throwable.class) {
                    return new String[]{"message", "parsedString", "errorIndex", "cause"};
                }
            }
            if (Throwable.class.isAssignableFrom(declaringClass2)) {
                switch (parameterTypes.length) {
                    case 1: {
                        if (parameterTypes[0] == String.class) {
                            return new String[]{"message"};
                        }
                        if (!Throwable.class.isAssignableFrom(parameterTypes[0])) break;
                        return new String[]{"cause"};
                    }
                    case 2: {
                        if (parameterTypes[0] != String.class || !Throwable.class.isAssignableFrom(parameterTypes[1])) break;
                        return new String[]{"message", "cause"};
                    }
                }
            }
        }
        if (methodOrCtor instanceof Method) {
            Method method = (Method)methodOrCtor;
            types = method.getParameterTypes();
            name = method.getName();
            declaringClass = method.getDeclaringClass();
            paramCount = method.getParameterCount();
        } else {
            Constructor constructor = (Constructor)methodOrCtor;
            types = constructor.getParameterTypes();
            declaringClass = constructor.getDeclaringClass();
            name = "<init>";
            paramCount = constructor.getParameterCount();
        }
        if (types.length == 0) {
            return new String[paramCount];
        }
        ClassLoader classLoader = declaringClass.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((is = classLoader.getResourceAsStream(resourceName = (className = declaringClass.getName()).replace('.', '/') + ".class")) == null) {
            return new String[paramCount];
        }
        try {
            Class<?> dd;
            ClassReader reader = new ClassReader(is);
            TypeCollector visitor = new TypeCollector(name, types);
            reader.accept(visitor);
            String[] params = visitor.getParameterNamesForMethod();
            if (params != null && params.length == paramCount - 1 && (dd = declaringClass.getDeclaringClass()) != null && dd.equals(types[0])) {
                String[] strings = new String[paramCount];
                strings[0] = "this$0";
                System.arraycopy(params, 0, strings, 1, params.length);
                params = strings;
            }
            String[] stringArray = params;
            return stringArray;
        }
        catch (IOException e) {
            String[] stringArray = new String[paramCount];
            return stringArray;
        }
        finally {
            IOUtils.close(is);
        }
    }

    static {
        Class[] classes;
        descMapping = new HashMap<Class, String>();
        typeMapping = new HashMap<Class, String>();
        descMapping.put(Integer.TYPE, "I");
        descMapping.put(Void.TYPE, "V");
        descMapping.put(Boolean.TYPE, "Z");
        descMapping.put(Character.TYPE, "C");
        descMapping.put(Byte.TYPE, "B");
        descMapping.put(Short.TYPE, "S");
        descMapping.put(Float.TYPE, "F");
        descMapping.put(Long.TYPE, "J");
        descMapping.put(Double.TYPE, "D");
        descMapping.put(List.class, "Ljava/util/List;");
        typeMapping.put(Collection.class, "Ljava/util/Collection;");
        typeMapping.put(Integer.TYPE, "I");
        typeMapping.put(Void.TYPE, "V");
        typeMapping.put(Boolean.TYPE, "Z");
        typeMapping.put(Character.TYPE, "C");
        typeMapping.put(Byte.TYPE, "B");
        typeMapping.put(Short.TYPE, "S");
        typeMapping.put(Float.TYPE, "F");
        typeMapping.put(Long.TYPE, "J");
        typeMapping.put(Double.TYPE, "D");
        for (Class objectType : classes = new Class[]{String.class, List.class, Collection.class, ObjectReader.class, ObjectReader1.class, ObjectReader2.class, ObjectReader3.class, ObjectReader4.class, ObjectReader5.class, ObjectReader6.class, ObjectReader7.class, ObjectReader8.class, ObjectReader9.class, ObjectReader10.class, ObjectReader11.class, ObjectReader12.class, ObjectReaderAdapter.class, FieldReader.class, JSONReader.class, ObjBoolConsumer.class, ObjCharConsumer.class, ObjByteConsumer.class, ObjShortConsumer.class, ObjIntConsumer.class, ObjLongConsumer.class, ObjFloatConsumer.class, ObjDoubleConsumer.class, BiConsumer.class, UnsafeUtils.class, ObjectWriter.class, ObjectWriterAdapter.class, ObjectWriter1.class, ObjectWriter2.class, ObjectWriter3.class, ObjectWriter4.class, ObjectWriter5.class, ObjectWriter6.class, ObjectWriter7.class, ObjectWriter8.class, ObjectWriter9.class, ObjectWriter10.class, ObjectWriter11.class, ObjectWriter12.class, FieldWriter.class, JSONPathCompilerReflect.SingleNamePathTyped.class, JSONWriter.class, JSONWriter.Context.class, JSONB.class}) {
            typeMapping.put(objectType, objectType.getName().replace('.', '/'));
        }
        descCacheRef = new AtomicReference();
    }
}

