/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderPrimitive;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;

class ObjectReaderInterfaceImpl
extends ObjectReaderPrimitive {
    final Type interfaceType;

    public ObjectReaderInterfaceImpl(Type interfaceType) {
        super(TypeUtils.getClass(interfaceType));
        this.interfaceType = interfaceType;
    }

    @Override
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object value;
        if (jsonReader.nextIfMatch('{')) {
            long hash = jsonReader.readFieldNameHashCode();
            JSONReader.Context context = jsonReader.getContext();
            if (hash == HASH_TYPE && context.isEnabled(JSONReader.Feature.SupportAutoType)) {
                String typeName;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader autoTypeObjectReader = context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), this.objectClass)) == null) {
                    throw new JSONException(jsonReader.info("auoType not support : " + typeName));
                }
                return autoTypeObjectReader.readObject(jsonReader, fieldType, fieldName, 0L);
            }
            return ObjectReaderImplMap.INSTANCE.readObject(jsonReader, fieldType, fieldName, 0L);
        }
        switch (jsonReader.current()) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                value = jsonReader.readNumber();
                break;
            }
            case '[': {
                value = jsonReader.readArray();
                break;
            }
            case '\"': 
            case '\'': {
                value = jsonReader.readString();
                break;
            }
            case 'f': 
            case 't': {
                value = jsonReader.readBoolValue();
                break;
            }
            case 'n': {
                jsonReader.readNull();
                value = null;
                break;
            }
            default: {
                throw new JSONException(jsonReader.info());
            }
        }
        return value;
    }

    @Override
    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return jsonReader.readAny();
    }
}

