/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public class JDKUtils {
    public static final int JVM_VERSION;
    public static final Byte LATIN1;
    public static final Byte UTF16;
    static final Field FIELD_STRING_VALUE;
    static final long FIELD_STRING_VALUE_OFFSET;
    static volatile boolean FIELD_VALUE_STRING_ERROR;
    static final Class<?> CLASS_SQL_DATASOURCE;
    static final Class<?> CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final boolean ANDROID;
    public static final boolean GRAAL;
    public static final Class CLASS_TRANSIENT;
    public static final boolean BIG_ENDIAN;
    public static final boolean UNSAFE_SUPPORT;
    public static final boolean VECTOR_SUPPORT;
    public static final BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
    public static final BiFunction<byte[], Byte, String> STRING_CREATOR_JDK11;
    public static final ToIntFunction<String> STRING_CODER;
    public static final Function<String, byte[]> STRING_VALUE;
    static final MethodHandles.Lookup IMPL_LOOKUP;
    static final boolean OPEN_J9;
    static volatile MethodHandle CONSTRUCTOR_LOOKUP;
    static volatile boolean CONSTRUCTOR_LOOKUP_ERROR;
    static volatile Throwable initErrorLast;
    static volatile Throwable reflectErrorLast;
    static final AtomicInteger reflectErrorCount;

    public static boolean isSQLDataSourceOrRowSet(Class<?> type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_DATASOURCE.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    public static void setReflectErrorLast(Throwable error) {
        reflectErrorCount.incrementAndGet();
        reflectErrorLast = error;
    }

    public static char[] getCharArray(String str) {
        if (!FIELD_VALUE_STRING_ERROR) {
            try {
                return (char[])UnsafeUtils.UNSAFE.getObject(str, FIELD_STRING_VALUE_OFFSET);
            }
            catch (Exception ignored) {
                FIELD_VALUE_STRING_ERROR = true;
            }
        }
        return str.toCharArray();
    }

    public static MethodHandles.Lookup trustedLookup(Class objectClass) {
        if (!CONSTRUCTOR_LOOKUP_ERROR) {
            try {
                int TRUSTED = -1;
                MethodHandle constructor = CONSTRUCTOR_LOOKUP;
                if (JVM_VERSION < 15) {
                    if (constructor == null) {
                        CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Integer.TYPE));
                    }
                    int FULL_ACCESS_MASK = 31;
                    return constructor.invoke(objectClass, OPEN_J9 ? FULL_ACCESS_MASK : TRUSTED);
                }
                if (constructor == null) {
                    CONSTRUCTOR_LOOKUP = constructor = IMPL_LOOKUP.findConstructor(MethodHandles.Lookup.class, MethodType.methodType(Void.TYPE, Class.class, Class.class, Integer.TYPE));
                }
                return constructor.invoke(objectClass, null, TRUSTED);
            }
            catch (Throwable ignored) {
                CONSTRUCTOR_LOOKUP_ERROR = true;
            }
        }
        return IMPL_LOOKUP.in(objectClass);
    }

    static {
        boolean unsafeSupport;
        LATIN1 = 0;
        UTF16 = 1;
        reflectErrorCount = new AtomicInteger();
        int jvmVersion = -1;
        boolean openj9 = false;
        boolean android = false;
        boolean graal = false;
        try {
            String javaSpecVer;
            String jmvName = System.getProperty("java.vm.name");
            openj9 = jmvName.contains("OpenJ9");
            android = jmvName.equals("Dalvik");
            graal = jmvName.equals("Substrate VM");
            if (openj9 || android || graal) {
                FIELD_VALUE_STRING_ERROR = true;
            }
            if ((javaSpecVer = System.getProperty("java.specification.version")).startsWith("1.")) {
                javaSpecVer = javaSpecVer.substring(2);
            }
            if (javaSpecVer.indexOf(46) == -1) {
                jvmVersion = Integer.parseInt(javaSpecVer);
            }
        }
        catch (Throwable ignored) {
            initErrorLast = ignored;
        }
        OPEN_J9 = openj9;
        ANDROID = android;
        GRAAL = graal;
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable ignored) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        Class<?> transientClass = null;
        if (!android) {
            try {
                transientClass = Class.forName("java.beans.Transient");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        CLASS_TRANSIENT = transientClass;
        JVM_VERSION = jvmVersion;
        if (JVM_VERSION == 8) {
            Field field = null;
            long fieldOffset = -1L;
            try {
                field = String.class.getDeclaredField("value");
                field.setAccessible(true);
                fieldOffset = UnsafeUtils.objectFieldOffset(field);
            }
            catch (Exception ignored) {
                FIELD_VALUE_STRING_ERROR = true;
            }
            FIELD_STRING_VALUE = field;
            FIELD_STRING_VALUE_OFFSET = fieldOffset;
        } else {
            FIELD_VALUE_STRING_ERROR = true;
            FIELD_STRING_VALUE = null;
            FIELD_STRING_VALUE_OFFSET = -1L;
        }
        boolean vector_support = false;
        try {
            if (JVM_VERSION >= 17) {
                Class<?> factorClass = Class.forName("java.lang.management.ManagementFactory");
                Class<?> runtimeMXBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
                Method getRuntimeMXBean = factorClass.getMethod("getRuntimeMXBean", new Class[0]);
                Object runtimeMXBean = getRuntimeMXBean.invoke(null, new Object[0]);
                Method getInputArguments = runtimeMXBeanClass.getMethod("getInputArguments", new Class[0]);
                List inputArguments = (List)getInputArguments.invoke(runtimeMXBean, new Object[0]);
                vector_support = inputArguments.contains("--add-modules=jdk.incubator.vector");
            }
        }
        catch (Throwable ignored) {
            initErrorLast = ignored;
        }
        VECTOR_SUPPORT = vector_support;
        UNSAFE_SUPPORT = unsafeSupport = ((Predicate<Object>)o -> {
            try {
                return UnsafeUtils.UNSAFE != null;
            }
            catch (Throwable ignored) {
                return false;
            }
        }).test(null);
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        BiFunction stringCreatorJDK8 = null;
        BiFunction stringCreatorJDK11 = null;
        ToIntFunction stringCoder = null;
        Function stringValue = null;
        MethodHandles.Lookup trustedLookup = null;
        try {
            Class<MethodHandles.Lookup> lookupClass = MethodHandles.Lookup.class;
            Field implLookup = lookupClass.getDeclaredField("IMPL_LOOKUP");
            long fieldOffset = UnsafeUtils.UNSAFE.staticFieldOffset(implLookup);
            trustedLookup = (MethodHandles.Lookup)UnsafeUtils.UNSAFE.getObject(lookupClass, fieldOffset);
        }
        catch (Throwable lookupClass) {
            // empty catch block
        }
        if (trustedLookup == null) {
            trustedLookup = MethodHandles.lookup();
        }
        IMPL_LOOKUP = trustedLookup;
        Boolean compact_strings = null;
        try {
            if (JVM_VERSION == 8 && trustedLookup != null) {
                MethodHandles.Lookup lookup = JDKUtils.trustedLookup(String.class);
                MethodHandle handle = lookup.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
                CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(BiFunction.class), MethodType.methodType(Object.class, Object.class, Object.class), handle, MethodType.methodType(String.class, char[].class, Boolean.TYPE));
                stringCreatorJDK8 = callSite.getTarget().invokeExact();
            }
            boolean lookupLambda = false;
            if (JVM_VERSION > 8 && trustedLookup != null && !android) {
                try {
                    Field compact_strings_field = String.class.getDeclaredField("COMPACT_STRINGS");
                    if (compact_strings_field != null) {
                        if (UNSAFE_SUPPORT) {
                            long fieldOffset = UnsafeUtils.UNSAFE.staticFieldOffset(compact_strings_field);
                            compact_strings = UnsafeUtils.UNSAFE.getBoolean(String.class, fieldOffset);
                        } else {
                            compact_strings_field.setAccessible(true);
                            compact_strings = (Boolean)compact_strings_field.get(null);
                        }
                    }
                }
                catch (Throwable ignored) {
                    initErrorLast = ignored;
                }
                boolean bl = lookupLambda = compact_strings != null && compact_strings != false;
            }
            if (lookupLambda) {
                MethodHandles.Lookup lookup = trustedLookup.in(String.class);
                MethodHandle handle = lookup.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
                CallSite callSite = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(BiFunction.class), MethodType.methodType(Object.class, Object.class, Object.class), handle, MethodType.methodType(String.class, byte[].class, Byte.class));
                stringCreatorJDK11 = callSite.getTarget().invokeExact();
                MethodHandle coder = lookup.findSpecial(String.class, "coder", MethodType.methodType(Byte.TYPE), String.class);
                CallSite applyAsInt = LambdaMetafactory.metafactory(lookup, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), coder, MethodType.methodType(Byte.TYPE, String.class));
                stringCoder = applyAsInt.getTarget().invokeExact();
                MethodHandle value = lookup.findSpecial(String.class, "value", MethodType.methodType(byte[].class), String.class);
                CallSite apply = LambdaMetafactory.metafactory(lookup, "apply", MethodType.methodType(Function.class), MethodType.methodType(Object.class, Object.class), value, MethodType.methodType(byte[].class, String.class));
                stringValue = apply.getTarget().invokeExact();
            }
        }
        catch (Throwable ignored) {
            initErrorLast = ignored;
        }
        if (stringCoder == null) {
            stringCoder = str -> 1;
        }
        STRING_CREATOR_JDK8 = stringCreatorJDK8;
        STRING_CREATOR_JDK11 = stringCreatorJDK11;
        STRING_CODER = stringCoder;
        STRING_VALUE = stringValue;
    }
}

