/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson;

import com.alibaba.fastjson.Fastjson1xReaderModule;
import com.alibaba.fastjson.Fastjson1xWriterModule;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ParseProcess;
import com.alibaba.fastjson.serializer.BeforeFilter;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.util.IOUtils;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.modules.ObjectReaderModule;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.support.AwtRederModule;
import com.alibaba.fastjson2.support.AwtWriterModule;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public abstract class JSON {
    private static TimeZone DEFAULT_TIME_ZONE = TimeZone.getDefault();
    public static final String VERSION = "2.0.24";
    static final Cache CACHE = new Cache();
    static final AtomicReferenceFieldUpdater<Cache, char[]> CHARS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Cache.class, char[].class, "chars");
    public static TimeZone defaultTimeZone = DEFAULT_TIME_ZONE;
    public static Locale defaultLocale = Locale.getDefault();
    public static String DEFAULT_TYPE_KEY = "@type";
    public static String DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static int DEFAULT_PARSER_FEATURE;
    public static int DEFAULT_GENERATE_FEATURE;
    static final Supplier<List> arraySupplier;
    static final Supplier<Map> defaultSupplier;
    static final Supplier<Map> orderedSupplier;

    public static JSONReader.Context createReadContext(int featuresValue, Feature ... features) {
        return JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), featuresValue, features);
    }

    static JSONReader.Context createReadContext(ObjectReaderProvider provider, int featuresValue, Feature ... features) {
        String defaultDateFormat;
        for (Feature feature : features) {
            featuresValue |= feature.mask;
        }
        JSONReader.Context context = new JSONReader.Context(provider);
        if ((featuresValue & Feature.UseBigDecimal.mask) == 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.UseBigDecimalForDoubles});
        }
        if ((featuresValue & Feature.SupportArrayToBean.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
        }
        if ((featuresValue & Feature.ErrorOnEnumNotMatch.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
        }
        if ((featuresValue & Feature.SupportNonPublicField.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
        }
        if ((featuresValue & Feature.SupportClassForName.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportClassForName});
        }
        if ((featuresValue & Feature.TrimStringFieldValue.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.TrimString});
        }
        if ((featuresValue & Feature.ErrorOnNotSupportAutoType.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnNotSupportAutoType});
        }
        if ((featuresValue & Feature.AllowUnQuotedFieldNames.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.AllowUnQuotedFieldNames});
        }
        if ((featuresValue & Feature.UseNativeJavaObject.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.UseNativeObject});
        } else {
            context.setArraySupplier(arraySupplier);
            context.setObjectSupplier((featuresValue & Feature.OrderedField.mask) != 0 ? orderedSupplier : defaultSupplier);
        }
        if ((featuresValue & Feature.NonStringKeyAsString.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.NonStringKeyAsString});
        }
        if ((featuresValue & Feature.DisableFieldSmartMatch.mask) == 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportSmartMatch});
        }
        if ((featuresValue & Feature.SupportAutoType.mask) != 0) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat = DEFFAULT_DATE_FORMAT)) {
            context.setDateFormat(defaultDateFormat);
        }
        context.config(new JSONReader.Feature[]{JSONReader.Feature.Base64StringAsByteArray});
        return context;
    }

    public static JSONObject parseObject(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]);
        JSONReader reader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static JSONObject parseObject(String text, Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader reader = JSONReader.of((String)text, (JSONReader.Context)context);
        String defaultDateFormat = DEFFAULT_DATE_FORMAT;
        if (!"yyyy-MM-dd HH:mm:ss".equals(defaultDateFormat)) {
            context.setDateFormat(defaultDateFormat);
        }
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] bytes, Charset charset, Type objectClass, ParserConfig config, ParseProcess processor, int featureValues, Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (config == null) {
            config = ParserConfig.global;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), featureValues, features);
        if (processor != null) {
            context.config((Filter)processor, new JSONReader.Feature[0]);
        }
        JSONReader jsonReader = JSONReader.of((byte[])bytes, (int)0, (int)bytes.length, (Charset)charset, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int len, Charset charset, Type objectType, ParserConfig config, ParseProcess processor, int featureValues, Feature ... features) {
        if (bytes == null || bytes.length == 0 || len == 0) {
            return null;
        }
        if (config == null) {
            config = ParserConfig.global;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), featureValues, features);
        if (processor != null) {
            context.config((Filter)processor, new JSONReader.Feature[0]);
        }
        JSONReader jsonReader = JSONReader.of((byte[])bytes, (int)offset, (int)len, (Charset)charset, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(char[] str, int length, Type objectType, Feature ... features) {
        if (str == null || str.length == 0) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((char[])str, (int)0, (int)length, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(char[] str, Class<T> objectClass, Feature ... features) {
        if (str == null || str.length == 0) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((char[])str, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Type objectClass, ParserConfig config, ParseProcess processor, int featureValues, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        if (config == null) {
            config = ParserConfig.global;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), featureValues, features);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        context.config((Filter)processor, new JSONReader.Feature[0]);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String input, Type clazz, ParserConfig config, int featureValues, Feature ... features) {
        return JSON.parseObject(input, clazz, config, null, featureValues, features);
    }

    public static <T> T parseObject(String str, Type objectType, ParseProcess processor, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        context.config((Filter)processor, new JSONReader.Feature[0]);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Class<T> objectClass, ParseProcess processor, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        context.config((Filter)processor, new JSONReader.Feature[0]);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, TypeReference typeReference, Feature ... features) {
        return JSON.parseObject(str, typeReference.getType(), features);
    }

    public static <T> T parseObject(String input, Type clazz, int featureValues, Feature ... features) {
        return JSON.parseObject(input, clazz, ParserConfig.global, featureValues, features);
    }

    public static <T> T parseObject(String str, Class<T> objectClass) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectClass);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Class<T> objectType, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Type objectType, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(String str, Type objectType, ParserConfig config, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), DEFAULT_PARSER_FEATURE, features);
        if (config.fieldBase) {
            context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
        }
        JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(InputStream is, Type objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Class<T> objectType, Feature ... features) throws IOException {
        return JSON.parseObject(is, StandardCharsets.UTF_8, objectType, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type objectType, ParserConfig config, ParseProcess processor, int featureValues, Feature ... features) throws IOException {
        if (is == null) {
            return null;
        }
        if (config == null) {
            config = ParserConfig.global;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), featureValues, features);
        if (processor != null) {
            context.config((Filter)processor, new JSONReader.Feature[0]);
        }
        JSONReader jsonReader = JSONReader.of((InputStream)is, (Charset)charset, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type type, ParserConfig config, Feature ... features) throws IOException {
        return JSON.parseObject(is, charset, type, config, null, DEFAULT_PARSER_FEATURE, features);
    }

    public static <T> T parseObject(InputStream is, Charset charset, Type objectType, Feature ... features) throws IOException {
        if (is == null) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((InputStream)is, (Charset)charset, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(objectType);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> JSONObject parseObject(byte[] jsonBytes, Feature ... features) {
        if (jsonBytes == null || jsonBytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader reader = JSONReader.of((byte[])jsonBytes, (JSONReader.Context)context);
        boolean ordered = false;
        for (Feature feature : features) {
            if (feature != Feature.OrderedField) continue;
            ordered = true;
            break;
        }
        try {
            LinkedHashMap<String, Object> map = ordered ? new LinkedHashMap() : new HashMap();
            reader.read(map, 0L);
            JSONObject jsonObject = new JSONObject(map);
            reader.handleResolveTasks((Object)jsonObject);
            return jsonObject;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((byte[])jsonBytes, (JSONReader.Context)context);
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> T parseObject(byte[] jsonBytes, Type type, SerializeFilter filter, Feature ... features) {
        if (jsonBytes == null) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        JSONReader jsonReader = JSONReader.of((byte[])jsonBytes, (JSONReader.Context)context);
        if (filter instanceof Filter) {
            context.config((Filter)filter, new JSONReader.Feature[0]);
        }
        try {
            ObjectReader objectReader = jsonReader.getObjectReader(type);
            Object object = objectReader.readObject(jsonReader, null, null, 0L);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            return (T)object;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]);
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    public static Object parse(String text, int features) {
        return JSON.parse(text, ParserConfig.global, features);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, Feature ... features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, ParserConfig config, Feature ... features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), DEFAULT_PARSER_FEATURE, features);
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.read(Object.class);
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, ParserConfig config) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]);
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(String str, ParserConfig config, int features) {
        if (str == null) return null;
        if (str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(config.getProvider(), features, new Feature[0]);
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object parse(byte[] utf8Bytes, Feature ... features) {
        if (utf8Bytes == null) return null;
        if (utf8Bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
        try (JSONReader jsonReader = JSONReader.of((byte[])utf8Bytes, (JSONReader.Context)context);){
            if (jsonReader.isObject() && !jsonReader.isSupportAutoType(0L)) {
                Object object2 = jsonReader.read(JSONObject.class);
                return object2;
            }
            Object object = jsonReader.readAny();
            return object;
        }
        catch (Exception ex) {
            throw new JSONException(ex.getMessage(), ex);
        }
    }

    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Feature ... features) {
        if (input == null || input.length == 0) {
            return null;
        }
        int featureValues = DEFAULT_PARSER_FEATURE;
        for (Feature feature : features) {
            featureValues = Feature.config(featureValues, feature, true);
        }
        return JSON.parse(input, off, len, charsetDecoder, featureValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(byte[] input, int off, int len, CharsetDecoder charsetDecoder, int features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charBuf = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charBuf);
            int position = charBuf.position();
            JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), features, new Feature[0]);
            JSONReader jsonReader = JSONReader.of((char[])chars, (int)0, (int)position, (JSONReader.Context)context);
            block9: for (Feature feature : Feature.values()) {
                if ((features & feature.mask) == 0) continue;
                switch (feature) {
                    case SupportArrayToBean: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportArrayToBean});
                        continue block9;
                    }
                    case SupportAutoType: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.SupportAutoType});
                        continue block9;
                    }
                    case ErrorOnEnumNotMatch: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.ErrorOnEnumNotMatch});
                    }
                    case SupportNonPublicField: {
                        context.config(new JSONReader.Feature[]{JSONReader.Feature.FieldBased});
                    }
                }
            }
            Object object = jsonReader.read(Object.class);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseObject(byte[] input, int off, int len, CharsetDecoder charsetDecoder, Type clazz, Feature ... features) {
        charsetDecoder.reset();
        int scaleLength = (int)((double)len * (double)charsetDecoder.maxCharsPerByte());
        char[] chars = CHARS_UPDATER.getAndSet(CACHE, null);
        if (chars == null || chars.length < scaleLength) {
            chars = new char[scaleLength];
        }
        try {
            ByteBuffer byteBuf = ByteBuffer.wrap(input, off, len);
            CharBuffer charByte = CharBuffer.wrap(chars);
            IOUtils.decode(charsetDecoder, byteBuf, charByte);
            int position = charByte.position();
            JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features);
            JSONReader jsonReader = JSONReader.of((char[])chars, (int)0, (int)position, (JSONReader.Context)context);
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
        finally {
            if (chars.length <= 65536) {
                CHARS_UPDATER.set(CACHE, chars);
            }
        }
    }

    public static <T> T parseObject(byte[] input, int off, int len, Charset charset, Type clazz, Feature ... features) {
        try (JSONReader jsonReader = JSONReader.of((byte[])input, (int)off, (int)len, (Charset)charset, (JSONReader.Context)JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features));){
            Object object = jsonReader.read(clazz);
            if (object != null) {
                jsonReader.handleResolveTasks(object);
            }
            Object object2 = object;
            return (T)object2;
        }
    }

    public static JSONWriter.Context createWriteContext(SerializeConfig config, int featuresValue, SerializerFeature ... features) {
        for (SerializerFeature feature : features) {
            featuresValue |= feature.mask;
        }
        JSONWriter.Context context = new JSONWriter.Context(config.getProvider());
        if (config.fieldBased) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased});
        }
        if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue && config.propertyNamingStrategy != PropertyNamingStrategy.CamelCase1x) {
            com.alibaba.fastjson.serializer.NameFilter nameFilter = com.alibaba.fastjson.serializer.NameFilter.of(config.propertyNamingStrategy);
            JSON.configFilter(context, nameFilter);
        }
        if ((featuresValue & SerializerFeature.DisableCircularReferenceDetect.mask) == 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
        }
        if ((featuresValue & SerializerFeature.UseISO8601DateFormat.mask) != 0) {
            context.setDateFormat("iso8601");
        } else {
            context.setDateFormat("millis");
        }
        if ((featuresValue & SerializerFeature.WriteMapNullValue.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteMapNullValue});
        }
        if ((featuresValue & SerializerFeature.WriteNullListAsEmpty.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullListAsEmpty});
        }
        if ((featuresValue & SerializerFeature.WriteNullStringAsEmpty.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullStringAsEmpty});
        }
        if ((featuresValue & SerializerFeature.WriteNullNumberAsZero.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullNumberAsZero});
        }
        if ((featuresValue & SerializerFeature.WriteNullBooleanAsFalse.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNullBooleanAsFalse});
        }
        if ((featuresValue & SerializerFeature.BrowserCompatible.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.BrowserCompatible});
        }
        if ((featuresValue & SerializerFeature.WriteClassName.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName});
        }
        if ((featuresValue & SerializerFeature.WriteNonStringValueAsString.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringValueAsString});
        }
        if ((featuresValue & SerializerFeature.WriteEnumUsingToString.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumUsingToString});
        }
        if ((featuresValue & SerializerFeature.WriteEnumUsingName.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteEnumsUsingName});
        }
        if ((featuresValue & SerializerFeature.NotWriteRootClassName.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteRootClassName});
        }
        if ((featuresValue & SerializerFeature.IgnoreErrorGetter.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreErrorGetter});
        }
        if ((featuresValue & SerializerFeature.WriteDateUseDateFormat.mask) != 0) {
            context.setDateFormat(DEFFAULT_DATE_FORMAT);
        }
        if ((featuresValue & SerializerFeature.BeanToArray.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.BeanToArray});
        }
        if ((featuresValue & SerializerFeature.UseSingleQuotes.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.UseSingleQuotes});
        }
        if ((featuresValue & SerializerFeature.MapSortField.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.MapSortField});
        }
        if ((featuresValue & SerializerFeature.PrettyFormat.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
        }
        if ((featuresValue & SerializerFeature.WriteNonStringKeyAsString.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteNonStringKeyAsString});
        }
        if ((featuresValue & SerializerFeature.IgnoreNonFieldGetter.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.IgnoreNonFieldGetter});
        }
        if ((featuresValue & SerializerFeature.NotWriteDefaultValue.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.NotWriteDefaultValue});
        }
        if ((featuresValue & SerializerFeature.WriteBigDecimalAsPlain.mask) != 0) {
            context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteBigDecimalAsPlain});
        }
        if (defaultTimeZone != null && defaultTimeZone != DEFAULT_TIME_ZONE) {
            context.setZoneId(defaultTimeZone.toZoneId());
        }
        context.config(new JSONWriter.Feature[]{JSONWriter.Feature.WriteByteArrayAsBase64});
        return context;
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        Object valueClass2;
        block13: {
            JSONWriter.Context context = JSON.createWriteContext(config, defaultFeatures, features);
            if (dateFormat != null && !dateFormat.isEmpty()) {
                context.setDateFormat(dateFormat);
            }
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block13;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter[] filters, SerializerFeature ... features) {
        return JSON.toJSONString(object, config, filters, null, DEFAULT_GENERATE_FEATURE, features);
    }

    public static String toJSONString(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        Object valueClass2;
        block12: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block12;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static void configFilter(JSONWriter.Context context, SerializeFilter filter) {
        if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
            context.setNameFilter((NameFilter)((com.alibaba.fastjson.serializer.NameFilter)filter));
        }
        if (filter instanceof ValueFilter) {
            context.setValueFilter((ValueFilter)filter);
        }
        if (filter instanceof PropertyPreFilter) {
            context.setPropertyPreFilter((PropertyPreFilter)filter);
        }
        if (filter instanceof PropertyFilter) {
            context.setPropertyFilter((PropertyFilter)filter);
        }
        if (filter instanceof BeforeFilter) {
            context.setBeforeFilter((com.alibaba.fastjson2.filter.BeforeFilter)((BeforeFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.AfterFilter) {
            context.setAfterFilter((AfterFilter)((com.alibaba.fastjson.serializer.AfterFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.LabelFilter) {
            context.setLabelFilter((LabelFilter)((com.alibaba.fastjson.serializer.LabelFilter)filter));
        }
        if (filter instanceof com.alibaba.fastjson.serializer.ContextValueFilter) {
            context.setContextValueFilter((ContextValueFilter)((com.alibaba.fastjson.serializer.ContextValueFilter)filter));
        }
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter[] filters, int defaultFeatures, SerializerFeature ... features) {
        Object valueClass2;
        block12: {
            JSONWriter.Context context = JSON.createWriteContext(config, defaultFeatures, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block12;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(config, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                JSON.configFilter(context, filter);
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        Object valueClass2;
        block13: {
            JSONWriter.Context context = JSON.createWriteContext(config, defaultFeatures, features);
            if (dateFormat != null && !dateFormat.isEmpty()) {
                context.setDateFormat(dateFormat);
            }
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes(charset);
                if (writer == null) break block13;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter[] filters, SerializerFeature ... features) {
        Object valueClass2;
        block12: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block12;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(config, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, boolean prettyFormat) {
        Object valueClass2;
        block13: {
            SerializerFeature[] serializerFeatureArray;
            if (prettyFormat) {
                SerializerFeature[] serializerFeatureArray2 = new SerializerFeature[1];
                serializerFeatureArray = serializerFeatureArray2;
                serializerFeatureArray2[0] = SerializerFeature.PrettyFormat;
            } else {
                serializerFeatureArray = new SerializerFeature[]{};
            }
            SerializerFeature[] features = serializerFeatureArray;
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block13;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, new SerializerFeature[0]);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException(ex.getMessage(), cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, SerializeFilter filter0, SerializeFilter filter1, SerializeFilter ... filters) {
        String valueClass2;
        block12: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, new SerializerFeature[0]);
            JSON.configFilter(context, filter0);
            JSON.configFilter(context, filter1);
            for (SerializeFilter filter : filters) {
                JSON.configFilter(context, filter);
            }
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    Class<?> valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block12;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static String toJSONString(Object object, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.toString();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONString error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, new SerializerFeature[0]);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter ... filters) {
        return JSON.toJSONBytes(object, filters, new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, int defaultFeatures, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, defaultFeatures, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter filter) {
        return JSON.toJSONBytes(object, SerializeConfig.global, new SerializeFilter[]{filter}, DEFAULT_GENERATE_FEATURE, new SerializerFeature[0]);
    }

    public static byte[] toJSONBytes(Object object, SerializeFilter filter, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, SerializeConfig.global, new SerializeFilter[]{filter}, DEFAULT_GENERATE_FEATURE, features);
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) {
        byte[] valueClass2;
        block13: {
            JSONWriter.Context context = JSON.createWriteContext(config, defaultFeatures, features);
            if (dateFormat != null && !dateFormat.isEmpty()) {
                context.setDateFormat(dateFormat);
            }
            for (SerializeFilter filter : filters) {
                JSON.configFilter(context, filter);
            }
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    Class<?> valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter(valueClass2, valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block13;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializerFeature ... features) {
        Object valueClass2;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter writer = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    valueClass2 = object.getClass();
                    ObjectWriter objectWriter = context.getObjectWriter((Type)valueClass2, (Class)valueClass2);
                    objectWriter.write(writer, object, null, null, 0L);
                }
                valueClass2 = writer.getBytes();
                if (writer == null) break block11;
            }
            catch (Throwable valueClass2) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            valueClass2.addSuppressed(throwable);
                        }
                    }
                    throw valueClass2;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("toJSONBytes error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("toJSONBytes error", ex);
                }
            }
            writer.close();
        }
        return valueClass2;
    }

    public static byte[] toJSONBytes(Object object, SerializeConfig config, int defaultFeatures, SerializerFeature ... features) {
        return JSON.toJSONBytes(object, config, new SerializeFilter[0], defaultFeatures, features);
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(config, DEFAULT_GENERATE_FEATURE, features);
        try (JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);){
            writer.setRootObject(object);
            writer.writeAny(object);
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONStringZ(Object object, SerializeConfig mapping, SerializerFeature ... features) {
        return JSON.toJSONString(object, mapping, new SerializeFilter[0], null, 0, features);
    }

    public static String toJSONString(Object object, SerializeConfig config, SerializeFilter filter, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(config, DEFAULT_GENERATE_FEATURE, features);
        try (JSONWriter writer = JSONWriter.of((JSONWriter.Context)context);){
            if (config.propertyNamingStrategy != null && config.propertyNamingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
                com.alibaba.fastjson.serializer.NameFilter nameFilter = com.alibaba.fastjson.serializer.NameFilter.of(config.propertyNamingStrategy);
                if (filter instanceof com.alibaba.fastjson.serializer.NameFilter) {
                    filter = com.alibaba.fastjson.serializer.NameFilter.compose(nameFilter, (com.alibaba.fastjson.serializer.NameFilter)filter);
                } else {
                    JSON.configFilter(context, nameFilter);
                }
            }
            JSON.configFilter(context, filter);
            if (object == null) {
                writer.writeNull();
            } else {
                writer.setRootObject(object);
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = context.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, SerializeFilter filter, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
        JSON.configFilter(context, filter);
        try (JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)context);){
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(object);
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, int defaultFeatures, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, defaultFeatures, features);
        try (JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)context);){
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(object);
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static String toJSONStringWithDateFormat(Object object, String dateFormat, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
        try (JSONWriter jsonWriter = JSONWriter.of((JSONWriter.Context)context);){
            context.setDateFormat(dateFormat);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(object);
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            String string = jsonWriter.toString();
            return string;
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializerFeature ... features) throws IOException {
        return JSON.writeJSONString(os, object, new SerializeFilter[0], features);
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters) throws IOException {
        return JSON.writeJSONString(os, object, filters, new SerializerFeature[0]);
    }

    public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializerFeature ... features) throws IOException {
        int n;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter jsonWriter = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                if (object == null) {
                    jsonWriter.writeNull();
                } else {
                    jsonWriter.setRootObject(object);
                    ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                    objectWriter.write(jsonWriter, object, null, null, 0L);
                }
                byte[] bytes = jsonWriter.getBytes(charset);
                os.write(bytes);
                n = bytes.length;
                if (jsonWriter == null) break block11;
            }
            catch (Throwable bytes) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            bytes.addSuppressed(throwable);
                        }
                    }
                    throw bytes;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("writeJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("writeJSONString error", ex);
                }
            }
            jsonWriter.close();
        }
        return n;
    }

    public static void writeJSONString(Writer writer, Object object, SerializerFeature ... features) {
        JSON.writeJSONString(writer, object, DEFAULT_GENERATE_FEATURE, features);
    }

    public static void writeJSONString(Writer writer, Object object, int defaultFeatures, SerializerFeature ... features) {
        JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, defaultFeatures, features);
        try (JSONWriter jsonWriter = JSONWriter.ofUTF8((JSONWriter.Context)context);){
            jsonWriter.setRootObject(object);
            if (object == null) {
                jsonWriter.writeNull();
            } else {
                jsonWriter.setRootObject(object);
                ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                objectWriter.write(jsonWriter, object, null, null, 0L);
            }
            jsonWriter.flushTo(writer);
        }
        catch (com.alibaba.fastjson2.JSONException ex) {
            Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
            throw new JSONException("writeJSONString error", cause);
        }
        catch (RuntimeException ex) {
            throw new JSONException("writeJSONString error", ex);
        }
    }

    public static final int writeJSONString(OutputStream os, Object object, int defaultFeatures, SerializerFeature ... features) throws IOException {
        int n;
        block11: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, defaultFeatures, features);
            JSONWriter jsonWriter = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                jsonWriter.setRootObject(object);
                if (object == null) {
                    jsonWriter.writeNull();
                } else {
                    jsonWriter.setRootObject(object);
                    ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                    objectWriter.write(jsonWriter, object, null, null, 0L);
                }
                byte[] bytes = jsonWriter.getBytes();
                os.write(bytes);
                n = bytes.length;
                if (jsonWriter == null) break block11;
            }
            catch (Throwable bytes) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            bytes.addSuppressed(throwable);
                        }
                    }
                    throw bytes;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("writeJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("writeJSONString error", ex);
                }
            }
            jsonWriter.close();
        }
        return n;
    }

    public static final int writeJSONString(OutputStream os, Charset charset, Object object, SerializeConfig config, SerializeFilter[] filters, String dateFormat, int defaultFeatures, SerializerFeature ... features) throws IOException {
        int n;
        block13: {
            JSONWriter.Context context = JSON.createWriteContext(config, defaultFeatures, features);
            if (dateFormat != null && !dateFormat.isEmpty()) {
                context.setDateFormat(dateFormat);
            }
            JSONWriter jsonWriter = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    jsonWriter.writeNull();
                } else {
                    jsonWriter.setRootObject(object);
                    ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                    objectWriter.write(jsonWriter, object, null, null, 0L);
                }
                byte[] bytes = jsonWriter.getBytes(charset);
                os.write(bytes);
                n = bytes.length;
                if (jsonWriter == null) break block13;
            }
            catch (Throwable bytes) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            bytes.addSuppressed(throwable);
                        }
                    }
                    throw bytes;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("writeJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("writeJSONString error", ex);
                }
            }
            jsonWriter.close();
        }
        return n;
    }

    public static final int writeJSONString(OutputStream os, Object object, SerializeFilter[] filters, SerializerFeature ... features) throws IOException {
        int n;
        block12: {
            JSONWriter.Context context = JSON.createWriteContext(SerializeConfig.global, DEFAULT_GENERATE_FEATURE, features);
            JSONWriter jsonWriter = JSONWriter.ofUTF8((JSONWriter.Context)context);
            try {
                for (SerializeFilter filter : filters) {
                    JSON.configFilter(context, filter);
                }
                if (object == null) {
                    jsonWriter.writeNull();
                } else {
                    jsonWriter.setRootObject(object);
                    ObjectWriter objectWriter = context.getObjectWriter(object.getClass());
                    objectWriter.write(jsonWriter, object, null, null, 0L);
                }
                byte[] bytes = jsonWriter.getBytes();
                os.write(bytes);
                n = bytes.length;
                if (jsonWriter == null) break block12;
            }
            catch (Throwable bytes) {
                try {
                    if (jsonWriter != null) {
                        try {
                            jsonWriter.close();
                        }
                        catch (Throwable throwable) {
                            bytes.addSuppressed(throwable);
                        }
                    }
                    throw bytes;
                }
                catch (com.alibaba.fastjson2.JSONException ex) {
                    Throwable cause = ex.getCause() != null ? ex.getCause() : ex;
                    throw new JSONException("writeJSONString error", cause);
                }
                catch (RuntimeException ex) {
                    throw new JSONException("writeJSONString error", ex);
                }
            }
            jsonWriter.close();
        }
        return n;
    }

    public static JSONArray parseArray(String str, Feature ... features) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of((String)str, (JSONReader.Context)JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features));){
            if (jsonReader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray jsonArray = new JSONArray();
            jsonReader.read((List)jsonArray);
            JSONArray jSONArray = jsonArray;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(String str) {
        if (str == null || str.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]);
        JSONReader reader = JSONReader.of((String)str, (JSONReader.Context)context);
        try {
            ArrayList list = new ArrayList();
            reader.read(list);
            JSONArray jsonArray = new JSONArray(list);
            reader.handleResolveTasks((Object)jsonArray);
            return jsonArray;
        }
        catch (com.alibaba.fastjson2.JSONException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new JSONException(e.getMessage(), cause);
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        List list;
        block10: {
            if (text == null || text.isEmpty()) {
                return null;
            }
            ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, List.class);
            JSONReader reader = JSONReader.of((String)text, (JSONReader.Context)JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]));
            try {
                list = (List)reader.read((Type)paramType);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (com.alibaba.fastjson2.JSONException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    throw new JSONException(e.getMessage(), cause);
                }
            }
            reader.close();
        }
        return list;
    }

    public static <T> List<T> parseArray(String text, Class<T> clazz, ParserConfig config) {
        List list;
        block11: {
            if (text == null || text.isEmpty()) {
                return null;
            }
            if (config == null) {
                config = ParserConfig.global;
            }
            ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{clazz}, null, List.class);
            JSONReader reader = JSONReader.of((String)text, (JSONReader.Context)JSON.createReadContext(config.getProvider(), DEFAULT_PARSER_FEATURE, new Feature[0]));
            try {
                list = (List)reader.read((Type)paramType);
                if (reader == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (com.alibaba.fastjson2.JSONException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    throw new JSONException(e.getMessage(), cause);
                }
            }
            reader.close();
        }
        return list;
    }

    public static <T> List<T> parseArray(String text, Class<T> type, Feature ... features) {
        List list;
        block10: {
            if (text == null || text.isEmpty()) {
                return null;
            }
            ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(new Type[]{type}, null, List.class);
            JSONReader reader = JSONReader.of((String)text, (JSONReader.Context)JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_PARSER_FEATURE, features));
            try {
                list = (List)reader.read((Type)paramType);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (com.alibaba.fastjson2.JSONException e) {
                    Throwable cause = e.getCause();
                    if (cause == null) {
                        cause = e;
                    }
                    throw new JSONException(e.getMessage(), cause);
                }
            }
            reader.close();
        }
        return list;
    }

    public static boolean isValid(String str) {
        return com.alibaba.fastjson2.JSON.isValid((String)str);
    }

    public static boolean isValidArray(String str) {
        return com.alibaba.fastjson2.JSON.isValidArray((String)str);
    }

    public static boolean isValidObject(String str) {
        return com.alibaba.fastjson2.JSON.isValidObject((String)str);
    }

    public abstract <T> T toJavaObject(Class<T> var1);

    public abstract <T> T toJavaObject(Type var1);

    public <T> T toJavaObject(TypeReference typeReference) {
        Object type = typeReference != null ? typeReference.getType() : Object.class;
        return this.toJavaObject((Type)type);
    }

    public static <T> T toJavaObject(JSON json, Class<T> clazz) {
        if (json instanceof JSONObject) {
            return ((JSONObject)json).toJavaObject(clazz);
        }
        String str = JSON.toJSONString(json);
        return JSON.parseObject(str, clazz);
    }

    public static Object toJSON(Object javaObject) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        Object object = JSON.parse(str);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static Object toJSON(Object javaObject, SerializeConfig config) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject, config, new SerializerFeature[0]);
        Object object = JSON.parse(str);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static Object toJSON(Object javaObject, ParserConfig config) {
        if (javaObject instanceof JSON) {
            return javaObject;
        }
        String str = JSON.toJSONString(javaObject);
        Object object = JSON.parse(str, config);
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return object;
    }

    public static List<Object> parseArray(String text, Type[] types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONArray array = new JSONArray(types.length);
        try (JSONReader reader = JSONReader.of((String)text, (JSONReader.Context)JSON.createReadContext(JSONFactory.getDefaultObjectReaderProvider(), DEFAULT_GENERATE_FEATURE, new Feature[0]));){
            reader.startArray();
            for (Type itemType : types) {
                array.add(reader.read(itemType));
            }
            reader.endArray();
            reader.handleResolveTasks((Object)array);
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static void addMixInAnnotations(Type target, Type mixinSource) {
        if (target != null && mixinSource != null) {
            ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
            readerProvider.mixIn((Class)target, (Class)mixinSource);
            ObjectWriterProvider writerProvider = SerializeConfig.DEFAULT_PROVIDER;
            writerProvider.mixIn((Class)target, (Class)mixinSource);
        }
    }

    public static void removeMixInAnnotations(Type target) {
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        readerProvider.mixIn((Class)target, null);
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.mixIn((Class)target, null);
    }

    public static void clearMixInAnnotations() {
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        readerProvider.cleanupMixIn();
        ObjectWriterProvider writerProvider = JSONFactory.getDefaultObjectWriterProvider();
        writerProvider.cleanupMixIn();
    }

    public static Type getMixInAnnotations(Type target) {
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        Class mixIn = readerProvider.getMixIn((Class)target);
        if (mixIn == null) {
            mixIn = JSONFactory.getDefaultObjectWriterProvider().getMixIn((Class)target);
        }
        return mixIn;
    }

    public String toJSONString() {
        return com.alibaba.fastjson2.JSON.toJSONString((Object)this, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.ReferenceDetection});
    }

    public String toString(SerializerFeature ... features) {
        return JSON.toJSONString((Object)this, features);
    }

    public void writeJSONString(Appendable appendable) {
        if (appendable instanceof Writer) {
            JSON.writeJSONString((Writer)appendable, (Object)this, new SerializerFeature[0]);
            return;
        }
        try {
            appendable.append(JSON.toJSONString(this));
        }
        catch (IOException e) {
            throw new JSONException(e.getMessage(), e);
        }
    }

    static {
        int features = 0;
        features |= Feature.AutoCloseSource.getMask();
        features |= Feature.InternFieldNames.getMask();
        features |= Feature.UseBigDecimal.getMask();
        features |= Feature.AllowUnQuotedFieldNames.getMask();
        features |= Feature.AllowSingleQuotes.getMask();
        features |= Feature.AllowArbitraryCommas.getMask();
        features |= Feature.SortFeidFastMatch.getMask();
        DEFAULT_PARSER_FEATURE = features |= Feature.IgnoreNotMatch.getMask();
        features = 0;
        features |= SerializerFeature.QuoteFieldNames.getMask();
        features |= SerializerFeature.SkipTransientField.getMask();
        features |= SerializerFeature.WriteEnumUsingName.getMask();
        DEFAULT_GENERATE_FEATURE = features |= SerializerFeature.SortField.getMask();
        arraySupplier = JSONArray::new;
        defaultSupplier = JSONObject::new;
        orderedSupplier = () -> new JSONObject(true);
        boolean android = JDKUtils.ANDROID;
        ObjectReaderProvider readerProvider = JSONFactory.getDefaultObjectReaderProvider();
        if (!android) {
            readerProvider.register((ObjectReaderModule)AwtRederModule.INSTANCE);
        }
        readerProvider.register((ObjectReaderModule)new Fastjson1xReaderModule(readerProvider));
        ObjectWriterProvider writerProvider = SerializeConfig.DEFAULT_PROVIDER;
        if (!android) {
            writerProvider.register((ObjectWriterModule)AwtWriterModule.INSTANCE);
        }
        writerProvider.register((ObjectWriterModule)new Fastjson1xWriterModule(writerProvider));
    }

    static class Cache {
        volatile char[] chars;

        Cache() {
        }
    }
}

