/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.field.types;

import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.field.SqlType;
import com.j256.ormlite.field.types.BaseDataType;
import com.j256.ormlite.misc.IOUtils;
import com.j256.ormlite.support.DatabaseResults;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.Arrays;

public class SerializableType
extends BaseDataType {
    private static final SerializableType singleTon = new SerializableType();

    public static SerializableType getSingleton() {
        return singleTon;
    }

    private SerializableType() {
        super(SqlType.SERIALIZABLE);
    }

    protected SerializableType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        throw new SQLException("Default values for serializable types are not supported");
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, DatabaseResults results, int columnPos) throws SQLException {
        return results.getBytes(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        Object object;
        byte[] bytes = (byte[])sqlArg;
        ObjectInputStream objInStream = null;
        try {
            objInStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            object = objInStream.readObject();
        }
        catch (Exception e) {
            try {
                throw new SQLException("Could not read serialized object from byte array: " + Arrays.toString(bytes) + "(len " + bytes.length + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objInStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(objInStream);
        return object;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
        byte[] byArray;
        ObjectOutputStream objOutStream = null;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            objOutStream = new ObjectOutputStream(outStream);
            objOutStream.writeObject(obj);
            objOutStream.close();
            objOutStream = null;
            byArray = outStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new SQLException("Could not write serialized object to byte array: " + obj, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objOutStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(objOutStream);
        return byArray;
    }

    @Override
    public boolean isValidForField(Field field) {
        return Serializable.class.isAssignableFrom(field.getType());
    }

    @Override
    public boolean isStreamType() {
        return true;
    }

    @Override
    public boolean isComparable() {
        return false;
    }

    @Override
    public boolean isAppropriateId() {
        return false;
    }

    @Override
    public boolean isArgumentHolderRequired() {
        return true;
    }

    @Override
    public Object resultStringToJava(FieldType fieldType, String stringValue, int columnPos) throws SQLException {
        throw new SQLException("Serializable type cannot be converted from string to Java");
    }

    @Override
    public Class<?> getPrimaryClass() {
        return Serializable.class;
    }
}

