/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class StatementBuilder<T, ID> {
    private static final ArgumentHolder[] EMPTY_ARGUMENT_HOLDERS = new ArgumentHolder[0];
    private static final FieldType[] EMPTY_FIELD_TYPES = new FieldType[0];
    private static final Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    protected final TableInfo<T, ID> tableInfo;
    protected final String tableName;
    protected final DatabaseType databaseType;
    protected final Dao<T, ID> dao;
    protected StatementType type;
    protected boolean addTableName;
    protected Where<T, ID> where = null;

    public StatementBuilder(DatabaseType databaseType, TableInfo<T, ID> tableInfo, Dao<T, ID> dao, StatementType type) {
        this.databaseType = databaseType;
        this.tableInfo = tableInfo;
        this.tableName = tableInfo.getTableName();
        this.dao = dao;
        this.type = type;
        if (!type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)type) + " statement is not allowed");
        }
    }

    public Where<T, ID> where() {
        this.where = new Where<T, ID>(this.tableInfo, this, this.databaseType);
        return this.where;
    }

    public void setWhere(Where<T, ID> where) {
        this.where = where;
    }

    protected MappedPreparedStmt<T, ID> prepareStatement(Long limit, boolean cacheStore) throws SQLException {
        FieldType[] argFieldTypes;
        ArgumentHolder[] selectArgs;
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        String statement = this.buildStatementString(argList);
        if (argList.isEmpty()) {
            selectArgs = EMPTY_ARGUMENT_HOLDERS;
            argFieldTypes = EMPTY_FIELD_TYPES;
        } else {
            selectArgs = argList.toArray(new ArgumentHolder[argList.size()]);
            argFieldTypes = new FieldType[argList.size()];
            for (int selectC = 0; selectC < selectArgs.length; ++selectC) {
                argFieldTypes[selectC] = selectArgs[selectC].getFieldType();
            }
        }
        FieldType[] resultFieldTypes = this.getResultFieldTypes();
        return new MappedPreparedStmt<T, ID>(this.dao, this.tableInfo, statement, argFieldTypes, resultFieldTypes, selectArgs, this.databaseType.isLimitSqlSupported() ? null : limit, this.type, cacheStore);
    }

    public String prepareStatementString() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        return this.buildStatementString(argList);
    }

    public StatementInfo prepareStatementInfo() throws SQLException {
        ArrayList<ArgumentHolder> argList = new ArrayList<ArgumentHolder>();
        String statement = this.buildStatementString(argList);
        return new StatementInfo(statement, argList);
    }

    public void reset() {
        this.where = null;
    }

    protected String buildStatementString(List<ArgumentHolder> argList) throws SQLException {
        StringBuilder sb = new StringBuilder(128);
        this.appendStatementString(sb, argList);
        int len = sb.length();
        if (len > 0 && sb.charAt(len - 1) == ' ') {
            sb.setLength(len - 1);
        }
        String statement = sb.toString();
        logger.debug("built statement {}", (Object)statement);
        return statement;
    }

    protected void appendStatementString(StringBuilder sb, List<ArgumentHolder> argList) throws SQLException {
        this.appendStatementStart(sb, argList);
        this.appendWhereStatement(sb, argList, WhereOperation.FIRST);
        this.appendStatementEnd(sb, argList);
    }

    protected abstract void appendStatementStart(StringBuilder var1, List<ArgumentHolder> var2) throws SQLException;

    protected boolean appendWhereStatement(StringBuilder sb, List<ArgumentHolder> argList, WhereOperation operation) throws SQLException {
        if (this.where == null) {
            return operation == WhereOperation.FIRST;
        }
        operation.appendBefore(sb);
        this.where.appendSql(this.addTableName ? this.getTableName() : null, sb, argList);
        operation.appendAfter(sb);
        return false;
    }

    protected abstract void appendStatementEnd(StringBuilder var1, List<ArgumentHolder> var2) throws SQLException;

    protected boolean shouldPrependTableNameToColumns() {
        return false;
    }

    protected FieldType[] getResultFieldTypes() {
        return null;
    }

    protected FieldType verifyColumnName(String columnName) {
        return this.tableInfo.getFieldTypeByColumnName(columnName);
    }

    protected String getTableName() {
        return this.tableName;
    }

    StatementType getType() {
        return this.type;
    }

    protected static enum WhereOperation {
        FIRST("WHERE ", null),
        AND("AND (", ") "),
        OR("OR (", ") ");

        private final String before;
        private final String after;

        private WhereOperation(String before, String after) {
            this.before = before;
            this.after = after;
        }

        public void appendBefore(StringBuilder sb) {
            if (this.before != null) {
                sb.append(this.before);
            }
        }

        public void appendAfter(StringBuilder sb) {
            if (this.after != null) {
                sb.append(this.after);
            }
        }
    }

    public static class StatementInfo {
        private final String statement;
        private final List<ArgumentHolder> argList;

        StatementInfo(String statement, List<ArgumentHolder> argList) {
            this.argList = argList;
            this.statement = statement;
        }

        public String getStatement() {
            return this.statement;
        }

        public List<ArgumentHolder> getArgList() {
            return this.argList;
        }
    }

    public static enum StatementType {
        SELECT(true, true, false, false),
        SELECT_LONG(true, true, false, false),
        SELECT_RAW(true, true, false, false),
        UPDATE(true, false, true, false),
        DELETE(true, false, true, false),
        EXECUTE(false, false, false, true);

        private final boolean okForStatementBuilder;
        private final boolean okForQuery;
        private final boolean okForUpdate;
        private final boolean okForExecute;

        private StatementType(boolean okForStatementBuilder, boolean okForQuery, boolean okForUpdate, boolean okForExecute) {
            this.okForStatementBuilder = okForStatementBuilder;
            this.okForQuery = okForQuery;
            this.okForUpdate = okForUpdate;
            this.okForExecute = okForExecute;
        }

        public boolean isOkForStatementBuilder() {
            return this.okForStatementBuilder;
        }

        public boolean isOkForQuery() {
            return this.okForQuery;
        }

        public boolean isOkForUpdate() {
            return this.okForUpdate;
        }

        public boolean isOkForExecute() {
            return this.okForExecute;
        }
    }
}

