import moviepy.editor as mp
from moviepy.audio.io.AudioFileClip import AudioFileClip


def run_mb(images, durations, audio, volume):
    clips = []
    for key, image_path in enumerate(images):
        try:
            audio_clip = AudioFileClip(audio[key][0]).volumex(volume)
            clip = mp.ImageClip(image_path).set_duration(durations[key])
            clip = clip.set_audio(audio_clip)
            # 淡入淡出的效果
            if key > 0:
                clip = clip.crossfadein(1)
                previous_clip = clips[-1]
                previous_clip = previous_clip.crossfadeout(1)
                clips[-1] = previous_clip
            clips.append(clip)
        except Exception as ex:
            print(ex)
    return clips
