<?php
/**
 * KuImg Register Process
 * Processes the registration forms and returns errors/redirects to a page
 *
 *
 * @version 1.0
 * @author KuImg
 * @copyright 2010 all rights reserved
 *
 */

function mfthemes_process_register_form( $success_redirect = '' ) {

        // if there's no redirect posted, send them to their job dashboard
	if (!$success_redirect)
            $success_redirect = get_bloginfo('url');

	
	if ( get_option('users_can_register') ) :
		
		global $posted, $app_abbr;
		
		$posted = array();
		$errors = new WP_Error();
		$user_pass = wp_generate_password();
		
		if (isset($_POST['register']) && $_POST['register']) {

                        // include the WP registration core
			require_once( ABSPATH . WPINC . '/registration.php');

		
			// Get (and clean) data
			$fields = array(
				'your_username',
				'your_email',
				'your_password',
				'your_password_2',
				'role'
			);
			foreach ($fields as $field) {
				if (isset($_POST[$field])) $posted[$field] = stripslashes(trim($_POST[$field])); else $posted[$field] = '';
			}
		
			$user_login = sanitize_user( $posted['your_username'] );
			$user_email = apply_filters( 'user_registration_email', $posted['your_email'] );
			$user_role = get_option('default_role');

			
			// Check the username
			if ( $posted['your_username'] == '' )
				$errors->add('empty_username', __('<strong>错误</strong>: 请输入用户名。', 'KuImg'));
			elseif ( !validate_username( $posted['your_username'] ) ) {
				$errors->add('invalid_username', __('<strong>错误</strong>: 该用户名无效。请输入有效的用户名。', 'KuImg'));
				$posted['your_username'] = '';
			} elseif ( username_exists( $posted['your_username'] ) )
				$errors->add('username_exists', __('<strong>错误</strong>: 此用户名已被注册，请选择另外一个。', 'KuImg'));
		
			// Check the e-mail address
			if ($posted['your_email'] == '') {
				$errors->add('empty_email', __('<strong>错误</strong>: 请输入您的电子邮件地址。', 'KuImg'));
			} elseif ( !is_email( $posted['your_email'] ) ) {
				$errors->add('invalid_email', __('<strong>错误</strong>: 电子邮件地址不正确。', 'KuImg'));
				$posted['your_email'] = '';
			} elseif ( email_exists( $posted['your_email'] ) )
				$errors->add('email_exists', __('<strong>错误</strong>: 这个电子邮件地址已经被注册，请选择另外一个。', 'KuImg'));
			

				// Check Passwords match
				if ($posted['your_password'] == '')	
					$errors->add('empty_password', __('<strong>错误</strong>: 请输入密码。', 'KuImg'));
				elseif ( strlen($posted['your_password']) < 8 )	
					$errors->add('empty_password', __('<strong>错误</strong>: 密码长度至少8位。', 'KuImg'));
				elseif ($posted['your_password_2'] == '')
					$errors->add('empty_password', __('<strong>错误</strong>: 请再次输入密码。', 'KuImg'));
				elseif ($posted['your_password'] !== $posted['your_password_2'])
					$errors->add('wrong_password', __('<strong>错误</strong>: 两次输入密码不一致。', 'KuImg'));
				
				$user_pass = $posted['your_password'];
			
            if (empty($_SESSION['captcha']) || trim(strtolower($_REQUEST['captcha_code'])) != $_SESSION['captcha']) {
				$errors->add('captcha_spam',  __('<strong>错误</strong>: 验证码错误。', 'KuImg'));
			}
			unset($_SESSION['captcha']);
	
			
			do_action('register_post', $posted['your_username'], $posted['your_email'], $errors);
			$errors = apply_filters( 'registration_errors', $errors, $posted['your_username'], $posted['your_email'] );
		
                        // if there are no errors, let's create the user account
			if ( !$errors->get_error_code() ) {

                           
                            $user_id = wp_create_user(  $posted['your_username'], $user_pass, $posted['your_email'] );
                            if ( !$user_id ) {
                                    $errors->add('registerfail', sprintf(__('<strong>错误</strong>: 无法注册... 请联系 <a href="mailto:%s">管理员</a> !', 'KuImg'), get_option('admin_email')));
                                    return array( 'errors' => $errors, 'posted' => $posted);
                            }

                            // Change role
                            wp_update_user( array ('ID' => $user_id, 'role' => $user_role) ) ;
							
								// set the WP login cookie
								$secure_cookie = is_ssl() ? true : false;
								wp_set_auth_cookie($user_id, true, $secure_cookie);
								
								// mail to new user 
								mfthemes_newuesr_notify($posted['your_username'], $posted['your_password'], $posted['your_email']);
								
								// redirect
								$success_redirect = get_admin_url();
								wp_redirect($success_redirect);
								exit;

			} else {

                            // there were errors so go back and display them without creating new user
                            return array( 'errors' => $errors, 'posted' => $posted);

			}
		}
		
	endif;

}