<?php
add_action('admin_menu', 'mfthemes_admin_menu');
function mfthemes_admin_menu() {
	add_menu_page(__( '主题设置', 'KuImg' ), __( '主题设置', 'KuImg' ), 'edit_themes', basename(__FILE__), 'mfthemes_settings_page');
	add_action( 'admin_init', 'mfthemes_settings' );
}
add_action('admin_init', 'mfthemes_page_init');
function mfthemes_page_init(){
	if (isset($_GET['page']) && $_GET['page'] == 'themes-admin.php') {
		//error_reporting(0);
		ob_start();
		ob_end_clean();
		$dir = get_bloginfo('template_directory');
		$ajax_url = home_url("/").'?ajax_src=';
		wp_enqueue_style('admincss', $dir . '/style/css/admin.css', false, '1.0.0', false);
		echo "<script type='text/javascript'>var ajax_url = \"$ajax_url\"; </script>";
		wp_enqueue_script('adminjs', $dir . '/style/js/admin.js', false, '1.0.0', false);
	}
}

function mfthemes_settings() {
	register_setting( 'mfthemes-settings-group', 'mfthemes_options' );
}

function mfthemes_settings_page() {
	if ( isset($_REQUEST['settings-updated']) ) echo '<div id="message" class="updated fade"><p><strong>保存成功！</strong></p></div>';
	if( 'reset' == isset($_REQUEST['reset']) ) {
		delete_option('mfthemes_options');
		echo '<div id="message" class="updated fade"><p><strong>重置成功！</strong></p></div>';
	}
?>
<html>
	<div class="wrap">
		<div id="icon-options-general" class="icon32"><br></div><h2>主题设置</h2><br>
		<form method="post" action="options.php">
			<?php settings_fields( 'mfthemes-settings-group' ); ?>
			<?php $options = get_option('mfthemes_options'); ?>
			<div id="set-nav">
				<ul>
					<li><a class="current" href="#" onclick="this.blur()">常规</a></li>
					<li><a href="#" onclick="this.blur()">外观</a></li>
					<li><a href="#" onclick="this.blur()">首页幻灯片</a></li>
					<li><a href="#" onclick="this.blur()">PC广告</a></li>
					<li><a href="#" onclick="this.blur()">无线广告</a></li>
					<li><a href="#" onclick="this.blur()">视频广告</a></li>
					<li><a href="#" onclick="this.blur()">功能</a></li>
					<li><a href="#" onclick="this.blur()">SNS设置</a></li>
					<li><a href="#" onclick="this.blur()">无线设置</a></li>
					<li><a href="#" onclick="this.blur()">主题说明</a></li>
				</ul>
			</div>
			<div id="set-cont" class="clx">
				<ul>
					<li class="current">
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[description]">网站描述</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[description]"><?php echo $options['description']; ?></textarea></div>
							<div class="span span3"><small class="set-small">用简洁凝练的话对你的网站进行描述</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[keywords]">网站关键词</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[keywords]"><?php echo $options['keywords']; ?></textarea></div>
							<div class="span span3"><small class="set-small">多个关键词请用英文逗号隔开</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[headcode]">网站页头自定义代码</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[headcode]"><?php echo $options['headcode']; ?></textarea></div>
							<div class="span span3"><small class="set-small">用于在网站页头加载自定义代码，如：CSS\JS代码</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[footercode]">网站页脚自定义代码</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[footercode]"><?php echo $options['footercode']; ?></textarea></div>
							<div class="span span3"><small class="set-small">用于在网站页脚加载自定义代码，如：CSS\JS代码</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[analysis]">网站统计</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[analysis]"><?php echo $options['analysis']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入统计代码</small></div>
						</div>
					</li>
					<li>
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[favicon]">自定义Ico图标</label></div>
							<div class="span span2">
								<input type="text" class="set-favicon set-input" name="mfthemes_options[favicon]" value="<?php echo $options['favicon']; ?>" placeholder="" /><a href="#" class="button">上传Ico图标</a>
							</div>
							<div class="span span3 span-preview"><img src="<?php echo $options['favicon']; ?>" alt="" /></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[logo]">自定义Logo图片</label></div>
							<div class="span span2">
								<input type="text" class="set-logo set-input" name="mfthemes_options[logo]" value="<?php echo $options['logo']; ?>" placeholder="" /><a href="#" class="button">上传Logo图片</a>
							</div>
							<div class="span span3 span-preview"><img src="<?php echo $options['logo']; ?>" alt="" /></div>
						</div>
					</li>
					<li>
						<?php $timthumb = get_bloginfo('template_url').'/timthumb.php';?>
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label">设置说明</label></div>
							<div class="span span2">
								<p><strong>提示1:</strong> 图片尺寸为1083x400（px）</p>
								<p><strong>提示2:</strong> 可填写外链地址，最少5张才会显示正常</p>
							</div>
						</div>
						<!--
						<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[slider_order]" style="margin: 0 0 0 20;">排序</label></div>
								<div class="span span2"><input type="text" class="set-thumb" name="mfthemes_options[slider_order]" value="<?php echo $options['slider_order']; ?>" /></div>
								<div class="span span3"><small>默认1,2,3,4,5,6</small></div>
							</div><div class="set-gap"></div>-->
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图①</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][0]" value="<?php echo $options['filmstrip']['title'][0]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][0]" value="<?php echo $options['filmstrip']['href'][0]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][0]" value="<?php echo $options['filmstrip']['src'][0]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][0] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>			
							</div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图②</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][1]" value="<?php echo $options['filmstrip']['title'][1]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][1]" value="<?php echo $options['filmstrip']['href'][1]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][1]" value="<?php echo $options['filmstrip']['src'][1]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][1] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>
							</div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图③</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][2]" value="<?php echo $options['filmstrip']['title'][2]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][2]" value="<?php echo $options['filmstrip']['href'][2]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][2]" value="<?php echo $options['filmstrip']['src'][2]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][2] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>
							</div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图④</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][3]" value="<?php echo $options['filmstrip']['title'][3]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][3]" value="<?php echo $options['filmstrip']['href'][3]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][3]" value="<?php echo $options['filmstrip']['src'][3]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][3] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>
							</div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图⑤</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][4]" value="<?php echo $options['filmstrip']['title'][4]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][4]" value="<?php echo $options['filmstrip']['href'][4]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][4]" value="<?php echo $options['filmstrip']['src'][4]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][4] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>
							</div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label">轮播图⑥</label></div>
							<div class="span span2">
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][title][5]" value="<?php echo $options['filmstrip']['title'][5]; ?>" placeholder="标题" /> 标题
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][href][5]" value="<?php echo $options['filmstrip']['href'][5]; ?>" placeholder="链接地址" /> 链接
								<input type="text" class="set-thumb set-input" name="mfthemes_options[filmstrip][src][5]" value="<?php echo $options['filmstrip']['src'][5]; ?>" placeholder="图片地址" /><a href="#" class="button">上传图片</a>
							</div>
							<div class="span span3">
								<?php if(($src0 = $options['filmstrip']['src'][5] )) echo '<img src="'.$src0.'" height="87px" alt="" />';?>
							</div>
						</div>
					</li>
					<li>
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label">PC端广告设置</label></div>
							<div class="span span2"><p><strong>提示:</strong>全站广告，请直接填入广告html代码</p></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[index_01]">首页960X90广告</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_01]"><?php echo $options['index_01']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示</small></div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[index_02]">首页1083x90广告</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_02]"><?php echo $options['index_02']; ?></textarea></div>
								<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[index_03]">首页中部双拼广告①</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_03]"><?php echo $options['index_03']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（580X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[index_04]">首页中部双拼广告②</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_04]"><?php echo $options['index_04']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（480X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[index_05]">首页底部双拼广告①</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_05]"><?php echo $options['index_05']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（580X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[index_06]">首页底部双拼广告②</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[index_06]"><?php echo $options['index_06']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（480X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[cat_01]">分类页960x90广告</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[cat_01]"><?php echo $options['cat_01']; ?></textarea></div>
								<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[cat_02]">分类页双拼广告①</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[cat_02]"><?php echo $options['cat_02']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（580X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[cat_03]">分类页双拼广告②</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[cat_03]"><?php echo $options['cat_03']; ?></textarea></div>
								<div class="span span3"><small class="set-small">双拼左边（480X90）</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[page_01]">默认单页250x250广告</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[page_01]"><?php echo $options['page_01']; ?></textarea></div>
								<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[archive_01]">内容页960x90广告</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[archive_01]"><?php echo $options['archive_01']; ?></textarea></div>
								<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示</small></div>
							</div>
						</div>
						<div class="item">
							<div class="clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[footer_01]">底部广告</label></div>
								<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[footer_01]"><?php echo $options['footer_01']; ?></textarea></div>
								<div class="span span3"><small class="set-small">仅支持悬浮、图+、插屏等非固定大小广告</small></div>
							</div>
						</div>
					</li>
					<li>
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label">无线端广告设置</label></div>
							<div class="span span2"><p><strong>提示:</strong>全站广告，请直接填入广告html代码</p></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[mb_single_01]">内容页标题下方广告</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[mb_single_01]"><?php echo $options['mb_single_01']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示（建议横版自适应广告）</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[mb_single_02]">内容页内容下方广告</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[mb_single_02]"><?php echo $options['mb_single_02']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示（建议横版自适应广告）</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[mb_single_03]">内容页推荐上方广告</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[mb_single_03]"><?php echo $options['mb_single_03']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示（建议横版自适应广告）</small></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[mb_footer_xf]">全站底部悬浮广告</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[mb_footer_xf]"><?php echo $options['mb_footer_xf']; ?></textarea></div>
							<div class="span span3"><small class="set-small">输入广告代码，不填写则不显示（建议横版自适应广告）</small></div>
						</div>
					</li>
					<li>
						<div class="item item-1 clx">
							<div class="span span1"><label class="set-label">视频广告设置</label></div>
							<div class="span span2"><p><strong>提示:</strong>带星（*）号项为必填，不填广告不会显示</p></div>
						</div>
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[video_xml]">*广告文件路径</label></div>
							<div class="span span2">
								<input type="text" class="set-favicon set-input" name="mfthemes_options[video_xml]" value="<?php echo $options['video_xml']; ?>" placeholder="" /><a href="#" class="button">上传XML文件</a>
							</div>
							<div class="span span3"><small class="set-small">输入视频广告XML文件路径，不填写则不显示（准照VAST3.0视频广告规范）</small></div>
						</div>
						<div class="item clx">
						<div class="span span1"><label class="set-label" for="mfthemes_options[videoad]">视频广告</label></div>
						<div class="span span2 span2-notes">
						<input type="radio" name="mfthemes_options[videoad]" value="pre" <?php echo $options['videoad'] == 'pre'?'checked' : ''; ?> placeholder="" />视频前置广告 
						<input type="radio" name="mfthemes_options[videoad]" value="post" <?php echo $options['videoad'] == 'post'?'checked' : ''; ?> placeholder="" />视频结束广告
						<input type="radio" name="mfthemes_options[videoad]" value="mid" <?php echo $options['videoad'] == 'mid'?'checked' : ''; ?> placeholder="" />视频中途广告
						</div>
						<div class="span span3"><small class="set-small">选择广告出现的位置</small></div>
						</div>
						<div class="item">
						    <div class="span span1"><label class="set-label" for="mfthemes_options[adtime">中途广告出现时间</label></div>
							<div class="span span2 span2-notes"><input type="text" name="mfthemes_options[adtime]" value="<?php echo $options['adtime']; ?>" placeholder="请输入数字" /></div>
							<div class="span span3"><small class="set-small">仅在上述选项中选择“视频中途广告”时生效（单位秒）</small>
						</div><div class="set-gap"></div>
						</div>
					</li>	
					<li>	
					    <div class="item item-1 clx">
						<div class="span span1"><label class="set-label" for="mfthemes_options[cloud]">开启云存储</label></div>
						<div class="span span2 span2-notes">
						<input type="radio" name="mfthemes_options[cloud]" value="" <?php echo $options['cloud'] == ''?'checked' : ''; ?> placeholder="" />本地存储 
						<input type="radio" name="mfthemes_options[cloud]" value="1" <?php echo $options['cloud'] == '1'?'checked' : ''; ?> placeholder="" />七牛云存储
						<input type="radio" name="mfthemes_options[cloud]" value="2" <?php echo $options['cloud'] == '2'?'checked' : ''; ?> placeholder="" />又拍云存储
						</div>
						<div class="span span3"><small class="set-small">此选项仅针对于缩略图API调用接口，默认为本地储存</small></div>
						</div>
                        <div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[cloud_url]">静态文件加速</label></div>
							<div class="span span2 span2-notes">第三方托管URL<input type="text" name="mfthemes_options[cloud_url]" value="<?php echo $options['cloud_url']; ?>" placeholder="" /></div>
						<div class="span span3"><small class="set-small">如果静态文件CSS\JS存在第三方，请填写相应域名，不填写不启用</small></div>
						</div>
                        <div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[beian_id]">备案号</label></div>
							<div class="span span2 span2-notes">网站ICP备案号 <input type="text" name="mfthemes_options[beian_id]" value="<?php echo $options['beian_id']; ?>" placeholder="" /></div>
						</div>	
						<div class="item clx">
							<div class="span span1"><label class="set-label" for="mfthemes_options[footer]">底部版权</label></div>
							<div class="span span2"><textarea type="textarea" class="set-textaera" name="mfthemes_options[footer]"><?php echo $options['footer']; ?></textarea>
							<p><strong>底部预览:</strong><br/><?php $options = get_option('mfthemes_options');
							if( $options['footer']){?>
								<?php echo $options['footer'];?> <?php echo $options['beian_id'];?>
							<?php }else{?>
								<p>Copyright &copy; 2016-<?php echo date("Y");?> <a href="<?php bloginfo('url'); ?>" target="_blank" title="<?php bloginfo('name'); ?>"><?php bloginfo('name'); ?></a> All Rights Reserved. <?php echo $options['beian_id'];?></p>
							<?php }?></p>
							</div>
							<div class="span span3"><small class="set-small">底部版权不填写,则不修改</small></div>
						</div>						
					</li>
					<li>
						<div class="item item-1 ">
						<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[changyan_appid]">畅言APP ID</label></div>
								<div class="span span2"><input type="text" class="set-input" name="mfthemes_options[changyan_appid]" value="<?php echo $options['changyan_appid']; ?>" placeholder="" /></div>
								<div class="span span3"><small class="set-small">不填则不启用畅言，不懂请<a href="//changyan.kuaizhan.com/static/help/index.html" target="_blank">点我</a></small></div>
							</div>
						<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[changyan_appkey]">畅言APP KEY</label></div>
								<div class="span span2"><input type="text" class="set-input" name="mfthemes_options[changyan_appkey]" value="<?php echo $options['changyan_appkey']; ?>" placeholder="" /></div>
								<div class="span span3"><small class="set-small">不填则不启用畅言，不懂请<a href="//changyan.kuaizhan.com/static/help/index.html" target="_blank">点我</a></small></div>
							</div>
							<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[email_url]">邮箱订阅</label></div>
								<div class="span span2"><input type="text" class="set-input" name="mfthemes_options[email_url]" value="<?php echo $options['email_url']; ?>" placeholder="" /></div>
								<div class="span span3"><small class="set-small">邮箱订阅页面链接，获取地址<a href="//list.qq.com" target="_blank">点我</a></small></div>
							</div>
							<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[email]">合作邮箱</label></div>
								<div class="span span2"><input type="text" class="set-input" name="mfthemes_options[email]" value="<?php echo $options['email']; ?>"placeholder="" /></div>
								<div class="span span3"><small class="set-small">填写合作邮箱地址</small></div>
							</div>
							<div class="set-sns clx">
								<div class="span span1"><label class="set-label" for="mfthemes_options[email_feed]">留言建议</label></div>
								<div class="span span2"><input type="text" class="set-input" name="mfthemes_options[email_feed]" value="<?php echo $options['email_feed']; ?>"placeholder="" /></div>
								<div class="span span3"><small class="set-small">填写建议邮箱地址</small></div>
							</div>
						</div>						
					</li>
					<li>
						<div class="item item-1 ">
						    <div class="span span1"><label class="set-label" for="mfthemes_options[cat_id_m">无线首页分类设置</label></div>
							<div class="span span2 span2-notes"><input type="text" name="mfthemes_options[cat_id_m]" value="<?php echo $options['cat_id_m']; ?>" placeholder="分类ID" /></div>
							<div class="span span3"><small class="set-small">输入需要在首页显示的分类ID，以英文逗号隔开</small>
						</div><div class="set-gap"></div>
						</div>
					</li>
					<li>
					<div class="mfthemes_option_wrap">
						<div class="mfthemes_option_section">
							<h2>主题说明</h2>
						</div>
						<div class="mfthemes_helppage">
							<p>当前主题：<?php $theme_data = get_theme_data(ABSPATH . 'wp-content/themes/KuImg_V4.0/style.css');echo $theme_data['Title']; ?></p>
							<p>主题版本：<?php $theme_data = get_theme_data(ABSPATH . 'wp-content/themes/KuImg_V4.0/style.css');echo $theme_data['Version']; ?></p>
							<p>主题作者：<a href="http://www.dz9.net/" target="_blank" title="东少" rel="external">东少</a></p>
							<p style="line-height:24px">此主题为收费主题，请勿随意分发传播，如有发现停止一切更新以及售后支持。感谢你对正版的支持！</br>
							主题版权归作者东少所有，禁止任何未经授权的版权篡改。主题使用中有疑问可联系本人QQ：932340056。<br/>
							如果你觉得此主题不错，请点击支付宝按钮扫描二维码打赏我：<a href="javascript:void(0);" onmouseout="document.getElementById('alipayDiv').style.display='none'" onmouseover="document.getElementById('alipayDiv').style.display=''"><img src="<?php bloginfo('template_directory') ?>/style/images/alipay.png"></a>
							<div id="alipayDiv" style="display:none;margin-top: -213px;margin-left: 440px;"><img src="//ww2.sinaimg.cn/mw690/b6839357gw1f9clh55qzqj20as05kgml.jpg"/> </div>
							</p>
						</div>
					</div>
					</li>
				</ul>
			</div>
			<div class="mfthemes_submit_form">
				<input type="submit" class="button-primary mfthemes_submit_form_btn" name="save" value="保存更改"/>
			</div>
		</form>
	<form method="post">
		<div class="mfthemes_reset_form">
			<input type="submit" name="reset" value="重置" class="button-secondary mfthemes_reset_form_btn"/> 重置有风险，操作需谨慎！
			<input type="hidden" name="reset" value="reset" />
		</div>
	</form>
	</div>
	<?php wp_enqueue_media();?>
<?php } ?>