<?php
/**
 * KuImg Login Part
 * Hooks into various actions in the theme.
 *
 *
 * @version 1.0
 * @author MctDs
 * @package KuImg
 * @copyright 2014 all rights reserved
 *
 */

global $pagenow;

// what you want login or not
$theaction = isset($_GET['action']) ? $_GET['action'] : '';

// if the user is on the login page, then let the games begin
if ($pagenow == 'wp-login.php' && $theaction != 'logout' && !isset($_GET['key'])) add_action('init', 'mfthemes_login_init', 98);

// main function that routes the request
function mfthemes_login_init() {

	nocache_headers();
	if ( is_user_logged_in() ){
		global $current_user;
		wp_redirect( get_option('siteurl') . '/wp-admin' );
	}
    $action = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'login';

	if( $action == "register" || $action == "login"){session_start();}
    switch($action) :
        case 'lostpassword' :
        case 'retrievepassword' :
            mfthemes_password();
        break;
        case 'register':
			mfthemes_register();
		break;
        case 'login':
        default:
            mfthemes_login();
        break;
    endswitch;
    exit;
}

// Show login forms
function mfthemes_login() {

	global $posted;
	
	$errors = mfthemes_process_login_form();

	// Login times plus 1	
	//$_SESSION["trytimes"] = 0;
	
	// Clear errors if loggedout is set.
	if ( !empty($_GET['loggedout']) ) $errors = new WP_Error();
            
	if ( isset($_POST['testcookie']) && empty($_COOKIE[TEST_COOKIE]) )
			$errors->add('test_cookie', __('你必须启用Cookie才能继续。','KuImg'));
	
	if ( isset($_GET['loggedout']) && TRUE == $_GET['loggedout'] )
			$message = __('你已经登出。','KuImg');

	elseif	( isset($_GET['registration']) && 'disabled' == $_GET['registration'] )	
			$errors->add('registerdisabled', __('目前新用户注册被关闭。','KuImg'));

	elseif	( isset($_GET['checkemail']) && 'confirm' == $_GET['checkemail'] )	
			$message = __('请检查你的邮箱，确认注册链接。','KuImg');

	elseif	( isset($_GET['checkemail']) && 'newpass' == $_GET['checkemail'] )	
			$message = __('新密码已发送至你的邮箱。','KuImg');

	elseif	( isset($_GET['checkemail']) && 'registered' == $_GET['checkemail'] )
			$message = __('注册完成,请检查您的电子邮件。','KuImg');

	get_template_part('header');
	?>
	<div id="userReg">
		<div class="h2">用户登录</div>
		<div class="xian"></div>
		<?php 
			if (isset($message) && !empty($message)) echo '<div id="item-error"><p class="success">'.$message.'</p></div>';
			if (isset($errors) && sizeof($errors)>0 && $errors->get_error_code()) :
				echo '<div id="item-error">';
				foreach ($errors->errors as $error) {
					echo '<p class="success">'.$error[0].'</p>';
				}
				echo '</div>';
			endif;
			mfthemes_login_form(); 
		?>
		<div style="float:left;width:450px;overflow:hidden;">
                        <div style="clear:left"></div>
                        <div style="float:left; width:440px; padding-left:10px; line-height:20px; height:360px; overflow:hidden; border-left:1px solid #ccc; margin-top:10px;">
                            <h3>欢迎使用<?php bloginfo('name'); ?></h3>
                            <p><?php bloginfo('name'); ?>的宗旨是分享提供高清品质的美女图片，注册会员以后，您也可以与大家分享您的收藏美图。</p>
                            <p>注册会员，您可以关注一些你喜欢的美图和图片的上传者，以及时得到他们上传新美图的信息动态。</p>
                            <p>如果您也上传分享了好的美图，其它会员也可能会关注您，他们将成为您的粉丝。</p>
                            <p>我们会一直在完善我们的服务，提供更好的浏览体验，提供更好更多的高清美女图片。</p>
                            <p><?php bloginfo('name'); ?>期待每一个会员的加入！</p>
                        </div>
                    </div>
	</div>
	<div style="clear:left"></div>
	<?php get_template_part('footer');
}

// Show register forms
function mfthemes_register() {

	global $posted;
	
	$result = mfthemes_process_register_form();
		
	$errors = $result['errors'];
	$posted = $result['posted'];
	
	// Clear errors if loggedout is set.
	if ( !empty($_GET['loggedout']) ) $errors = new WP_Error();

	// If cookies are disabled we can't log in even with a valid user+pass
	if ( isset($_POST['testcookie']) && empty($_COOKIE[TEST_COOKIE]) )
			$errors->add('test_cookie', __('你必须启用Cookie才能继续。','KuImg'));
	
	if ( isset($_GET['loggedout']) && TRUE == $_GET['loggedout'] )
			$message = __('你已经登出。','KuImg');

	elseif	( isset($_GET['registration']) && 'disabled' == $_GET['registration'] )	
			$errors->add('registerdisabled', __('目前新用户注册被关闭。','KuImg'));

	elseif	( isset($_GET['checkemail']) && 'confirm' == $_GET['checkemail'] )	
			$message = __('请检查你的邮箱，确认注册链接。','KuImg');

	elseif	( isset($_GET['checkemail']) && 'newpass' == $_GET['checkemail'] )	
			$message = __('新密码已发送至你的邮箱。','KuImg');

	elseif	( isset($_GET['checkemail']) && 'registered' == $_GET['checkemail'] )
			$message = __('注册完成,请检查您的电子邮件。','KuImg');

	get_template_part('header');
	?>
	<div id="userReg">
		<div class="h2">用户注册</div>
		<div class="xian"></div>
		<?php 
			if (isset($message) && !empty($message)) echo '<div id="item-error"><p class="success">'.$message.'</p></div>';
			if (isset($errors) && sizeof($errors)>0 && $errors->get_error_code()) :
				echo '<div id="item-error">';
				foreach ($errors->errors as $error) {
					echo '<p class="success">'.$error[0].'</p>';
				}
				echo '</div>';
			endif;
			mfthemes_register_form( '', '' );
		?>
		
		<div style="float:left;width:450px;overflow:hidden;">
                        <div style="clear:left"></div>
                        <div style="float:left; width:440px; padding-left:10px; line-height:20px; height:360px; overflow:hidden; border-left:1px solid #ccc; margin-top:10px;">
                            <h3>欢迎使用<?php bloginfo('name'); ?></h3>
                            <p><?php bloginfo('name'); ?>的宗旨是分享提供高清品质的美女图片，注册会员以后，您也可以与大家分享您的收藏美图。</p>
                            <p>注册会员，您可以关注一些你喜欢的美图和图片的上传者，以及时得到他们上传新美图的信息动态。</p>
                            <p>如果您也上传分享了好的美图，其它会员也可能会关注您，他们将成为您的粉丝。</p>
                            <p>我们会一直在完善我们的服务，提供更好的浏览体验，提供更好更多的高清美女图片。</p>
                            <p><?php bloginfo('name'); ?>期待每一个会员的加入！</p>
                        </div>
                    </div>
	</div>
	<div style="clear:left"></div>
	<?php get_template_part('footer');
}

// show the forgot your password page
function mfthemes_password() {
    $errors = new WP_Error();

    if ( isset($_POST['user_login']) && $_POST['user_login'] ) {
        $errors = retrieve_password();

        if ( !is_wp_error($errors) ) {
            wp_redirect('wp-login.php?checkemail=confirm');
            exit();
        }

    }

    if ( isset($_GET['error']) && 'invalidkey' == $_GET['error'] ) $errors->add('invalidkey', __('抱歉，该键似乎是不可用的。','KuImg'));

    do_action('lost_password');
    do_action('lostpassword_post');

    get_template_part('header');
	?>
	<div id="userReg" style="width:100%;">
		<div class="h2">找回密码</div>
		<div class="xian"></div>
		<?php 
			if (isset($message) && !empty($message)) echo '<div id="item-error"><p class="success">'.$message.'</p></div>';
			if (isset($errors) && sizeof($errors)>0 && $errors->get_error_code()) :
				echo '<div id="item-error">';
				foreach ($errors->errors as $error) {
					echo '<p class="success">'.$error[0].'</p>';
				}
				echo '</div>';
			endif;
			mfthemes_forgot_password_form(); 
		?>
	</div>
	<div style="clear:left"></div>
	<?php get_template_part('footer');
}

?>