<?php
/**
 * Theme functions file
 *
 *
 * @package KuImg
 * @author Mufeng
 */

// Theme-specific files
require( dirname(__FILE__) . '/functions/themes-function.php' );

//获取缩略图地址
if ( function_exists('add_theme_support') )
 add_theme_support('post-thumbnails');
 function catch_first_image() {
  global $post, $posts;
  $first_img = '';
  ob_start();
  ob_end_clean();
  $dir_url = get_bloginfo('template_url');
  $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
  $first_img = $matches [1] [0];
  if(empty($first_img)){ 
  $first_img = "$dir_url/style/images/default.jpg";
  }
  $video_poster = get_post_meta($post->ID,"video_poster",true);
				if ( empty( $video_poster ) ) {
                    $video_poster = $first_img;
                }
  return $video_poster;
 }

//去头部信息
remove_action( 'wp_head', 'rsd_link' );
remove_action( 'wp_head', 'wp_shortlink_wp_head', 10, 0 );
remove_action( 'wp_head', 'wlwmanifest_link' );
remove_action( 'wp_head', 'wp_generator' );
remove_action( 'wp_head', 'rel_canonical' );
remove_action( 'wp_head', 'index_rel_link' ); // Removes the index link
remove_action( 'wp_head', 'parent_post_rel_link', 10, 0 ); // Removes the prev link
remove_action( 'wp_head', 'start_post_rel_link', 10, 0 ); // Removes the start link
remove_action(  'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0 );
remove_action( 'wp_head', 'feed_links', 2 );//文章和评论feed
remove_action( 'wp_head', 'feed_links_extra', 3 ); //分类等feed

//文本tag
function tagtext(){
global $post;
$gettags = get_the_tags($post->ID);
if ($gettags) {
foreach ($gettags as $tag) {
$posttag[] = $tag->name;
}
$tags = implode( ',', $posttag );
echo $tags;
}
}

/**
 * Disable the emoji's
 */
 function disable_emojis() {
 remove_action( 'wp_head', 'print_emoji_detection_script', 7 );
 remove_action( 'admin_print_scripts', 'print_emoji_detection_script' );
 remove_action( 'wp_print_styles', 'print_emoji_styles' );
 remove_action( 'admin_print_styles', 'print_emoji_styles' );
 remove_filter( 'the_content_feed', 'wp_staticize_emoji' );
 remove_filter( 'comment_text_rss', 'wp_staticize_emoji' );
 remove_filter( 'wp_mail', 'wp_staticize_emoji_for_email' );
 add_filter( 'tiny_mce_plugins', 'disable_emojis_tinymce' );
 }
 add_action( 'init', 'disable_emojis' );
/**
 * Filter function used to remove the tinymce emoji plugin.
 */
 function disable_emojis_tinymce( $plugins ) {
 if ( is_array( $plugins ) ) {
 return array_diff( $plugins, array( 'wpemoji' ) );
 } else {
 return array();
 }
 }
 
 //禁止加载默认jq库
if ( !is_admin() ) { // 后台不禁止
function my_init_method() {
wp_deregister_script( 'jquery' ); // 取消原有的 jquery 定义
}
add_action('init', 'my_init_method');
}
wp_deregister_script( 'l10n' );

 //获取当前标签ID
$tag_title = single_tag_title('', false);
$tag = get_term_by('name', $tag_title, 'post_tag');
$tag_id = $tag->term_id; 

//根据标签ID获取文章数
function get_tag_post_count_by_id( $tag_id ) {
    $tag = get_term_by( 'id', $tag_id, 'post_tag' );
    _make_cat_compat( $tag );
    return $tag->count;
   }
   
//WordPress去除category
add_action( 'load-themes.php',  'no_category_base_refresh_rules');   
add_action('created_category', 'no_category_base_refresh_rules');   
add_action('edited_category', 'no_category_base_refresh_rules');   
add_action('delete_category', 'no_category_base_refresh_rules');   
function no_category_base_refresh_rules() {       
    global $wp_rewrite;   
    $wp_rewrite -> flush_rules();   
}   
// Remove category base   
add_action('init', 'no_category_base_permastruct');   
function no_category_base_permastruct() {   
    global $wp_rewrite, $wp_version;   
    if (version_compare($wp_version, '3.4', '<')) {   
        // For pre-3.4 support   
        $wp_rewrite -> extra_permastructs['category'][0] = '%category%';   
    } else {   
        $wp_rewrite -> extra_permastructs['category']['struct'] = '%category%';   
    }   
}   
  
// Add our custom category rewrite rules   
add_filter('category_rewrite_rules', 'no_category_base_rewrite_rules');   
function no_category_base_rewrite_rules($category_rewrite) {   
    //var_dump($category_rewrite); // For Debugging   
  
    $category_rewrite = array();   
    $categories = get_categories(array('hide_empty' => false));   
    foreach ($categories as $category) {   
        $category_nicename = $category -> slug;   
        if ($category -> parent == $category -> cat_ID)// recursive recursion   
            $category -> parent = 0;   
        elseif ($category -> parent != 0)   
            $category_nicename = get_category_parents($category -> parent, false, '/', true) . $category_nicename;   
        $category_rewrite['(' . $category_nicename . ')/(?:feed/)?(feed|rdf|rss|rss2|atom)/?$'] = 'index.php?category_name=$matches[1]&feed=$matches[2]';   
        $category_rewrite['(' . $category_nicename . ')/page/?([0-9]{1,})/?$'] = 'index.php?category_name=$matches[1]&paged=$matches[2]';   
        $category_rewrite['(' . $category_nicename . ')/?$'] = 'index.php?category_name=$matches[1]';   
    }   
    // Redirect support from Old Category Base   
    global $wp_rewrite;   
    $old_category_base = get_option('category_base') ? get_option('category_base') : 'category';   
    $old_category_base = trim($old_category_base, '/');   
    $category_rewrite[$old_category_base . '/(.*)$'] = 'index.php?category_redirect=$matches[1]';   
  
    //var_dump($category_rewrite); // For Debugging   
    return $category_rewrite;   
}   
// Add 'category_redirect' query variable   
add_filter('query_vars', 'no_category_base_query_vars');   
function no_category_base_query_vars($public_query_vars) {   
    $public_query_vars[] = 'category_redirect';   
    return $public_query_vars;   
}   
// Redirect if 'category_redirect' is set   
add_filter('request', 'no_category_base_request');   
function no_category_base_request($query_vars) {   
    //print_r($query_vars); // For Debugging   
    if (isset($query_vars['category_redirect'])) {   
        $catlink = trailingslashit(get_option('home')) . user_trailingslashit($query_vars['category_redirect'], 'category');   
        status_header(301);   
        header("Location: $catlink");   
        exit();   
    }   
    return $query_vars;   
}

//禁止头部加载s.w.org
function remove_dns_prefetch( $hints, $relation_type ) {
if ( 'dns-prefetch' === $relation_type ) {
return array_diff( wp_dependencies_unique_hosts(), $hints );
}
return $hints;
}
add_filter( 'wp_resource_hints', 'remove_dns_prefetch', 10, 2 );

//禁用REST API
add_filter('rest_enabled', '_return_false'); add_filter('rest_jsonp_enabled', '_return_false');

//移除wp-json链接
remove_action( 'wp_head', 'rest_output_link_wp_head', 10 );
remove_action( 'wp_head', 'wp_oembed_add_discovery_links', 10 );
?>