<?php
/**
 * KuImg Actions
 * Hooks into various actions in the theme.
 *
 *
 * @version 1.0
 * @author MctDs
 * @package KuImg
 * @copyright 2014 all rights reserved
 *
 */
function mfthemes_meta() {global $pagenow;?>
<?php if ($pagenow == "wp-login.php") { 
		if (isset($_GET['action'])) $action = $_GET['action']; else $action='';
        switch($action) :
            case 'lostpassword':
                $title = __('找回密码-','KuImg').get_bloginfo('name');
            break;
            case 'register':
                $title = __('注册-','KuImg').get_bloginfo('name');
            break;
			case 'login':
            default:
                $title = __('登录-','KuImg').get_bloginfo('name');
            break;
        endswitch;
	?>
<title><?php echo $title; ?></title>
<?php } ?>
<?php if ( is_home() ) { ?><title><?php bloginfo('description'); ?>-<?php bloginfo('name'); ?></title><?php } ?>
<?php if ( is_search() ) { ?><title><?php _e('搜索&#34;','KuImg');echo $_GET['s'];echo "&#34;";?><?php $paged = get_query_var('paged'); if ( $paged > 1 ) printf(' （第 %s 页） ',$paged); ?>-<?php bloginfo('name'); ?></title><?php } ?>
<?php if ( is_single() ) { ?><title><?php echo trim(wp_title('',0)); ?><?php $paged = get_query_var('paged'); if ( $paged > 1 ) printf(' （第 %s 页） ',$paged); ?>-<?php bloginfo('name'); ?></title><?php } ?>
<?php if ( is_archive() ) { ?><title><?php single_cat_title(); ?><?php $paged = get_query_var('paged'); if ( $paged > 1 ) printf(' （第 %s 页） ',$paged); ?>-<?php bloginfo('name'); ?></title><?php } ?>
<?php if ( is_page() ) { ?>
<?php if( is_page('rand') ){ ?>
<title><?php _e('随机看图','KuImg'); ?><?php $paged = get_query_var('paged'); if ( $paged > 1 ) printf(' （第 %s 页） ',$paged); ?>-<?php bloginfo('name'); ?></title>
<?php }elseif( is_page('new') ){ ?>
<title><?php _e('最新图片大全','KuImg'); ?><?php $paged = get_query_var('paged'); if ( $paged > 1 ) printf(' （第 %s 页） ',$paged); ?>-<?php bloginfo('name'); ?></title>
<?php }else{ ?>
<title><?php echo trim(wp_title('',0)); ?>-<?php bloginfo('name'); ?></title>
<?php }?>
<?php } ?>
<?php if ( is_404() ) { ?>
<title>404-<?php bloginfo('name'); ?></title>
<?php } ?>

<?php
	$options = get_option('mfthemes_options'); 
	global $post;
	if (is_home()){
		$keywords = $options['keywords'];
		$description = $options['description'];
	}elseif (is_single()){
		$keywords = get_post_meta($post->ID, "keywords", true);
		if($keywords == ""){
			$tags = wp_get_post_tags($post->ID);
			foreach ($tags as $tag){
				$keywords = $keywords.$tag->name.",";
			}
			$keywords = rtrim($keywords, ', ');
		}
		$description = get_post_meta($post->ID, "desc", true);
		if($description == ""){
			if($post->post_excerpt){
				$description = $post->post_excerpt;
			}else{
				$description = get_the_title();
			}
		}
	}elseif (is_page()){
		$keywords = get_post_meta($post->ID, "keywords", true);
		$description = get_post_meta($post->ID, "description", true);
	}elseif (is_category()){
		$keywords = single_cat_title('', false);
		$description = category_description();
	}elseif (is_tag()){
		$keywords = single_tag_title('', false);
		$tag_title = single_tag_title('', false);
        $tag = get_term_by('name', $tag_title, 'post_tag');
        $tag_id = $tag->term_id; 
		$description = get_term_meta( $tag_id, '_id_tinymce',true );
		if($description == ""){
				$description = tag_description();
		}
	}
	$keywords = trim(strip_tags($keywords));
	$description = trim(strip_tags($description));
	?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<meta name="description" content="<?php echo $description; ?>" />
<?php $favicon =  $options['favicon'] ? $options['favicon'] : get_bloginfo('template_url')."/style/images/favicon.png" ;?>
<link rel="shortcut icon" href="<?php echo $favicon;?>" type="image/x-icon" />
<?php 
}

?>