<?php
/**
 * KuImg Actions
 * Hooks into actions in the theme.
 *
 *
 * @version 1.0
 * @author MctDs
 * @package KuImg
 * @copyright 2014 all rights reserved
 *
 */


/*
* Post pagenavi function
*/
function pagenavi($s = null) {
	if ( is_singular() ) return;
	global $wp_query,$paged;
	$p = 2;
	
	$max_page = $wp_query->max_num_pages;

	if ( empty( $paged ) ) $paged = 1;
	if ( $paged > 1 ) p_link( $paged - 1, __('上一页','KuImg'), __('<上一页','KuImg') );
	if ( $paged < $max_page ) p_link( $paged + 1,__('下一页','KuImg'), __('下一页>','KuImg') );
}
function p_link( $i, $title = '', $linktype = '' ) {
	if ( $title == '' ) $title = __('第', 'KuImg').$i.__('页','KuImg');
	if ( $linktype == '' ) { $linktext = $i; } else { $linktext = $linktype; }
	echo "<p class='active'><a href='", esc_html( get_pagenum_link( $i ) ), "'>{$linktext}</a></p>";
}

?>