<?php
/*
Plugin Name: DW Mobile Switcher
Plugin URI: http://Devework.com/
Description: DeveWork旗下移动主题专用主题（如DeveMobile）切换插件。(更新：2014.3.11)
Version: 1.0
Author: Jeff
Author URI: http://Devework.com/
@ Thanks to mg12’s WP Mobile themes plugin.
*/

//移动主题导航菜单
if(function_exists('register_nav_menu')){
    register_nav_menu( 'mobilemenu', '移动主题菜单' );
}


//cookie support (检测是否存在cookie，如果存在则不做主题切换等工作)
if (!isset($_COOKIE['return_desktop'])){

//载入user-agent检测插件Mobile_Detect
require_once 'Mobile_Detect.php';

//执行主题切换函数
class DWMobileSwitcher {
	private static $theme;
    private static $detect;
	function DWMobileSwitcher($mobileTheme, $tabletTheme) {
		$detect = new DW_Mobile_Detect();

		if($detect->isMobile()) {
			if($tabletTheme && $detect->isTablet()) {
				$this->theme = $tabletTheme;
			} else if($mobileTheme) {
				$this->theme = $mobileTheme;
			}
			if($this->theme){
				add_filter('stylesheet', array(&$this, 'getStylesheet'));
				add_filter('template', array(&$this, 'getTemplate'));
			}
		}
	}

	public function getTemplate() {
		$theme = $this->theme;
		if (empty($theme)) {
			return $template;
		}
		$theme = get_theme($theme);
		if (empty($theme)) {
			return $template;
		}
		// 不显示非公开主题模板
		if (isset($theme['Status']) && $theme['Status'] != 'publish') {
			return $template;
		}
		return $theme['Template'];
	}

	public function getStylesheet($theme) {
		$theme = $this->theme;
		if (empty($theme)) {
			return $stylesheet;
		}
		$theme = get_theme($theme);
		//不显示非公开主题模板
		if (isset($theme['Status']) && $theme['Status'] != 'publish') {
			return $template;
		}		
		if (empty($theme)) {
			return $stylesheet;
		}
		return $theme['Stylesheet'];
	}
}

// apply mobile theme激活手机主题
$options = get_option('dw_mobile_switcher_options');
$mobileThemeName = $options['mobile_theme'];
if(!$mobileThemeName) {
	$mobileThemeName = get_current_theme();
}
$tabletThemeName = $options['tablet_theme'];
if(!$tabletThemeName) {
	$tabletThemeName = get_current_theme();
}
new DWMobileSwitcher($mobileThemeName, $tabletThemeName);

}//cookie support end

// add settings link to plugin item
function actionLinks( $links ) {
	$settingsLink = '<a href="/wp-admin/themes.php?page=dw-mobile-switcher.php">' . __('设置') . '</a>'; 
	array_unshift($links, $settingsLink);
	return $links;
}
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'actionLinks');


/*设置界面*/
class DWMobileSwitcherOptions {

	/*get settings*/
	private function getOptions() {
		$options = get_option('dw_mobile_switcher_options');
		if(!is_array($options)) {
			$options['mobile_theme'] = '';
			$options['tablet_theme'] = '';
			update_option('dw_mobile_switcher_options', $options);
		}
		return $options;
	}

	/* update settings 更新设置 */
	public function updateOptions() {
		if(isset($_POST['dw_mobile_switcher_save'])) {
			$options = DWMobileSwitcherOptions::getOptions();
			$themeNames = DWMobileSwitcherOptions::getThemeNames();
			$options['mobile_theme'] = $_POST['mobile_theme'];
			$options['tablet_theme'] = $_POST['tablet_theme'];

			if(!DWMobileSwitcherOptions::isThemeIncluded($options['mobile_theme'], $themeNames)) {
				$options['mobile_theme'] = DWMobileSwitcherOptions::getDefaultThemeName();
			}
	
			if(!DWMobileSwitcherOptions::isThemeIncluded($options['tablet_theme'], $themeNames)) {
				$options['tablet_theme'] = DWMobileSwitcherOptions::getDefaultThemeName();
			}
	
			update_option('dw_mobile_switcher_options', $options);

		} else {
			DWMobileSwitcherOptions::getOptions();
		}
		// add settings page to menu
		add_menu_page('Mobile Switcher 设置页面', '移动主题', 'edit_theme_options', basename(__FILE__), array('DWMobileSwitcherOptions', 'display'),'dashicons-welcome-view-site');
	}

	/*display form 展示表格*/
	public function display() {
		$options = DWMobileSwitcherOptions::getOptions();
		$themeNames = DWMobileSwitcherOptions::getThemeNames();
		$mobileThemeName = $options['mobile_theme'];
		$tabletThemeName = $options['tablet_theme'];
?>

<div class="wrap">
	<h2>Mobile Switcher 设置页面</h2>

	<?php if(!empty($_POST)) : ?>
		<div class='updated fade'><p>设置保存成功！</p></div>
	<?php endif; ?>

	<div id="poststuff" class="has-right-sidebar">
		<div id="post-body">
			<div id="post-body-content">
				<form action="#" method="POST" name="wp_mobile_themes_form">
					<table class="form-table">
						<tbody>
				
									<p  style="font-size: 14px;"><?php printf('<div class="dashicons dashicons-desktop"></div>当前电脑端（PC桌面）主题：<a href="/wp-admin/themes.php">%1$s</a>。', DWMobileSwitcherOptions::getDefaultThemeName()); ?></p>
									<p  style="font-size: 14px;">使用手机和平板访问网站的用户将看到以下选择的移动主题界面：</p>									
				
							<tr valign="top">
								<th scope="row"><div class="dashicons dashicons-smartphone"></div>手机主题：</th>
								<td >
									<select name="mobile_theme">
										<?php
											foreach ($themeNames as $themeName) {
												$selectedProperty = '';
												$defaultTip = '';

												if($themeName == $mobileThemeName) {
													$selectedProperty = ' selected="selected"';
												}
												if($themeName == DWMobileSwitcherOptions::getDefaultThemeName()) {
													$defaultTip = __(' (deault)', 'dw-mobile-switcher');
												}
												echo '<option value="' . $themeName . '"' . $selectedProperty . '>' . htmlspecialchars($themeName) . $defaultTip . '</option>';
											}
										?>
									<select>
									<p class="description">手机主题将应用在 iPhone、iPod touch、Nexus、BlackBerry等手机和小型移动设备上。</p>
								</td>
							</tr>

							<tr valign="top">
								<th scope="row"><div class="dashicons dashicons-tablet"></div>平板主题：</th>
								<td>
									<select name="tablet_theme">
										<?php
											foreach ($themeNames as $themeName) {
												$selectedProperty = '';
												$defaultTip = '';

												if($themeName == $tabletThemeName) {
													$selectedProperty = ' selected="selected"';
												}
												if($themeName == DWMobileSwitcherOptions::getDefaultThemeName()) {
													$defaultTip = __(' (deault)', 'dw-mobile-switcher');
												}
												echo '<option value="' . $themeName . '"' . $selectedProperty . '>' . htmlspecialchars($themeName) . $defaultTip . '</option>';
											}
										?>
									<select>
									<p class="description">平板主题将应用在 iPad、Kindle、Nexus 平板、三星平板等平板设备上。</p>
								</td>
							</tr>

						</tbody>
					</table>

					<p class="submit">
						<input class="button-primary" type="submit" name="dw_mobile_switcher_save" value="保存设置" />
					</p>
						<p>使用说明：在“手机主题”“平板主题”选择相应的移动主题，保存即可。</p>
				</form>
			</div>
		</div>
	</div>
</div>

<?php
	}

	/*return the name of themes*/
	private function getThemeNames() {
		$themes = get_themes();
		$themeNames = array_keys($themes);
		natcasesort($themeNames);

		return $themeNames;
	}

	/*return the name of default theme*/
	private function getDefaultThemeName() {
		$themeName = get_current_theme();
		return $themeName;
	}

	/* is the theme included*/
	private function isThemeIncluded($obj, $list) {
		foreach ($list as $item) {
			if($item == $obj) {
				return true;
			}
		}

		return false;
	}
}

add_action('admin_menu', array('DWMobileSwitcherOptions', 'updateOptions'));



?>
