<?php

class mflikes {
	
	private		$ip;
	public		$post_id;
	public		$user_id;
	public		$likes_count;
	public		$user_is_loggedin;
	
	public function __construct($post_id, $user_id){
		$this->ip = $_SERVER['REMOTE_ADDR'];
		$this->post_id = $post_id;
		$this->user_id = $user_id;
		
		if($user_id != 0 && $user_id >= 1){
			$this->user_is_loggedin = true;
		}
		
		$this->likes_count();
	} // end mflikes __construct


	public function likes_count(){
		global $wpdb, $mf_tablename;
		
		// check in the db for likes
		$likes_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $mf_tablename WHERE post_id = %d", $this->post_id));
		
		// returns likes, return 0 if no likes were found
		$this->likes_count = $likes_count;
		
	} // likes_count
	
	
	public function check_recurring_like(){
		global $wpdb, $mf_tablename;
		
		if($this->user_is_loggedin){
			
			// user is logged in	
			$likes_check = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $mf_tablename
											WHERE	post_id = %d
											AND		user_id = %d", $this->post_id, $this->user_id));	
			if($likes_check === 0){
				// user didn't like this post before
				return false;
			} elseif($likes_check >= 1){
				// user liked this post before
				return true;	
			}
		} else{
			// user not logged in, check by ip address
			$likes_check = $wpdb->get_var($wpdb->prepare("SELECT COUNT(*) FROM $mf_tablename
											WHERE	post_id = %d
											AND		ip_address = %s
											AND		user_id = %d", $this->post_id, $this->ip, 0));
			
			if($likes_check === 0){
				// ip didn't like this post before
				return false;
			} elseif($likes_check >= 1){
				// if liked this post before
				return true;	
			}
		}
	} // end check_recurring_like
	
	
	public function like_post(){
		global $wpdb, $mf_tablename;
		
		if(!$this->check_recurring_like()){
			
			// Adds a new database row if not liked and then unliked
			
			if($this->user_is_loggedin){
				// adds a new like in the database using user id & ip address
				$wpdb->insert($mf_tablename, array('post_id' => $this->post_id, 
													'user_id' => $this->user_id,
													'ip_address' => $this->ip), array('%d', '%d', '%s'));
			} else {
				// adds a new like in the database using user id = 0 & ip address
				$wpdb->insert($mf_tablename, array('post_id' => $this->post_id, 
													'user_id' => 0,
													'ip_address' => $this->ip), array('%d', '%d', '%s'));
			}
			
		}
		
		// count the new likes count
		$this->likes_count();
		
	} // end like_post
	//文章页按钮	
	public function like_button(){
		$class = $this->check_recurring_like() ? ' TAlike' : '';
		
		$userId = $this->user_is_loggedin = true ? $this->user_id : 0;
		
		$postId = $this->post_id;
		
		$onclick_like = "mflikes('$postId', '$userId')";
		$button .= '<span data-isup="false" class="article-up"><span class="pagel-icon '.$class.' mflikes-post-'.$this->post_id.' subBtn" onclick="'.$onclick_like.'"><div class="icon-anim"></div></span><span class="text"><em class="mflikes-'.$this->post_id.'-number"> '.$this->likes_count.' </em><span>个赞</span></span></span>';
		return $button;
	}
    //显示数量
	public function like_button1(){
		$class = $this->check_recurring_like() ? ' TAlike' : '';
		
		$userId = $this->user_is_loggedin = true ? $this->user_id : 0;
		
		$postId = $this->post_id;
		
		$onclick_like = "mflikes('$postId', '$userId')";
		$button =  '<b class="mflikes-'.$this->post_id.'-number"> '.$this->likes_count.' </b>';
		return $button;
	}
	//相册页面按钮
	public function like_button2(){
		$class = $this->check_recurring_like() ? ' TAlike' : '';
		
		$userId = $this->user_is_loggedin = true ? $this->user_id : 0;
		
		$postId = $this->post_id;
		
		$onclick_like = "mflikes('$postId', '$userId')";
		$button =  '<span class="'.$class.' mflikes-post-'.$this->post_id.' subBtn" id="btnRecommend" onclick="'.$onclick_like.'"><div style="color:#FFF;padding:63px 0 0 0;"><span class="mflikes-'.$this->post_id.'-number" id="recommend_count1"> '.$this->likes_count.' </span></div></span>';
		return $button;
	}	
	//移动端按钮
	public function like_button3(){
		$class = $this->check_recurring_like() ? ' TAlike' : '';
		
		$userId = $this->user_is_loggedin = true ? $this->user_id : 0;
		
		$postId = $this->post_id;
		
		$onclick_like = "mflikes('$postId', '$userId')";
		$button =  '<span><a class="good '.$class.' mflikes-post-'.$this->post_id.'" href="javascript:;" onclick="'.$onclick_like.'"><i></i><d class="mflikes-'.$this->post_id.'-number"> '.$this->likes_count.' </d>+</a></span>';
		return $button;
	}	
	//视频页按钮
	public function like_button4(){
		$class = $this->check_recurring_like() ? ' TAlike' : '';
		
		$userId = $this->user_is_loggedin = true ? $this->user_id : 0;
		
		$postId = $this->post_id;
		
		$onclick_like = "mflikes('$postId', '$userId')";
		$button =  '<a class="tlist '.$class.' mflikes-post-'.$this->post_id.'" href="javascript:;" onclick="'.$onclick_like.'"><img src="//www.pximg.com/wp-content/themes/KuImg_V4.0/style/images/dmz.png" alt="赞一下"><span class="rightWn"><b>赞一下</b><br><span>GOOD</span></span></a>';
		return $button;
	}
}
?>