<?php
/*
Plugin Name: mflikes
Plugin URI: http://mufeng.me/mflikes
Description: A plugin that one like the posts.
Version: 1.0.3
Author: mufeng
Author URI: http://mufeng.me
*/

// constants paths
define('ML_PATH', dirname(__FILE__));

// constants URIs
define('ML_URI', get_bloginfo('wpurl') . '/wp-content/plugins/mflikes');
define('ML_CSSURI', ML_URI . '/css');
define('ML_JSURI', ML_URI . '/js');
define('ML_IMGURI', ML_URI . '/images');


// Calls database global
global $wpdb, $mf_tablename;

// Combines default db tables prefix with our neMLy tabel name
$table_prefix = (isset($table_prefix)) ? $table_prefix : $wpdb->prefix;
$mf_tablename = $table_prefix . 'mflikes';


// includes plugin files
require_once(ML_PATH . '/class.mflikes.php');

// Runs when the plugin is activated
function mflikes_activate() {
	global $wpdb, $mf_tablename;
	if( $wpdb->get_var("show tables like '$mf_tablename'") != $mf_tablename ) {
		$wpdb->query("CREATE TABLE {$mf_tablename} (
			id      BIGINT(20) NOT NULL AUTO_INCREMENT,
			post_id BIGINT(20) NOT NULL,
			user_id BIGINT(20) NOT NULL,
			ip_address VARCHAR(25) NOT NULL,
			UNIQUE KEY id (id)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1");
	}
	
	$wpdb->query("ALTER TABLE `$wpdb->posts` ADD `mflikes_uid` longtext NOT NULL DEFAULT  ''");
}
register_activation_hook(__FILE__, 'mflikes_activate');


// Runs when the plugin is deactivated
function mflikes_deactivate() {
 global $wpdb, $mf_tablename;
 $wpdb->query("DROP TABLE IF EXISTS $mf_tablename");
 $wpdb->query("ALTER TABLE `$wpdb->posts` DROP `mflikes_uid`;");
}
register_deactivation_hook(__FILE__, 'mflikes_deactivate');

// mflikes front-end init
function mflikes_init(){

	// adds necessary javascripts to wp_head
	wp_enqueue_script('jquery');
	wp_enqueue_script('mflikes', ML_JSURI . '/mflikes.js', false, '1.0', false);
}
add_action('init', 'mflikes_init');

// mflikes function
function mflikes($args, $echo = true){
	global $user_ID;
	
	get_currentuserinfo();
	
	if($user_ID == ''){
		$user_ID = $user_ID = 0;	
	} else {
		$user_ID = $user_ID;	
	}
	
	$mflikes = new mflikes(get_the_ID(), $user_ID);
	
	$content = '';
	// if($post_meta != 'disabled'){
		// check first parameter
		switch ($args){
			case 'count':
				$content .= $mflikes->likes_count;
			break;
			case 'button':
				$content .= $mflikes->like_button();
			break;	
            case 'button1':
				$content .= $mflikes->like_button1();
			break;				
			case 'button2':
				$content .= $mflikes->like_button2();
			break;			
			case 'button3':
				$content .= $mflikes->like_button3();
			break;
			case 'button4':
				$content .= $mflikes->like_button4();
			break;
		}
	// }
	
	
	// echo or return
	if($echo){
		echo apply_filters('mflikes', $content);	
	} else {
		return apply_filters('mflikes', $content);	
	}
}
?>