/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.haribotewheels;

import java.util.List;
import mods.flammpfeil.haribotewheels.HariboteWheels;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.INpc;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class EntityWheels
extends EntityLiving
implements INpc {
    AxisAlignedBB originalBoundingBox;
    static final int dataWatcherDirOpposites = 12;
    static final int dataWatcherSizeFactor = 13;
    static final int dataWatcherMode = 14;
    static final int dataWatcherSpeed = 15;
    public int updateTicks = 0;
    public float currentSpeed = 0.0f;
    public float prevRot = 0.0f;
    public float rot = 0.0f;
    float parentYaw = 0.0f;
    float parentPitch = 0.0f;

    public EntityWheels(World par1World) {
        super(par1World);
        this.field_70129_M = 0.0f;
        this.func_70105_a(1.0f, 1.0f);
        this.field_70129_M = 0.0f;
    }

    public boolean shouldRenderInPass(int pass) {
        if (pass == 0) {
            float size = this.getSizeFactor();
            this.originalBoundingBox = this.field_70121_D.func_72329_c();
            ForgeDirection dir = this.getDir();
            float pitchFactor = 90.0f;
            float yawFactor = 0.0f;
            float rotFactor = 1.0f;
            switch (dir) {
                case EAST: {
                    yawFactor = -90.0f;
                    break;
                }
                case WEST: {
                    yawFactor = 90.0f;
                    break;
                }
                case NORTH: {
                    yawFactor = 180.0f;
                    break;
                }
                case SOUTH: {
                    yawFactor = 0.0f;
                    break;
                }
                case UP: {
                    pitchFactor = 0.0f;
                    rotFactor = 1.0f;
                    break;
                }
                case DOWN: {
                    pitchFactor = 0.0f;
                    rotFactor = -1.0f;
                    break;
                }
            }
            Vec3 dirVec = this.getOffsetVec(dir);
            dirVec.field_72450_a = 1.0 - Math.abs(dirVec.field_72450_a);
            dirVec.field_72448_b = 1.0 - Math.abs(dirVec.field_72448_b);
            dirVec.field_72449_c = 1.0 - Math.abs(dirVec.field_72449_c);
            dirVec.func_72440_a(this.toRadian(pitchFactor + this.field_70125_A));
            dirVec.func_72442_b(this.toRadian(this.field_70177_z + yawFactor));
            float sizeFactor = this.getSizeFactor();
            dirVec.field_72450_a = Math.abs(dirVec.field_72450_a) * (double)sizeFactor;
            dirVec.field_72448_b = Math.abs(dirVec.field_72448_b) * (double)sizeFactor;
            dirVec.field_72449_c = Math.abs(dirVec.field_72449_c) * (double)sizeFactor;
            AxisAlignedBB boundingBox = this.originalBoundingBox.func_72314_b(dirVec.field_72450_a, dirVec.field_72448_b, dirVec.field_72449_c);
            this.field_70121_D.field_72336_d = boundingBox.field_72336_d;
            this.field_70121_D.field_72337_e = boundingBox.field_72337_e;
            this.field_70121_D.field_72334_f = boundingBox.field_72334_f;
            this.field_70121_D.field_72340_a = boundingBox.field_72340_a;
            this.field_70121_D.field_72338_b = boundingBox.field_72338_b;
            this.field_70121_D.field_72339_c = boundingBox.field_72339_c;
        } else if (pass == 1) {
            AxisAlignedBB boundingBox = this.originalBoundingBox;
            if (this.originalBoundingBox != null) {
                this.field_70121_D.field_72336_d = boundingBox.field_72336_d;
                this.field_70121_D.field_72337_e = boundingBox.field_72337_e;
                this.field_70121_D.field_72334_f = boundingBox.field_72334_f;
                this.field_70121_D.field_72340_a = boundingBox.field_72340_a;
                this.field_70121_D.field_72338_b = boundingBox.field_72338_b;
                this.field_70121_D.field_72339_c = boundingBox.field_72339_c;
            }
        }
        return super.shouldRenderInPass(pass);
    }

    public boolean func_70112_a(double par1) {
        return super.func_70112_a(par1);
    }

    public boolean func_70102_a(Vec3 par1Vec3) {
        return super.func_70102_a(par1Vec3);
    }

    protected void func_70619_bc() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70115_ae() {
        return false;
    }

    public boolean func_85032_ar() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity par1Entity) {
    }

    protected void func_70626_be() {
    }

    protected void func_85033_bc() {
        List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D);
        if (list != null && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (!entity.func_70104_M()) continue;
                this.func_82167_n(entity);
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public boolean func_82144_au() {
        return true;
    }

    public Vec3 getOffsetVec(ForgeDirection dir) {
        return Vec3.func_72443_a((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
    }

    public Vec3 getAccelerator(Vec3 vec, Vec3 sizeDir, float sizeFactor) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70170_p.func_72918_a(this.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001).func_72314_b(Math.abs(sizeDir.field_72450_a) * (double)sizeFactor, Math.abs(sizeDir.field_72448_b) * (double)sizeFactor, Math.abs(sizeDir.field_72449_c) * (double)sizeFactor).func_72317_d(vec.field_72450_a * (double)sizeFactor, vec.field_72448_b * (double)sizeFactor, vec.field_72449_c * (double)sizeFactor), Material.field_76244_g, (Entity)this);
        double factor = 71.42857142857143;
        return Vec3.func_72443_a((double)(this.field_70159_w * 71.42857142857143), (double)(this.field_70181_x * 71.42857142857143), (double)(this.field_70179_y * 71.42857142857143));
    }

    public float toRadian(float deg) {
        return (float)((double)deg / 180.0 * Math.PI);
    }

    public boolean func_70072_I() {
        if (this.field_70170_p.field_72995_K && this.getMode() == Modes.WaterWheel) {
            ForgeDirection dir = this.getDir();
            float pitchFactor = 90.0f;
            float yawFactor = 0.0f;
            float rotFactor = 1.0f;
            switch (dir) {
                case EAST: {
                    yawFactor = 90.0f;
                    break;
                }
                case WEST: {
                    yawFactor = -90.0f;
                    break;
                }
                case NORTH: {
                    yawFactor = 180.0f;
                    break;
                }
                case SOUTH: {
                    yawFactor = 0.0f;
                    break;
                }
                case UP: {
                    pitchFactor = 0.0f;
                    rotFactor = -1.0f;
                    break;
                }
                case DOWN: {
                    pitchFactor = 0.0f;
                    rotFactor = 1.0f;
                    break;
                }
            }
            Vec3 east = this.getOffsetVec(ForgeDirection.EAST);
            Vec3 west = this.getOffsetVec(ForgeDirection.WEST);
            Vec3 north = this.getOffsetVec(ForgeDirection.NORTH);
            Vec3 south = this.getOffsetVec(ForgeDirection.SOUTH);
            east.func_72440_a(this.toRadian(pitchFactor + this.field_70125_A));
            west.func_72440_a(this.toRadian(pitchFactor + this.field_70125_A));
            north.func_72440_a(this.toRadian(pitchFactor + this.field_70125_A));
            south.func_72440_a(this.toRadian(pitchFactor + this.field_70125_A));
            east.func_72442_b(this.toRadian(this.field_70177_z + yawFactor));
            west.func_72442_b(this.toRadian(this.field_70177_z + yawFactor));
            north.func_72442_b(this.toRadian(this.field_70177_z + yawFactor));
            south.func_72442_b(this.toRadian(this.field_70177_z + yawFactor));
            float size = this.getSizeFactor();
            Vec3 eastAc = this.getAccelerator(east, north, size);
            Vec3 westAc = this.getAccelerator(west, south, size);
            Vec3 northAc = this.getAccelerator(north, west, size);
            Vec3 southAc = this.getAccelerator(south, east, size);
            double tmpSpeed = 0.0;
            tmpSpeed += northAc.func_72430_b(east);
            tmpSpeed += eastAc.func_72430_b(south);
            tmpSpeed += westAc.func_72430_b(north);
            tmpSpeed += southAc.func_72430_b(west);
            this.setSpeed((float)(tmpSpeed *= (double)(rotFactor * 2.0f)));
        }
        return false;
    }

    public boolean func_70058_J() {
        return false;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(12, (Object)0);
        this.field_70180_af.func_75682_a(13, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_75682_a(14, (Object)0);
        this.field_70180_af.func_75682_a(15, (Object)Float.valueOf(0.0f));
    }

    public void setSpeed(float size) {
        this.field_70180_af.func_75692_b(15, (Object)Float.valueOf(size));
    }

    public float getSpeed() {
        return this.field_70180_af.func_111145_d(15);
    }

    public void setMode(Modes mode) {
        this.field_70180_af.func_75692_b(14, (Object)((byte)mode.ordinal()));
    }

    public Modes getMode() {
        return Modes.values()[this.field_70180_af.func_75683_a(14)];
    }

    public void setSizeFactor(float size) {
        this.field_70180_af.func_75692_b(13, (Object)Float.valueOf(Math.abs(size)));
    }

    public float getSizeFactor() {
        return this.field_70180_af.func_111145_d(13);
    }

    public void setDir(ForgeDirection dir) {
        this.field_70180_af.func_75692_b(12, (Object)((byte)dir.ordinal()));
    }

    public ForgeDirection getDir() {
        byte opposites = this.field_70180_af.func_75683_a(12);
        return ForgeDirection.getOrientation((int)opposites);
    }

    public boolean func_70097_a(DamageSource par1DamageSource, float par2) {
        Entity tag = par1DamageSource.func_76364_f();
        if (tag != null && tag instanceof EntityPlayer && ((EntityPlayer)tag).func_70694_bm() == null) {
            this.func_70106_y();
            this.func_70656_aK();
            if (!this.field_70170_p.field_72995_K) {
                ItemStack fragment = new ItemStack(HariboteWheels.itemWheels, 1, this.getMode().ordinal());
                String name = this.func_94056_bM() ? this.func_94057_bL() : "Default";
                fragment.func_82834_c(name);
                this.func_70099_a(fragment, 0.0f);
            }
            return true;
        }
        return super.func_70097_a(par1DamageSource, par2);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            if (this.getMode() == Modes.WindWheel) {
                if (this.field_70170_p.func_72896_J()) {
                    if (this.field_70170_p.func_72911_I()) {
                        this.setSpeed(HariboteWheels.stomeSpeed);
                    } else {
                        this.setSpeed(HariboteWheels.rainSpeed);
                    }
                } else {
                    this.setSpeed(HariboteWheels.fineSpeed);
                }
            }
            if (this.getMode() == Modes.Clock) {
                this.setSpeed(0.0f);
                this.rot = 0.0f;
            }
            if (--this.updateTicks <= 0) {
                this.currentSpeed = this.getSpeed();
                this.updateTicks = 0;
            } else {
                this.currentSpeed += (this.getSpeed() - this.currentSpeed) / (float)this.updateTicks;
            }
            this.rot += this.currentSpeed;
            this.rot %= 360.0f;
            if (this.rot < 0.0f) {
                this.rot += 360.0f;
            }
        }
        this.field_70716_bi = 0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        super.func_70636_d();
        Entity parent = this.field_70154_o;
        if (parent != null) {
            this.parentYaw = parent.field_70177_z;
            this.parentPitch = parent.field_70125_A;
        } else {
            this.field_70177_z += this.parentYaw;
            this.parentYaw = 0.0f;
            this.field_70125_A += this.parentPitch;
            this.parentPitch = 0.0f;
        }
    }

    protected float func_110146_f(float par1, float par2) {
        float result = super.func_110146_f(par1, par2);
        this.field_70760_ar = 0.0f;
        this.field_70761_aq = 0.0f;
        this.field_70758_at = 0.0f;
        this.field_70759_as = 0.0f;
        return result;
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.setSizeFactor(par1NBTTagCompound.func_74760_g("sizeFactor"));
        int dir = par1NBTTagCompound.func_74762_e("dir");
        this.setDir(ForgeDirection.getOrientation((int)dir));
        int mode = par1NBTTagCompound.func_74762_e("modeIdx");
        if (mode < 0 || Modes.values().length <= mode) {
            mode = 0;
        }
        this.setMode(Modes.values()[mode]);
        float speed = par1NBTTagCompound.func_74760_g("speedData");
        this.setSpeed(speed);
        super.func_70037_a(par1NBTTagCompound);
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        if (this.field_70154_o != null) {
            this.field_70177_z += this.parentYaw;
            this.field_70125_A += this.parentPitch;
        }
        par1NBTTagCompound.func_74768_a("dir", this.getDir().ordinal());
        par1NBTTagCompound.func_74776_a("sizeFactor", this.getSizeFactor());
        par1NBTTagCompound.func_74768_a("modeIdx", this.getMode().ordinal());
        par1NBTTagCompound.func_74776_a("speedData", this.getSpeed());
        super.func_70014_b(par1NBTTagCompound);
    }

    protected boolean func_70085_c(EntityPlayer par1EntityPlayer) {
        if (par1EntityPlayer.func_70694_bm() == null) {
            if (!par1EntityPlayer.field_70170_p.field_72995_K) {
                ForgeDirection dir = this.getDir();
                int idx = ForgeDirection.VALID_DIRECTIONS.length <= dir.ordinal() + 1 ? 0 : dir.ordinal() + 1;
                dir = ForgeDirection.getOrientation((int)idx);
                this.setDir(dir);
            }
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Item.field_77669_D.field_77779_bT) {
            float step = par1EntityPlayer.func_70093_af() ? -1.0f : 1.0f;
            this.field_70177_z = (float)((Math.floor((double)this.field_70177_z / 10.0) + (double)step) * 10.0);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Block.field_71978_w.field_71990_ca) {
            float step = par1EntityPlayer.func_70093_af() ? -1.0f : 1.0f;
            this.field_70125_A = (float)((Math.floor((double)this.field_70125_A / 10.0) + (double)step) * 10.0);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Block.field_71979_v.field_71990_ca) {
            float size = this.getSizeFactor();
            float step = par1EntityPlayer.func_70093_af() ? -0.5f : 0.5f;
            if (5.0 < (double)(size += step)) {
                size = 0.5f;
            } else if ((double)size < 0.5) {
                size = 4.5f;
            }
            this.setSizeFactor(size);
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Item.field_77678_N.field_77779_bT) {
            int modeIdx = this.getMode().ordinal();
            modeIdx = Modes.values().length <= modeIdx + 1 ? 0 : modeIdx + 1;
            this.setMode(Modes.values()[modeIdx]);
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Item.field_77792_au.field_77779_bT) {
            float step = 1.0f;
            if (par1EntityPlayer.func_70093_af()) {
                step = -1.0f;
            }
            float tmpSpeed = this.getSpeed();
            if (Math.abs(tmpSpeed = (float)((double)Math.round((double)tmpSpeed * 10.0 + (double)step) * 0.1)) > 50.0f) {
                tmpSpeed = 0.0f;
            }
            this.setSpeed(tmpSpeed);
        } else if (par1EntityPlayer.func_70694_bm().func_77973_b().field_77779_bT == Item.field_77790_av.field_77779_bT) {
            float step = 10.0f;
            if (par1EntityPlayer.func_70093_af()) {
                step = -10.0f;
            }
            float tmpSpeed = this.getSpeed();
            if (Math.abs(tmpSpeed = (float)((double)Math.round((double)tmpSpeed * 10.0 + (double)step) * 0.1)) > 50.0f) {
                tmpSpeed = 0.0f;
            }
            this.setSpeed(tmpSpeed);
        }
        return super.func_70085_c(par1EntityPlayer);
    }

    public static enum Modes {
        WindWheel,
        WaterWheel,
        Clock,
        Custom;

    }
}

