/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lycanite.lycanitesmobs.LycanitesMobs;
import net.minecraftforge.common.Configuration;

public class Config {
    public Configuration config;
    public Map<String, Boolean> featuresEnabled = new HashMap<String, Boolean>();
    public Map<String, Boolean> mobsEnabled = new HashMap<String, Boolean>();
    public Map<String, Integer> spawnWeights = new HashMap<String, Integer>();
    public Map<String, Integer> spawnMins = new HashMap<String, Integer>();
    public Map<String, Integer> spawnMaxs = new HashMap<String, Integer>();
    public Map<String, Integer> blockIDs = new HashMap<String, Integer>();
    public Map<String, Integer> itemIDs = new HashMap<String, Integer>();

    public void init(String submodID) {
        String configDirPath = LycanitesMobs.proxy.getMinecraftDir() + "/config/" + "LycanitesMobs";
        File configDir = new File(configDirPath);
        configDir.mkdir();
        File configFile = new File(configDirPath + "/" + submodID + ".cfg");
        try {
            configFile.createNewFile();
            System.out.println("[INFO] [LycanitesMobs-" + submodID + "] Successfully created/read configuration file.");
        }
        catch (IOException e) {
            System.out.println("[SEVERE] [LycanitesMobs-" + submodID + "] Could not create configuration file:");
            System.out.println(e);
            System.out.println("Make sure the config folder isn't read only and (if using Windows) that Minecraft is not in Program Files on a non-administrator account.");
        }
        this.config = new Configuration(configFile);
        this.config.load();
        this.loadSettings();
        this.config.save();
    }

    public void loadSettings() {
    }

    public void loadSetting(Map<String, Boolean> settingMap, String settingCategory, String settingID, String settingName, boolean settingDefault) {
        this.config.get(settingID, settingName, settingDefault).getBoolean(settingDefault);
        settingMap.put(settingID, settingDefault);
    }

    public void loadSetting(Map<String, Integer> settingMap, String settingCategory, String settingID, String settingName, int settingDefault) {
        this.config.get(settingCategory, settingName, settingDefault).getInt(settingDefault);
        settingMap.put(settingID, settingDefault);
    }

    public void loadMobSettings(String mobName, String mobPlural, int spawnWeight, int spawnMin, int spawnMax) {
        this.loadSetting(this.mobsEnabled, "Mob Control", mobName, "Enable " + mobPlural, true);
        this.loadSetting(this.spawnWeights, "Mob Control", mobName, mobName + "Spawn Weight", spawnWeight);
        this.loadSetting(this.spawnMins, "Mob Control", mobName, mobName + "Group Spawn Min", spawnMin);
        this.loadSetting(this.spawnMaxs, "Mob Control", mobName, mobName + "Group Spawn Max", spawnMax);
    }
}

