/*
 * Decompiled with CFR 0.152.
 */
package lycanite.lycanitesmobs.model;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.WavefrontObject;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelCustomObj
extends bbl {
    public static float modelRotationOffset = 180.0f;
    public static float modelYOffset = -1.5f;
    public WavefrontObject model;
    public ArrayList<GroupObject> parts;
    public Map<String, float[]> partCenters = new HashMap<String, float[]>();
    public boolean lockHeadX = false;
    public boolean lockHeadY = false;

    public ModelCustomObj() {
        this(1.0f);
    }

    public ModelCustomObj(float shadowSize) {
    }

    public void a(nm entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.a(entity, time, distance, loop, lookY, lookX, scale);
        for (GroupObject part : this.parts) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)modelRotationOffset, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)modelYOffset, (float)0.0f);
            this.centerPart(part.name.toLowerCase());
            this.animatePart(part.name.toLowerCase(), (of)entity, time, distance, loop, lookY, lookX, scale);
            this.uncenterPart(part.name.toLowerCase());
            part.render();
            GL11.glPopMatrix();
        }
    }

    public void animatePart(String partName, of entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float pi2 = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.equals("head")) {
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
        }
        this.rotate(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }

    public void rotate(float rotX, float rotY, float rotZ) {
        GL11.glRotatef((float)rotX, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotY, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)rotZ, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public void rotate(float rotation, float angleX, float angleY, float angleZ) {
        GL11.glRotatef((float)rotation, (float)angleX, (float)angleY, (float)angleZ);
    }

    public void translate(float posX, float posY, float posZ) {
        GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
    }

    public void setPartCenter(String partName, float centerX, float centerY, float centerZ) {
        this.partCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void centerPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(partCenter[0], partCenter[1], partCenter[2]);
    }

    public void uncenterPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.translate(-partCenter[0], -partCenter[1], -partCenter[2]);
    }
}

