/*
 * Decompiled with CFR 0.152.
 */
package jp.mc.ancientred.starminer.block;

import jp.mc.ancientred.starminer.SMModContainer;
import jp.mc.ancientred.starminer.block.gravitized.IGravitizedPlants;

public class DirectionConst {
    public static final int SHIFT = 1;
    public static final int PLACEDIR_YBOT = 0;
    public static final int PLACEDIR_YTOP = 1;
    public static final int PLACEDIR_XBOT = 2;
    public static final int PLACEDIR_XTOP = 3;
    public static final int PLACEDIR_ZBOT = 4;
    public static final int PLACEDIR_ZTOP = 5;
    public static final int[][] CHECKNEIGHBOR_LIST = new int[][]{{0, 1, 0, 0}, {0, -1, 0, 1}, {1, 0, 0, 2}, {-1, 0, 0, 3}, {0, 0, 1, 4}, {0, 0, -1, 5}};
    public static final int[] OPPOSITE_CNV = new int[]{1, 0, 3, 2, 5, 4};

    public static final int getPlantGravityDirection(ace par1World, int parX, int parY, int parZ) {
        for (int[] neighbor : CHECKNEIGHBOR_LIST) {
            int blockId = par1World.a(parX + neighbor[0], parY + neighbor[1], parZ + neighbor[2]);
            if (blockId != 0 || par1World.h(parX + neighbor[0], parY + neighbor[1], parZ + neighbor[2]) - 1 != neighbor[3]) continue;
            return neighbor[3];
        }
        return -1;
    }

    public static final int[] getBlockBedHeadNeighborBody(ace par1World, int parX, int parY, int parZ) {
        for (int[] neighbor : CHECKNEIGHBOR_LIST) {
            int blockId = par1World.a(parX + neighbor[0], parY + neighbor[1], parZ + neighbor[2]);
            if (blockId != SMModContainer.StarBedBodyBlockID || par1World.h(parX + neighbor[0], parY + neighbor[1], parZ + neighbor[2]) != OPPOSITE_CNV[neighbor[3]]) continue;
            return neighbor;
        }
        return null;
    }

    public static boolean isStayableAtOppositeSide(abv par1World, int par2, int par3, int par4, int dir, int meta, IGravitizedPlants plant) {
        if (dir < 0 || OPPOSITE_CNV.length <= dir) {
            return false;
        }
        int[] neighborToCheck = CHECKNEIGHBOR_LIST[OPPOSITE_CNV[dir]];
        int oppositeSblockId = par1World.a(par2 + neighborToCheck[0], par3 + neighborToCheck[1], par4 + neighborToCheck[2]);
        return plant.allowPlantOn(oppositeSblockId, meta);
    }

    public static final boolean tryStayable(abv par1World, int par2, int par3, int par4, int meta, IGravitizedPlants plant) {
        int len = CHECKNEIGHBOR_LIST.length;
        for (int dir = 0; dir < len; ++dir) {
            int[] neighborToCheck = CHECKNEIGHBOR_LIST[OPPOSITE_CNV[dir]];
            int oppositeSblockId = par1World.a(par2 + neighborToCheck[0], par3 + neighborToCheck[1], par4 + neighborToCheck[2]);
            if (!plant.allowPlantOn(oppositeSblockId, meta) || par1World.a(par2 + (neighborToCheck = CHECKNEIGHBOR_LIST[dir])[0], par3 + neighborToCheck[1], par4 + neighborToCheck[2]) != 0 || par1World.h(par2 + neighborToCheck[0], par3 + neighborToCheck[1], par4 + neighborToCheck[2]) != 0) continue;
            par1World.b(par2 + neighborToCheck[0], par3 + neighborToCheck[1], par4 + neighborToCheck[2], dir + 1, 2);
            return true;
        }
        return false;
    }
}

