/*
 * Decompiled with CFR 0.152.
 */
package jp.mc.ancientred.starminer.extendedproperty;

import jp.mc.ancientred.starminer.SMModContainer;
import jp.mc.ancientred.starminer.dimention.WorldProviderSpace;
import jp.mc.ancientred.starminer.extendedproperty.GravityConst;
import jp.mc.ancientred.starminer.packet.SMPacketHandler;
import jp.mc.ancientred.starminer.tileentity.TileEntityGravityGenerator;
import jp.mc.ancientred.starminer.transforms.TransformUtils;
import net.minecraftforge.common.IExtendedEntityProperties;

public class ExtendedPropertyGravity
implements IExtendedEntityProperties {
    public static final String EXTENDED_PROP_GRAVITY_KEY = "jp.mc.ancientred.starminer.Gravity";
    public static final String NBT_TAG_KEY = "stmn.gravity";
    public GravityDirection gravityDirection = GravityDirection.upTOdown;
    public GravityDirection gravityDirectionNext = GravityDirection.upTOdown;
    public float turnRate = 100.0f;
    public float prevTurnRate = 100.0f;
    public float turnSpeed = 0.0f;
    public float onChangeRoatDirX = 0.0f;
    public float onChangeRoatDirY = 0.0f;
    public float onChangeRoatDirZ = 0.0f;
    public float onChangeTurnYaw = 0.0f;
    public boolean isAttracted = false;
    public int attractedPosX = 0;
    public int attractedPosY = 0;
    public int attractedPosZ = 0;
    public double attractedRange = 0.0;
    public int attractUpdateTickCount = 0;
    public int unsynchronizedTickCount = 0;
    public int unsynchronizedWarnCount = 0;
    public static final int GWALL_AFFECT_TICK = 30;
    public int keepGwallGravityDirTick;
    public int normalGravityEffectRedistTick;
    public int acceptExceptionalGravityTick = 0;
    public int temporatyZeroGTick;

    public void saveNBTData(bx compound) {
        bx myNBT = new bx();
        myNBT.a("turnRate", this.turnRate);
        myNBT.a("turnSpeed", this.turnSpeed);
        myNBT.a("onChangeRoatDirX", this.onChangeRoatDirX);
        myNBT.a("onChangeRoatDirY", this.onChangeRoatDirY);
        myNBT.a("onChangeRoatDirZ", this.onChangeRoatDirZ);
        myNBT.a("onChangeTurnYaw", this.onChangeTurnYaw);
        myNBT.a("isAttracted", this.isAttracted);
        myNBT.a("attractedPosX", this.attractedPosX);
        myNBT.a("attractedPosY", this.attractedPosY);
        myNBT.a("attractedPosZ", this.attractedPosZ);
        myNBT.a("attractedRange", this.attractedRange);
        compound.a(NBT_TAG_KEY, myNBT);
    }

    public void loadNBTData(bx compound) {
        if (compound.b(NBT_TAG_KEY)) {
            bx myNBT = compound.l(NBT_TAG_KEY);
            this.turnRate = myNBT.g("turnRate");
            this.turnSpeed = myNBT.g("turnSpeed");
            this.onChangeRoatDirX = myNBT.g("onChangeRoatDirX");
            this.onChangeRoatDirY = myNBT.g("onChangeRoatDirY");
            this.onChangeRoatDirZ = myNBT.g("onChangeRoatDirZ");
            this.onChangeTurnYaw = myNBT.g("onChangeTurnYaw");
            this.isAttracted = myNBT.n("isAttracted");
            this.attractedPosX = myNBT.e("attractedPosX");
            this.attractedPosY = myNBT.e("attractedPosY");
            this.attractedPosZ = myNBT.e("attractedPosZ");
            this.attractedRange = myNBT.h("attractedRange");
        }
    }

    public void init(nm entity, abv world) {
    }

    public void updateGravityDirectionState(nm entity) {
        GravityDirection gravityDirNew = this.gravityDirection;
        if (this.normalGravityEffectRedistTick != 0) {
            return;
        }
        if (this.turnRate < 1.0f) {
            return;
        }
        if (!this.isAttracted) {
            gravityDirNew = GravityDirection.upTOdown;
        } else {
            asm te = entity.q.r(this.attractedPosX, this.attractedPosY, this.attractedPosZ);
            if (te == null || !(te instanceof TileEntityGravityGenerator)) {
                return;
            }
            TileEntityGravityGenerator teGravity = (TileEntityGravityGenerator)te;
            double centerX = (double)this.attractedPosX + 0.5;
            double centerY = (double)this.attractedPosY + 0.5;
            double centerZ = (double)this.attractedPosZ + 0.5;
            double xRel = centerX - entity.u;
            double zRel = centerZ - entity.w;
            double yRel = centerY - (entity.v - (double)(entity.N - entity.O / 2.0f));
            boolean reverse = this.isGravityReverse(entity, false);
            switch (teGravity.type) {
                case 2: {
                    if (Math.abs(zRel) > Math.abs(yRel)) {
                        if (zRel > 0.0) {
                            gravityDirNew = reverse ? GravityDirection.northTOsouth : GravityDirection.southTOnorth;
                            break;
                        }
                        gravityDirNew = reverse ? GravityDirection.southTOnorth : GravityDirection.northTOsouth;
                        break;
                    }
                    if (yRel > 0.0) {
                        gravityDirNew = reverse ? GravityDirection.downTOup : GravityDirection.upTOdown;
                        break;
                    }
                    gravityDirNew = reverse ? GravityDirection.upTOdown : GravityDirection.downTOup;
                    break;
                }
                case 3: {
                    if (Math.abs(xRel) > Math.abs(zRel)) {
                        if (xRel > 0.0) {
                            gravityDirNew = reverse ? GravityDirection.westTOeast : GravityDirection.eastTOwest;
                            break;
                        }
                        gravityDirNew = reverse ? GravityDirection.eastTOwest : GravityDirection.westTOeast;
                        break;
                    }
                    if (zRel > 0.0) {
                        gravityDirNew = reverse ? GravityDirection.northTOsouth : GravityDirection.southTOnorth;
                        break;
                    }
                    gravityDirNew = reverse ? GravityDirection.southTOnorth : GravityDirection.northTOsouth;
                    break;
                }
                case 4: {
                    if (Math.abs(xRel) > Math.abs(yRel)) {
                        if (xRel > 0.0) {
                            gravityDirNew = reverse ? GravityDirection.westTOeast : GravityDirection.eastTOwest;
                            break;
                        }
                        gravityDirNew = reverse ? GravityDirection.eastTOwest : GravityDirection.westTOeast;
                        break;
                    }
                    if (yRel > 0.0) {
                        gravityDirNew = reverse ? GravityDirection.downTOup : GravityDirection.upTOdown;
                        break;
                    }
                    gravityDirNew = reverse ? GravityDirection.upTOdown : GravityDirection.downTOup;
                    break;
                }
                default: {
                    if (Math.abs(xRel) > Math.abs(zRel) && Math.abs(xRel) > Math.abs(yRel)) {
                        if (xRel > 0.0) {
                            gravityDirNew = !reverse ? GravityDirection.westTOeast : GravityDirection.eastTOwest;
                            break;
                        }
                        gravityDirNew = !reverse ? GravityDirection.eastTOwest : GravityDirection.westTOeast;
                        break;
                    }
                    if (Math.abs(zRel) >= Math.abs(xRel) && Math.abs(zRel) > Math.abs(yRel)) {
                        if (zRel > 0.0) {
                            gravityDirNew = !reverse ? GravityDirection.northTOsouth : GravityDirection.southTOnorth;
                            break;
                        }
                        gravityDirNew = !reverse ? GravityDirection.southTOnorth : GravityDirection.northTOsouth;
                        break;
                    }
                    if (yRel > 0.0) {
                        gravityDirNew = !reverse ? GravityDirection.downTOup : GravityDirection.upTOdown;
                        break;
                    }
                    GravityDirection gravityDirection = gravityDirNew = !reverse ? GravityDirection.upTOdown : GravityDirection.downTOup;
                }
            }
        }
        if (this.gravityDirection != gravityDirNew) {
            this.changeGravityDirection(gravityDirNew);
            this.keepGwallGravityDirTick = 10;
        }
    }

    public boolean isGravityReverse(nm entity, boolean setReverseOff) {
        if (entity instanceof ue) {
            ue player = (ue)entity;
            for (int i = 0; i < 9; ++i) {
                yd itemStack = player.bn.a[i];
                if (itemStack == null || itemStack.d != SMModContainer.GravityControllerItemID + 256) continue;
                if (itemStack.p()) {
                    bx tag = itemStack.q();
                    boolean gcon = tag.n("stmn.g_reverse");
                    if (gcon && setReverseOff) {
                        tag.a("stmn.g_reverse", false);
                    }
                    return gcon;
                }
                return false;
            }
        }
        return false;
    }

    public void setTemporaryGravityDirection(GravityDirection nextGravityDirection, int tick) {
        GravityDirection old = this.gravityDirection;
        if (this.keepGwallGravityDirTick <= 0 && this.turnRate >= 1.0f) {
            this.changeGravityDirection(nextGravityDirection);
        }
        this.normalGravityEffectRedistTick = tick;
        if (old != this.gravityDirectionNext) {
            this.keepGwallGravityDirTick = 30;
        }
    }

    public void changeGravityDirection(GravityDirection newGravityDirection) {
        if (this.gravityDirection == newGravityDirection) {
            return;
        }
        this.turnRate = 0.0f;
        this.prevTurnRate = 0.0f;
        this.turnSpeed = 0.05f;
        this.onChangeRoatDirX = 0.0f;
        this.onChangeRoatDirY = 0.0f;
        this.onChangeRoatDirZ = 0.0f;
        this.onChangeTurnYaw = 0.0f;
        block0 : switch (this.gravityDirection) {
            case northTOsouth: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        break;
                    }
                    case southTOnorth: {
                        this.onChangeRoatDirX = -2.0f;
                        break;
                    }
                    case westTOeast: {
                        this.onChangeRoatDirY = -1.0f;
                        this.onChangeTurnYaw = -90.0f;
                        break;
                    }
                    case eastTOwest: {
                        this.onChangeRoatDirY = 1.0f;
                        this.onChangeTurnYaw = 90.0f;
                        break;
                    }
                    case downTOup: {
                        this.onChangeRoatDirX = 1.0f;
                        break;
                    }
                    case upTOdown: {
                        this.onChangeRoatDirX = -1.0f;
                    }
                }
                break;
            }
            case southTOnorth: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        this.onChangeRoatDirX = -2.0f;
                        break;
                    }
                    case southTOnorth: {
                        break;
                    }
                    case westTOeast: {
                        this.onChangeRoatDirY = 1.0f;
                        this.onChangeTurnYaw = 90.0f;
                        break;
                    }
                    case eastTOwest: {
                        this.onChangeRoatDirY = -1.0f;
                        this.onChangeTurnYaw = -90.0f;
                        break;
                    }
                    case downTOup: {
                        this.onChangeRoatDirX = -1.0f;
                        break;
                    }
                    case upTOdown: {
                        this.onChangeRoatDirX = 1.0f;
                    }
                }
                break;
            }
            case westTOeast: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        this.onChangeRoatDirY = 1.0f;
                        this.onChangeTurnYaw = 90.0f;
                        break;
                    }
                    case southTOnorth: {
                        this.onChangeRoatDirY = -1.0f;
                        this.onChangeTurnYaw = -90.0f;
                        break;
                    }
                    case westTOeast: {
                        break;
                    }
                    case eastTOwest: {
                        this.onChangeRoatDirZ = -2.0f;
                        break;
                    }
                    case downTOup: {
                        this.onChangeRoatDirZ = -1.0f;
                        this.onChangeTurnYaw = -180.0f;
                        break;
                    }
                    case upTOdown: {
                        this.onChangeRoatDirZ = 1.0f;
                    }
                }
                break;
            }
            case eastTOwest: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        this.onChangeRoatDirY = -1.0f;
                        this.onChangeTurnYaw = -90.0f;
                        break;
                    }
                    case southTOnorth: {
                        this.onChangeRoatDirY = 1.0f;
                        this.onChangeTurnYaw = 90.0f;
                        break;
                    }
                    case westTOeast: {
                        this.onChangeRoatDirZ = -2.0f;
                        break;
                    }
                    case eastTOwest: {
                        break;
                    }
                    case downTOup: {
                        this.onChangeRoatDirZ = 1.0f;
                        this.onChangeTurnYaw = -180.0f;
                        break;
                    }
                    case upTOdown: {
                        this.onChangeRoatDirZ = -1.0f;
                    }
                }
                break;
            }
            case downTOup: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        this.onChangeRoatDirX = -1.0f;
                        break;
                    }
                    case southTOnorth: {
                        this.onChangeRoatDirX = 1.0f;
                        break;
                    }
                    case westTOeast: {
                        this.onChangeRoatDirZ = 1.0f;
                        this.onChangeTurnYaw = 180.0f;
                        break;
                    }
                    case eastTOwest: {
                        this.onChangeRoatDirZ = -1.0f;
                        this.onChangeTurnYaw = 180.0f;
                        break;
                    }
                    case downTOup: {
                        break;
                    }
                    case upTOdown: {
                        this.onChangeRoatDirX = -2.0f;
                    }
                }
                break;
            }
            case upTOdown: {
                switch (newGravityDirection) {
                    case northTOsouth: {
                        this.onChangeRoatDirX = 1.0f;
                        break block0;
                    }
                    case southTOnorth: {
                        this.onChangeRoatDirX = -1.0f;
                        break block0;
                    }
                    case westTOeast: {
                        this.onChangeRoatDirZ = -1.0f;
                        break block0;
                    }
                    case eastTOwest: {
                        this.onChangeRoatDirZ = 1.0f;
                        break block0;
                    }
                    case downTOup: {
                        this.onChangeRoatDirX = -2.0f;
                        break block0;
                    }
                }
            }
        }
        this.gravityDirectionNext = newGravityDirection;
    }

    public boolean isZeroGravity(boolean isOuterSpace) {
        return this.temporatyZeroGTick > 0 || !this.isAttracted && isOuterSpace && this.normalGravityEffectRedistTick <= 0;
    }

    public void updateAtractedStateAndGravityZero(ue entityPlayer) {
        if (this.isAttracted && !this.inAttractedRange(entityPlayer)) {
            this.loseAttractedBy(entityPlayer);
        }
    }

    public boolean inAttractedRange(ue entityPlayer) {
        int blockId = entityPlayer.q.a(this.attractedPosX, this.attractedPosY, this.attractedPosZ);
        if (blockId == 0) {
            return false;
        }
        asm tileEntity = entityPlayer.q.r(this.attractedPosX, this.attractedPosY, this.attractedPosZ);
        if (!(tileEntity instanceof TileEntityGravityGenerator)) {
            return false;
        }
        double gravityRange = ((TileEntityGravityGenerator)tileEntity).gravityRange;
        return ExtendedPropertyGravity.inGravityRange(entityPlayer, this.gravityDirection, (double)this.attractedPosX + 0.5, (double)this.attractedPosY + 0.5, (double)this.attractedPosZ + 0.5, gravityRange, ((TileEntityGravityGenerator)tileEntity).type);
    }

    public void validateGravity(ue entityPlayer, boolean isGravityZero) {
        if (!(this.isAttracted || isGravityZero || this.gravityDirection == GravityDirection.upTOdown || entityPlayer.bg() || this.acceptExceptionalGravityTick <= 0)) {
            this.unsynchronizedTickCount += 2;
        }
        --this.unsynchronizedTickCount;
        if (this.unsynchronizedTickCount < 0) {
            this.unsynchronizedTickCount = 0;
        }
    }

    public void setAttractedBy(ue entityPlayer, int argX, int argY, int argZ) {
        this.isAttracted = true;
        this.attractedPosX = argX;
        this.attractedPosY = argY;
        this.attractedPosZ = argZ;
        SMPacketHandler.sendAttractedChangePacketToPlayer(entityPlayer, true, argX, argY, argZ);
    }

    public void loseAttractedBy(ue entityPlayer) {
        this.isAttracted = false;
        SMPacketHandler.sendAttractedChangePacketToPlayer(entityPlayer, false, 0, 0, 0);
    }

    public static boolean isEntityZeroGravity(nm entity) {
        if (entity != null) {
            ExtendedPropertyGravity gp = ExtendedPropertyGravity.getGravityProp(entity);
            return gp != null && gp.isZeroGravity(entity.q.t instanceof WorldProviderSpace);
        }
        return false;
    }

    public static boolean isAttracted(nm entity) {
        if (entity != null) {
            ExtendedPropertyGravity gp = ExtendedPropertyGravity.getGravityProp(entity);
            return gp != null && gp.isAttracted;
        }
        return false;
    }

    public static boolean isEntityAbnormalGravity(nm entity) {
        if (entity != null) {
            ExtendedPropertyGravity gp = ExtendedPropertyGravity.getGravityProp(entity);
            return gp != null && gp.gravityDirection != GravityDirection.upTOdown;
        }
        return false;
    }

    public static boolean isEntityNormalGravity(nm entity) {
        if (entity != null) {
            ExtendedPropertyGravity gp = ExtendedPropertyGravity.getGravityProp(entity);
            return gp == null || gp.gravityDirection == GravityDirection.upTOdown;
        }
        return true;
    }

    public static final GravityDirection getGravityDirection(nm entity) {
        if (entity == null) {
            return GravityDirection.upTOdown;
        }
        ExtendedPropertyGravity gp = ExtendedPropertyGravity.getGravityProp(entity);
        if (gp == null) {
            return GravityDirection.upTOdown;
        }
        return gp.gravityDirection;
    }

    public static ExtendedPropertyGravity getGravityProp(nm entity) {
        return (ExtendedPropertyGravity)entity.getExtendedProperties(EXTENDED_PROP_GRAVITY_KEY);
    }

    private static boolean checkAttractedRangeSphere(double centerX, double centerY, double centerZ, double playerX, double playerY, double playerZ, double argAttarctedRange) {
        double xRel = centerX - playerX;
        double yRel = centerY - playerY;
        double zRel = centerZ - playerZ;
        return Math.sqrt(xRel * xRel + yRel * yRel + zRel * zRel) <= argAttarctedRange;
    }

    private static boolean checkAttractedRangeSquare(double centerX, double centerY, double centerZ, double playerX, double playerY, double playerZ, double argAttarctedRange) {
        return playerX <= centerX + argAttarctedRange && playerX >= centerX - argAttarctedRange && playerY <= centerY + argAttarctedRange && playerY >= centerY - argAttarctedRange && playerZ <= centerZ + argAttarctedRange && playerZ >= centerZ - argAttarctedRange;
    }

    private static boolean checkAttractedRangeXbaseCylinder(double centerX, double centerY, double centerZ, double playerX, double playerY, double playerZ, double argAttarctedRange) {
        double yRel = centerY - playerY;
        double zRel = centerZ - playerZ;
        return playerX <= centerX + argAttarctedRange && playerX >= centerX - argAttarctedRange && Math.sqrt(yRel * yRel + zRel * zRel) <= argAttarctedRange;
    }

    private static boolean checkAttractedRangeYbaseCylinder(double centerX, double centerY, double centerZ, double playerX, double playerY, double playerZ, double argAttarctedRange) {
        double xRel = centerX - playerX;
        double zRel = centerZ - playerZ;
        return playerY <= centerY + argAttarctedRange && playerY >= centerY - argAttarctedRange && Math.sqrt(xRel * xRel + zRel * zRel) <= argAttarctedRange;
    }

    private static boolean checkAttractedRangeZbaseCylinder(double centerX, double centerY, double centerZ, double playerX, double playerY, double playerZ, double argAttarctedRange) {
        double xRel = centerX - playerX;
        double yRel = centerY - playerY;
        return playerZ <= centerZ + argAttarctedRange && playerZ >= centerZ - argAttarctedRange && Math.sqrt(xRel * xRel + yRel * yRel) <= argAttarctedRange;
    }

    public static boolean inGravityRange(ue entityPlayer, GravityDirection gDirection, double attractCenterX, double attractCenterY, double attractCenterZ, double gravityRange, int type) {
        double playerPosY;
        switch (gDirection) {
            case downTOup: {
                playerPosY = entityPlayer.v + (double)entityPlayer.P - (double)(entityPlayer.O / 2.0f);
                break;
            }
            default: {
                playerPosY = entityPlayer.v - (double)(entityPlayer.O / 2.0f);
            }
        }
        switch (type) {
            case 1: {
                return ExtendedPropertyGravity.checkAttractedRangeSquare(attractCenterX, attractCenterY, attractCenterZ, entityPlayer.u, playerPosY, entityPlayer.w, gravityRange);
            }
            case 2: {
                return ExtendedPropertyGravity.checkAttractedRangeXbaseCylinder(attractCenterX, attractCenterY, attractCenterZ, entityPlayer.u, playerPosY, entityPlayer.w, gravityRange);
            }
            case 3: {
                return ExtendedPropertyGravity.checkAttractedRangeYbaseCylinder(attractCenterX, attractCenterY, attractCenterZ, entityPlayer.u, playerPosY, entityPlayer.w, gravityRange);
            }
            case 4: {
                return ExtendedPropertyGravity.checkAttractedRangeZbaseCylinder(attractCenterX, attractCenterY, attractCenterZ, entityPlayer.u, playerPosY, entityPlayer.w, gravityRange);
            }
        }
        return ExtendedPropertyGravity.checkAttractedRangeSphere(attractCenterX, attractCenterY, attractCenterZ, entityPlayer.u, playerPosY, entityPlayer.w, gravityRange);
    }

    public void setTemporaryZeroGravity(int tick) {
        this.temporatyZeroGTick = tick;
    }

    public asz getGravityFixedLook(abv world, float pitch, float yaw) {
        switch (this.gravityDirection) {
            case southTOnorth: {
                float zVal = lr.a((float)(-pitch * ((float)Math.PI / 180)));
                float zFix = lr.b((float)(-pitch * ((float)Math.PI / 180)));
                float yVal = lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float xVal = -lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                return world.V().a((double)(xVal * zFix), (double)(yVal * zFix), (double)zVal);
            }
            case northTOsouth: {
                float zVal = -lr.a((float)(-pitch * ((float)Math.PI / 180)));
                float zFix = lr.b((float)(-pitch * ((float)Math.PI / 180)));
                float yVal = -lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float xVal = -lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                return world.V().a((double)(xVal * zFix), (double)(yVal * zFix), (double)zVal);
            }
            case westTOeast: {
                float xVal = -lr.a((float)(-pitch * ((float)Math.PI / 180)));
                float xFix = lr.b((float)(-pitch * ((float)Math.PI / 180)));
                float zVal = -lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float yVal = -lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                return world.V().a((double)xVal, (double)(yVal * xFix), (double)(zVal * xFix));
            }
            case eastTOwest: {
                float xVal = lr.a((float)(-pitch * ((float)Math.PI / 180)));
                float xFix = lr.b((float)(-pitch * ((float)Math.PI / 180)));
                float zVal = -lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float yVal = lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                return world.V().a((double)xVal, (double)(yVal * xFix), (double)(zVal * xFix));
            }
            case downTOup: {
                float yVal = -lr.a((float)(-pitch * ((float)Math.PI / 180)));
                float yFix = lr.b((float)(-pitch * ((float)Math.PI / 180)));
                float zVal = lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                float xVal = -lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
                return world.V().a((double)(xVal * yFix), (double)yVal, (double)(zVal * yFix));
            }
        }
        float yVal = lr.a((float)(-pitch * ((float)Math.PI / 180)));
        float yFix = -lr.b((float)(-pitch * ((float)Math.PI / 180)));
        float zVal = lr.b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float xVal = lr.a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        return world.V().a((double)(xVal * yFix), (double)yVal, (double)(zVal * yFix));
    }

    public asz getGravityFixedPlayerEyePoz(ue parEntityPlayer, float partialTick) {
        abv world = parEntityPlayer.q;
        double d0 = parEntityPlayer.r + (parEntityPlayer.u - parEntityPlayer.r) * (double)partialTick;
        double d1 = parEntityPlayer.s + (parEntityPlayer.v - parEntityPlayer.s) * (double)partialTick + (double)(world.I ? parEntityPlayer.f() - parEntityPlayer.getDefaultEyeHeight() : parEntityPlayer.f());
        double d2 = parEntityPlayer.t + (parEntityPlayer.w - parEntityPlayer.t) * (double)partialTick;
        asz fixedPozVec3 = world.V().a(d0, d1, d2);
        fixedPozVec3 = parEntityPlayer instanceof ju ? TransformUtils.fixEyePositionByGravityServer(parEntityPlayer, fixedPozVec3) : TransformUtils.fixEyePositionByGravityClient((nm)parEntityPlayer, fixedPozVec3);
        return fixedPozVec3;
    }

    public void setGravityFixedPlayerShootVec(ue parShooterEntity, nm projectileEntity, float partialTick) {
        asz fixedPozVec3 = this.getGravityFixedPlayerEyePoz(parShooterEntity, partialTick);
        abv world = parShooterEntity.q;
        float f1 = parShooterEntity.D + (parShooterEntity.B - parShooterEntity.D) * partialTick;
        float f2 = parShooterEntity.C + (parShooterEntity.A - parShooterEntity.C) * partialTick;
        float f3 = lr.b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = lr.a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -lr.b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = lr.a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        asz vecLook = parShooterEntity.j(partialTick);
        projectileEntity.u = fixedPozVec3.c + vecLook.c;
        projectileEntity.v = fixedPozVec3.d + vecLook.d;
        projectileEntity.w = fixedPozVec3.e + vecLook.e;
        projectileEntity.b(projectileEntity.u, projectileEntity.v, projectileEntity.w);
        projectileEntity.N = 0.0f;
        projectileEntity.x = vecLook.c;
        projectileEntity.z = vecLook.e;
        projectileEntity.y = vecLook.d;
    }

    public static enum GravityDirection {
        upTOdown(0, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, GravityConst.matirxRoatUpToDownI, GravityConst.matirxRoatUpToDownD, GravityConst.forgeSideRotUpToDown),
        downTOup(1, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, GravityConst.matirxRoatDownTOupI, GravityConst.matirxRoatDownTOupD, GravityConst.forgeSideRotDownTOup),
        eastTOwest(2, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.5f, -1.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, GravityConst.matirxRoatEastTOwestI, GravityConst.matirxRoatEastTOwestD, GravityConst.forgeSideRotEastTOwest),
        westTOeast(3, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 0.0f, -0.5f, 1.0f, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, GravityConst.matirxRoatWestTOeastI, GravityConst.matirxRoatWestTOeastD, GravityConst.forgeSideRotWestTOeast),
        northTOsouth(4, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, -1.0f, GravityConst.matirxRoatNorthTOsouthI, GravityConst.matirxRoatNorthTOsouthD, GravityConst.forgeSideRotNorthTOsouth),
        southTOnorth(5, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -0.5f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 0.0f, 1.0f, GravityConst.matirxRoatSouthTOnorthI, GravityConst.matirxRoatSouthTOnorthD, GravityConst.forgeSideRotSouthTOnorth);

        public int intValue;
        public float pitchRotDirX;
        public float pitchRotDirY;
        public float yawRotDirX;
        public float yawRotDirY;
        public float yawRotDirZ;
        public float rotX;
        public float rotZ;
        public float shiftEyeX;
        public float shiftEyeY;
        public float shiftEyeZ;
        public float shiftSneakX;
        public float shiftSneakY;
        public float shiftSneakZ;
        public int[] matrixRotationI;
        public double[] matrixRotationD;
        public int[] forgeSideRot;
        public int collideCheckExpandX;
        public int collideCheckExpandY;
        public int collideCheckExpandZ;
        public static GravityDirection[] BY_INTVAL;

        private GravityDirection(int argIntValue, float argPitchRotDirX, float argPitchRotDirY, float argYawRotDirX, float argYawRotDirY, float argYawRotDirZ, float argRotX, float argRotZ, float argShiftEyeX, float argShiftEyeY, float argShiftEyeZ, float argShiftSneakX, float argShiftSneakY, float argShiftSneakZ, int[] argMatrixRotationI, double[] argMatrixRotationD, int[] argForgeSideRot) {
            this.intValue = argIntValue;
            this.pitchRotDirX = argPitchRotDirX;
            this.pitchRotDirY = argPitchRotDirY;
            this.yawRotDirX = argYawRotDirX;
            this.yawRotDirY = argYawRotDirY;
            this.yawRotDirZ = argYawRotDirZ;
            this.rotX = argRotX;
            this.rotZ = argRotZ;
            this.shiftEyeX = argShiftEyeX;
            this.shiftEyeY = argShiftEyeY;
            this.shiftEyeZ = argShiftEyeZ;
            this.shiftSneakX = argShiftSneakX;
            this.shiftSneakY = argShiftSneakY;
            this.shiftSneakZ = argShiftSneakZ;
            this.matrixRotationI = argMatrixRotationI;
            this.matrixRotationD = argMatrixRotationD;
            this.forgeSideRot = argForgeSideRot;
            this.collideCheckExpandX = -this.matrixRotationI[3];
            this.collideCheckExpandY = -this.matrixRotationI[4];
            this.collideCheckExpandZ = -this.matrixRotationI[5];
        }

        public static GravityDirection turnWayForNormal(GravityDirection gDir) {
            switch (gDir) {
                case downTOup: {
                    return downTOup;
                }
                case eastTOwest: {
                    return westTOeast;
                }
                case westTOeast: {
                    return eastTOwest;
                }
                case northTOsouth: {
                    return southTOnorth;
                }
                case southTOnorth: {
                    return northTOsouth;
                }
            }
            return upTOdown;
        }

        public asz rotateVec3(asz vec3) {
            return GravityDirection.rotateVec3(this, vec3);
        }

        public asz rotateVec3At(asz vec3, double centerX, double centerY, double centerZ) {
            return GravityDirection.rotateVec3At(this, vec3, centerX, centerY, centerZ);
        }

        public asz rotateVec3At(asz vec3, asz centerVec3) {
            return GravityDirection.rotateVec3At(this, vec3, centerVec3);
        }

        public static final asz rotateVec3(GravityDirection dir, asz vec3) {
            double x = vec3.c;
            double y = vec3.d;
            double z = vec3.e;
            vec3.c = x * dir.matrixRotationD[0] + y * dir.matrixRotationD[3] + z * dir.matrixRotationD[6];
            vec3.d = x * dir.matrixRotationD[1] + y * dir.matrixRotationD[4] + z * dir.matrixRotationD[7];
            vec3.e = x * dir.matrixRotationD[2] + y * dir.matrixRotationD[5] + z * dir.matrixRotationD[8];
            return vec3;
        }

        public static final asz rotateVec3At(GravityDirection dir, asz vec3, asz centerVec3) {
            return GravityDirection.rotateVec3At(dir, centerVec3, centerVec3.c, centerVec3.d, centerVec3.e);
        }

        public static final asz rotateVec3At(GravityDirection dir, asz vec3, double centerX, double centerY, double centerZ) {
            double x = vec3.c - centerX;
            double y = vec3.d - centerY;
            double z = vec3.e - centerZ;
            vec3.c = x * dir.matrixRotationD[0] + y * dir.matrixRotationD[3] + z * dir.matrixRotationD[6] + centerX;
            vec3.d = x * dir.matrixRotationD[1] + y * dir.matrixRotationD[4] + z * dir.matrixRotationD[7] + centerY;
            vec3.e = x * dir.matrixRotationD[2] + y * dir.matrixRotationD[5] + z * dir.matrixRotationD[8] + centerZ;
            return vec3;
        }

        public double[] rotateXYZAt(double[] retVal, double argX, double argY, double argZ, double centerX, double centerY, double centerZ) {
            return GravityDirection.rotateXYZAt(this, retVal, argX, argY, argZ, centerX, centerY, centerZ);
        }

        public static final double[] rotateXYZAt(GravityDirection dir, double[] retVal, double argX, double argY, double argZ, double centerX, double centerY, double centerZ) {
            double x = argX - centerX;
            double y = argY - centerY;
            double z = argZ - centerZ;
            retVal[0] = x * dir.matrixRotationD[0] + y * dir.matrixRotationD[3] + z * dir.matrixRotationD[6] + centerX;
            retVal[1] = x * dir.matrixRotationD[1] + y * dir.matrixRotationD[4] + z * dir.matrixRotationD[7] + centerY;
            retVal[2] = x * dir.matrixRotationD[2] + y * dir.matrixRotationD[5] + z * dir.matrixRotationD[8] + centerZ;
            return retVal;
        }

        public float[] rotateXYZAt(float[] retVal, float argX, float argY, float argZ, float centerX, float centerY, float centerZ) {
            return GravityDirection.rotateXYZAt(this, retVal, argX, argY, argZ, centerX, centerY, centerZ);
        }

        public static final float[] rotateXYZAt(GravityDirection dir, float[] retVal, float argX, float argY, float argZ, float centerX, float centerY, float centerZ) {
            float x = argX - centerX;
            float y = argY - centerY;
            float z = argZ - centerZ;
            retVal[0] = x * (float)dir.matrixRotationD[0] + y * (float)dir.matrixRotationD[3] + z * (float)dir.matrixRotationD[6] + centerX;
            retVal[1] = x * (float)dir.matrixRotationD[1] + y * (float)dir.matrixRotationD[4] + z * (float)dir.matrixRotationD[7] + centerY;
            retVal[2] = x * (float)dir.matrixRotationD[2] + y * (float)dir.matrixRotationD[5] + z * (float)dir.matrixRotationD[8] + centerZ;
            return retVal;
        }

        public int[] rotateXYZAt(int[] retVal, int argX, int argY, int argZ, int centerX, int centerY, int centerZ) {
            return GravityDirection.rotateXYZAt(this, retVal, argX, argY, argZ, centerX, centerY, centerZ);
        }

        public static final int[] rotateXYZAt(GravityDirection dir, int[] retVal, int argX, int argY, int argZ, int centerX, int centerY, int centerZ) {
            int x = argX - centerX;
            int y = argY - centerY;
            int z = argZ - centerZ;
            retVal[0] = x * dir.matrixRotationI[0] + y * dir.matrixRotationI[3] + z * dir.matrixRotationI[6] + centerX;
            retVal[1] = x * dir.matrixRotationI[1] + y * dir.matrixRotationI[4] + z * dir.matrixRotationI[7] + centerY;
            retVal[2] = x * dir.matrixRotationI[2] + y * dir.matrixRotationI[5] + z * dir.matrixRotationI[8] + centerZ;
            return retVal;
        }

        public asu rotateAABBAt(asu aabb, int x, int y, int z) {
            return GravityDirection.rotateAABBAt(this, aabb, x, y, z);
        }

        public static final asu rotateAABBAt(GravityDirection dir, asu aabb, int x, int y, int z) {
            return GravityDirection.rotateAABBAt(dir, aabb, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        }

        public asu rotateAABBAt(asu aabb, double roatCenterX, double roatCenterY, double roatCenterZ) {
            return GravityDirection.rotateAABBAt(this, aabb, roatCenterX, roatCenterY, roatCenterZ);
        }

        public static final asu rotateAABBAt(GravityDirection dir, asu aabb, double roatCenterX, double roatCenterY, double roatCenterZ) {
            double aabbminX = aabb.a - roatCenterX;
            double aabbminY = aabb.b - roatCenterY;
            double aabbminZ = aabb.c - roatCenterZ;
            double aabbmaxX = aabb.d - roatCenterX;
            double aabbmaxY = aabb.e - roatCenterY;
            double aabbmaxZ = aabb.f - roatCenterZ;
            double x1 = aabbminX * dir.matrixRotationD[0] + aabbminY * dir.matrixRotationD[3] + aabbminZ * dir.matrixRotationD[6] + roatCenterX;
            double y1 = aabbminX * dir.matrixRotationD[1] + aabbminY * dir.matrixRotationD[4] + aabbminZ * dir.matrixRotationD[7] + roatCenterY;
            double z1 = aabbminX * dir.matrixRotationD[2] + aabbminY * dir.matrixRotationD[5] + aabbminZ * dir.matrixRotationD[8] + roatCenterZ;
            double x2 = aabbmaxX * dir.matrixRotationD[0] + aabbmaxY * dir.matrixRotationD[3] + aabbmaxZ * dir.matrixRotationD[6] + roatCenterX;
            double y2 = aabbmaxX * dir.matrixRotationD[1] + aabbmaxY * dir.matrixRotationD[4] + aabbmaxZ * dir.matrixRotationD[7] + roatCenterY;
            double z2 = aabbmaxX * dir.matrixRotationD[2] + aabbmaxY * dir.matrixRotationD[5] + aabbmaxZ * dir.matrixRotationD[8] + roatCenterZ;
            aabb.a = Math.min(x1, x2);
            aabb.b = Math.min(y1, y2);
            aabb.c = Math.min(z1, z2);
            aabb.d = Math.max(x1, x2);
            aabb.e = Math.max(y1, y2);
            aabb.f = Math.max(z1, z2);
            return aabb;
        }

        static {
            BY_INTVAL = new GravityDirection[]{upTOdown, downTOup, eastTOwest, westTOeast, northTOsouth, southTOnorth};
        }
    }
}

