/*
 * Decompiled with CFR 0.152.
 */
package jp.mc.ancientred.starminer.packet;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.logging.Level;
import jp.mc.ancientred.starminer.SMModContainer;
import jp.mc.ancientred.starminer.dimention.MapFromSky;
import jp.mc.ancientred.starminer.entity.EntityLivingGravitized;
import jp.mc.ancientred.starminer.extendedproperty.ExtendedPropertyGravity;
import jp.mc.ancientred.starminer.gui.ContainerStarCore;
import jp.mc.ancientred.starminer.tileentity.TileEntityGravityGenerator;
import jp.mc.ancientred.starminer.tileentity.TileEntityNavigator;
import net.minecraft.launchwrapper.LogWrapper;

public class SMPacketHandler
implements IPacketHandler {
    public static final byte TYPE_TILEE_GCORE = 0;
    public static final byte TYPE_TILEE_NAVI = 1;

    public void onPacketData(cl manager, dz packet, Player player) {
        ue entityplayer;
        if (packet.a.equals("stmnTE")) {
            this.updateTileEntityOnClient(packet);
        }
        if (packet.a.equals("stmnAT")) {
            this.receiveAttractPacketOnClient(packet, player);
        }
        if (packet.a.equals("stmnGC")) {
            if (player != null && !SMModContainer.proxy.isClient(player)) {
                this.receiveGravityStateChangeOnServer(packet, player);
            } else {
                this.receiveGravityStateChangeOnClient(packet, player);
            }
        }
        if (packet.a.equals("stmnGSCA") && (entityplayer = (ue)player) != null && entityplayer.bp instanceof ContainerStarCore) {
            ContainerStarCore container = (ContainerStarCore)entityplayer.bp;
            container.receiveButtonAction(packet.c[0]);
        }
        if (packet.a.equals("stmnSM") && SMModContainer.proxy.isClient(player)) {
            this.receiveMapFromSky(packet);
        }
    }

    private void receiveMapFromSky(dz packet) {
        try {
            LogWrapper.log((Level)Level.INFO, (String)"[Starminer]Receiveing ground texture..", (Object[])new Object[0]);
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            short dataLength = data.readShort();
            if (MapFromSky.skyMapclientData == null) {
                MapFromSky.skyMapclientData = new byte[dataLength];
            } else {
                MapFromSky.doRecompileSkyMapList = true;
            }
            data.readFully(MapFromSky.skyMapclientData);
            MapFromSky.hasSkyMapImageData = true;
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private void receiveAttractPacketOnClient(dz packet, Player player) {
        try {
            nm entity;
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            ue entityPlayer = (ue)player;
            int entityId = data.readInt();
            boolean attractedState = data.readBoolean();
            int attractedX = data.readInt();
            int attractedY = data.readInt();
            int attractedZ = data.readInt();
            if (entityPlayer.k == entityId && (entity = entityPlayer.q.a(entityId)) != null && entity == (ue)player) {
                ExtendedPropertyGravity gravity = ExtendedPropertyGravity.getGravityProp((nm)((ue)player));
                if (attractedState) {
                    gravity.isAttracted = true;
                    gravity.attractedPosX = attractedX;
                    gravity.attractedPosY = attractedY;
                    gravity.attractedPosZ = attractedZ;
                } else {
                    gravity.isAttracted = false;
                    gravity.attractedPosX = 0;
                    gravity.attractedPosY = 0;
                    gravity.attractedPosZ = 0;
                }
            }
        }
        catch (Exception ex2) {
            ex2.printStackTrace();
        }
    }

    private void receiveGravityStateChangeOnServer(dz packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            ue entityPlayer = (ue)player;
            int entityId = data.readInt();
            int gravityDirectionInt = data.readInt();
            if (entityPlayer.k == entityId) {
                ExtendedPropertyGravity gravity = ExtendedPropertyGravity.getGravityProp((nm)entityPlayer);
                ExtendedPropertyGravity.GravityDirection old = gravity.gravityDirection;
                gravity.gravityDirection = ExtendedPropertyGravity.GravityDirection.BY_INTVAL[gravityDirectionInt];
                if (old != gravity.gravityDirection) {
                    entityPlayer.b(entityPlayer.u, entityPlayer.v, entityPlayer.w);
                    ((EntityLivingGravitized)entityPlayer).redistInOpaqueBlockDamageTick = 30;
                }
                PacketDispatcher.sendPacketToAllAround((double)entityPlayer.u, (double)entityPlayer.v, (double)entityPlayer.w, (double)50.0, (int)entityPlayer.q.t.i, (ex)packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void receiveGravityStateChangeOnClient(dz packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            ue entityPlayer = (ue)player;
            int entityId = data.readInt();
            int gravityDirectionInt = data.readInt();
            if (entityPlayer.k != entityId) {
                abv world = SMModContainer.proxy.getClientWorld();
                if (world == null) {
                    return;
                }
                nm entity = world.a(entityId);
                if (entity == null) {
                    return;
                }
                ExtendedPropertyGravity gravity = ExtendedPropertyGravity.getGravityProp(entity);
                if (gravity == null) {
                    return;
                }
                ExtendedPropertyGravity.GravityDirection old = gravity.gravityDirection;
                gravity.gravityDirection = ExtendedPropertyGravity.GravityDirection.BY_INTVAL[gravityDirectionInt];
                if (old != gravity.gravityDirection) {
                    entity.b(entity.u, entity.v, entity.w);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateTileEntityOnClient(dz packet) {
        ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
        try {
            byte type = data.readByte();
            int x = data.readInt();
            int y = data.readInt();
            int z = data.readInt();
            switch (type) {
                case 0: {
                    abv world = SMModContainer.proxy.getClientWorld();
                    asm tileEntity = world.r(x, y, z);
                    if (tileEntity == null || !(tileEntity instanceof TileEntityGravityGenerator)) break;
                    ((TileEntityGravityGenerator)tileEntity).gravityRange = data.readDouble();
                    ((TileEntityGravityGenerator)tileEntity).starRad = data.readDouble();
                    ((TileEntityGravityGenerator)tileEntity).type = data.readInt();
                    break;
                }
                case 1: {
                    abv world = SMModContainer.proxy.getClientWorld();
                    asm tileEntity = world.r(x, y, z);
                    if (tileEntity == null || !(tileEntity instanceof TileEntityNavigator)) break;
                    ((TileEntityNavigator)tileEntity).lookX = data.readFloat();
                    ((TileEntityNavigator)tileEntity).lookY = data.readFloat();
                    ((TileEntityNavigator)tileEntity).lookZ = data.readFloat();
                    ((TileEntityNavigator)tileEntity).activeTickCount = data.readInt();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendAttractedChangePacketToPlayer(ue entityPlayer, boolean attractedState, int attractedX, int attractedY, int attractedZ) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(entityPlayer.k);
            dos.writeBoolean(attractedState);
            dos.writeInt(attractedX);
            dos.writeInt(attractedY);
            dos.writeInt(attractedZ);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dz packet = new dz();
        packet.a = "stmnAT";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        SMModContainer.proxy.sendPacketToPlayer((ex)packet, entityPlayer);
    }

    public static void sendGravityStatePacketToServer(nm entity, ExtendedPropertyGravity.GravityDirection newGravityDirection) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeInt(entity.k);
            dos.writeInt(newGravityDirection.intValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dz packet = new dz();
        packet.a = "stmnGC";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        SMModContainer.proxy.sendPacketToServer(packet);
    }

    public static void sendSkyMapPacketToPlayer(ue entityPlayer) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeShort(MapFromSky.mapDataFromSky.e.length);
            dos.write(MapFromSky.mapDataFromSky.e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dz packet = new dz();
        packet.a = "stmnSM";
        packet.c = bos.toByteArray();
        packet.b = bos.size();
        packet.s = true;
        SMModContainer.proxy.sendPacketToPlayer((ex)packet, entityPlayer);
    }
}

