<?php

namespace WPHealth\Actions;

use WPHealth\Core\Hooks\ActivationHook;
use WPHealth\Core\Hooks\DeactivationHook;
use WPHealth\Services\Api\Monitors as ApiMonitors;

class ActiveAndDeactivateHandlerMonitor implements ActivationHook, DeactivationHook
{
    public function __construct(ApiMonitors $apiMonitors)
    {
        $this->apiMonitors = $apiMonitors;
    }

    public function activate()
    {
        if (!wp_umbrella_get_api_key() || !wp_umbrella_allowed()) {
            return;
        }

        $this->apiMonitors->updateMonitors([
            'active' => true,
        ]);
    }

    public function deactivate()
    {
        if (!wp_umbrella_get_api_key()) {
            return;
        }

        $this->apiMonitors->updateMonitors([
            'active' => false,
        ]);
    }
}
