<?php

namespace WPHealth\Actions\Admin\Ajax;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Services\Api\Monitors as ApiMonitors;

class ApiMonitor implements ExecuteHooksBackend
{
    public function __construct(ApiMonitors $apiMonitors)
    {
        $this->apiMonitors = $apiMonitors;
    }

    public function hooks()
    {
        add_action('wp_ajax_wp_health_update_monitor', [$this, 'update']);
    }

    public function update()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'wp_health_update_monitor')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['id'])) {
            wp_send_json_error([
                'code' => 'missing_parameters',
            ]);
            exit;
        }

        $idMonitor = (int) $_POST['id'];

        $data = [];
        if (isset($_POST['regions'])) {
            try {
                $regions = explode(',', $_POST['regions']);
                $regions = array_map('sanitize_text_field', $regions);
                $data['regions'] = $regions;
            } catch (\Exception $e) {
                $data['regions'] = [];
            }
        }
        if (isset($_POST['ping_frequency'])) {
            $data['ping_frequency'] = (int) $_POST['ping_frequency'];
        }

        $this->apiMonitors->updateMonitor($idMonitor, $data);

        wp_send_json_success($data);
    }
}
