<?php

namespace WPHealth\Actions\Admin\Ajax;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Services\Api\EmailNotification as EmailNotificationService;

class ProjectEmailNotification implements ExecuteHooksBackend
{
    public function __construct(EmailNotificationService $emailNotification)
    {
        $this->emailNotificationService = $emailNotification;
    }

    public function hooks()
    {
        add_action('wp_ajax_wp_health_create_or_update_email_notification', [$this, 'createOrUpdate']);
    }

    public function createOrUpdate()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'wp_health_create_or_update_email_notification')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['emails'])) {
            wp_send_json_error([
                'code' => 'missing_parameters',
            ]);
            exit;
        }

        try {
            $result = $this->emailNotificationService->createOrUpdate([
                'emails' => json_decode(stripslashes($_POST['emails']), true),
            ]);
        } catch (\Exception $e) {
            wp_send_json_error([
                'code' => 'unknown_error',
            ]);
            exit;
        }

        wp_send_json_success($result);
    }
}
