<?php

namespace WPHealth\Actions\Admin\Ajax;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Services\Api\WebhookSlack as WebhookSlackService;

class ProjectWebhookSlack implements ExecuteHooksBackend
{
    public function __construct(WebhookSlackService $webhookSlack)
    {
        $this->webhookSlackService = $webhookSlack;
    }

    public function hooks()
    {
        add_action('wp_ajax_wp_health_update_webhook_slack', [$this, 'update']);
    }

    public function update()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'wp_health_update_webhook_slack')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['url'])) {
            wp_send_json_error([
                'code' => 'missing_parameters',
            ]);
            exit;
        }

        try {
            $result = $this->webhookSlackService->update([
                'url' => $_POST['url'],
            ]);
        } catch (\Exception $e) {
            wp_send_json_error([
                'code' => 'unknown_error',
            ]);
            exit;
        }

        wp_send_json_success($result);
    }
}
