<?php

namespace WPHealth\Actions\Admin\Ajax;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;

class Support implements ExecuteHooksBackend
{
    public function hooks()
    {
        add_action('wp_ajax_wp_health_support_request', [$this, 'update']);
    }

    public function update()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'wp_health_support_request')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['subject'], $_POST['html'])) {
            wp_send_json_success(['send' => 'ko']);
            exit;
        }

        $subject = $_POST['subject'];
        $html = $_POST['html'];

        try {
            $response = wp_remote_post(WP_UMBRELLA_API_URL . '/api/external/support-request', [
                'headers' => [
                    'Content-Type'  => 'application/json',
                    'Authorization' => wp_umbrella_get_option('api_key'),
                ],
                'body' => json_encode([
                    'subject' => $subject,
                    'html'    => $html,
                ]),
                'timeout' => 50,
            ]);
        } catch (\Execption $e) {
            wp_send_json_success(['sent' => 'ko']);

            return;
        }

        wp_send_json_success(['sent' => 'ok']);
    }
}
