<?php

namespace WPHealth\Actions\Admin\Ajax;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Services\Api\Owner;
use WPHealth\Services\Option;

class ValidationApiKey implements ExecuteHooksBackend
{
    public function __construct(Option $option, Owner $getOwner)
    {
        $this->optionService = $option;
        $this->getOwnerService = $getOwner;
    }

    public function hooks()
    {
        add_action('wp_ajax_wp_health_valid_api_key', [$this, 'validate']);
    }

    public function validate()
    {
        if (!current_user_can('manage_options')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'wp_health_valid_api_key')) {
            wp_send_json_error([
                'code' => 'not_authorized',
            ]);
            exit;
        }

        if (!isset($_POST['api_key'])) {
            wp_send_json_error([
                'code' => 'missing_parameters',
            ]);
            exit;
        }

        $apiKey = sanitize_text_field($_POST['api_key']);

        $options['allowed'] = false;
        if (empty($apiKey)) {
            wp_send_json_error([
                'code' => 'missing_parameters',
            ]);
            exit;
        }

        $optionsBdd = $this->optionService->getOptions();
        $newOptions = wp_parse_args($options, $optionsBdd);

        try {
            $owner = $this->getOwnerService->getOwnerByApiKey($apiKey);
            if ($owner && !isset($owner['code'])) {
                $newOptions['allowed'] = true;
                $newOptions['api_key'] = $apiKey;
                $this->optionService->setOptions($newOptions);
            } else {
                $newOptions['allowed'] = false;
                $newOptions['api_key'] = '';
                $this->optionService->setOptions($newOptions);
            }
        } catch (\Exception $e) {
            wp_send_json_error([
                'code' => 'unknown_error',
            ]);
            exit;
        }

        wp_send_json_success([
            'user'    => $owner,
            'api_key' => $apiKey,
        ]);
    }
}
