<?php

namespace WPHealth\Actions\Admin;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ActivationHook;
use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Services\Option as OptionService;

class Option implements ExecuteHooksBackend, ActivationHook
{
    public function __construct(OptionService $optionService)
    {
        $this->optionService = $optionService;
    }

    public function hooks()
    {
        add_action('admin_init', [$this, 'init']);
    }

    public function activate()
    {
        update_option('wphealth_version', WP_UMBRELLA_VERSION);
        $options = $this->optionService->getOptions();

        $this->optionService->setOptions($options);
    }

    /**
     * Register setting options.
     *
     * @see admin_init
     */
    public function init()
    {
        register_setting(WP_UMBRELLA_OPTION_GROUP, WP_UMBRELLA_SLUG, [$this, 'parseArgs']);
    }

    /**
     * Callback register_setting for parseArgs options.
     *
     * @param array $options
     *
     * @return array
     */
    public function parseArgs($options)
    {
        $optionsBdd = $this->optionService->getOptions();
        $newOptions = wp_parse_args($options, $optionsBdd);

        return $newOptions;
    }
}
