<?php

namespace WPHealth\Actions\Admin;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Helpers\Pages as PagesHelper;
use WPHealth\Services\Api\Owner;
use WPHealth\Services\Option as OptionService;

class Pages implements ExecuteHooksBackend
{
    public function __construct(OptionService $option, Owner $getOwner)
    {
        $this->optionService = $option;
        $this->getOwnerService = $getOwner;
    }

    public function hooks()
    {
        add_action('admin_menu', [$this, 'addMenu']);
    }

    /**
     * Add menu and sub pages.
     *
     * @see admin_menu
     */
    public function addMenu()
    {
        add_options_page(
            __('WP Umbrella', 'wp-health'),
            __('WP Umbrella', 'wp-health'),
            'manage_options',
            PagesHelper::SETTINGS,
            [$this, 'settings']
        );
    }

    public function settings()
    {
        if (wp_umbrella_allowed()) {
            $this->owner = $this->getOwnerService->getOwnerImplicitApiKey();
            $this->options = $this->optionService->getOptions();
        }

        include_once WP_UMBRELLA_TEMPLATES_ADMIN_PAGES . '/settings.php';
    }
}
