<?php

namespace WPHealth\Actions\Admin;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooksBackend;

class PluginLinks implements ExecuteHooksBackend
{
    public function hooks()
    {
        add_filter('plugin_action_links', [$this, 'pluginLinks'], 10, 2);
    }

    public function pluginLinks($links, $file)
    {
        if (WP_UMBRELLA_BNAME !== $file) {
            return $links;
        }

        $settings = sprintf('<a href="%s">%s</a>', admin_url('options-general.php?page=wp-umbrella-settings'), __('Settings'));

        $premium = sprintf('<a href="%s" style="font-weight:bold; color:red;" target="_blank">%s</a>', WP_UMBRELLA_API_URL . '/profile/subscription', __('Become PREMIUM!', 'wp-health'));

        array_unshift($links, $settings, $premium);

        return $links;
    }
}
