<?php

namespace WPHealth\Actions\Admin;

use WPHealth\Core\Hooks\DeactivationHook;
use WPHealth\Core\Hooks\ExecuteHooksBackend;

class PrepareErrorHandler implements ExecuteHooksBackend, DeactivationHook
{
    public function hooks()
    {
        $allowTracking = get_option('wp_health_allow_tracking');
        if (!$allowTracking) {
            return;
        }

        $versionGodHandler = get_option('wp_health_version_god_handler');
        if (version_compare(WP_UMBRELLA_GOD_HANDLER_VERSION, $versionGodHandler) > 0) {
            $result = $this->createHandler();
            if ($result) {
                update_option('wp_health_version_god_handler', WP_UMBRELLA_GOD_HANDLER_VERSION);
            }
        }
    }

    protected function createHandler()
    {
        if (!file_exists(WPMU_PLUGIN_DIR) && !is_writable(dirname(WPMU_PLUGIN_DIR))) {
            add_action('admin_notices', [__CLASS__, 'adminNoticeNotWritable']);

            return false;
        }

        if (!file_exists(WPMU_PLUGIN_DIR) && is_writable(dirname(WPMU_PLUGIN_DIR))) {
            wp_mkdir_p(WPMU_PLUGIN_DIR);
        }

        try {
            if (!copy(
                WP_UMBRELLA_DIR . '/src/God/_WPHealthHandlerMU.php',
                WPMU_PLUGIN_DIR . '/_WPHealthHandlerMU.php'
            )) {
                add_action('admin_notices', [__CLASS__, 'adminNotice']);

                return false;
            }
        } catch (\Exception $e) {
            add_action('admin_notices', [__CLASS__, 'adminNotice']);

            return false;
        }

        return true;
    }

    public function deactivate()
    {
        delete_option('wp_health_version_god_handler');
        if (file_exists(WPMU_PLUGIN_DIR . '/_WPHealthHandlerMU.php')) {
            if (is_writable(WPMU_PLUGIN_DIR . '/_WPHealthHandlerMU.php')) {
                unlink(WPMU_PLUGIN_DIR . '/_WPHealthHandlerMU.php');
            }
        }
    }

    public static function adminNoticeNotWritable()
    {
        echo '<div class="notice error is-dismissible">';
        echo '<p>' . esc_html(__('An error was caused when WP Umbrella tried to write in your directory mu-plugins. Please contact : support@wp-umbrella.com', 'wp-health')) . '</p>';

        echo '</div>';
    }

    public static function adminNotice()
    {
        echo '<div class="notice error is-dismissible">';
        echo '<p>' . esc_html(__('An error was caused when WP Umbrella attempted to create a file in your directory mu-plugins. Please contact : support@wp-umbrella.com', 'wp-health')) . '</p>';

        echo '</div>';
    }
}
