<?php

namespace WPHealth\Actions;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Core\Hooks\ExecuteHooks;
use WPHealth\Helpers\GodTransient;

class TrackingError implements ExecuteHooks
{
    public function hooks()
    {
        $transient = get_transient(GodTransient::ERRORS_SAVE);

        if (!$transient) {
            return;
        }

        add_action('init', [$this, 'init']);
    }

    public function init()
    {
        $transient = get_transient(GodTransient::ERRORS_SAVE);

        delete_transient(GodTransient::ERRORS_SAVE);
        if (empty($transient)) {
            return;
        }

        foreach ($transient as $key => $error) {
            as_schedule_single_action(time(), 'action_wp_umbrella_send_errors', $error, 'umbrella_errors');
        }
    }
}
