<?php

defined('ABSPATH') or die('Cheatin&#8217; uh?');

function wp_umbrella_get_data_current_from_current_file($file)
{
    $fileClean = str_replace(realpath(ABSPATH), '', $file);

    $errorFrom['Plugin'] = false !== strpos($file, realpath(WP_PLUGIN_DIR)) ? $fileClean : false;
    $errorFrom['Child Theme'] = STYLESHEETPATH != TEMPLATEPATH && false !== strpos($file, realpath(STYLESHEETPATH) . '\\') ? $fileClean : false;
    $errorFrom['Parent Theme'] = false !== strpos($file, realpath(TEMPLATEPATH)) ? $fileClean : false;
    $errorFrom['Content'] = false !== strpos($file, realpath(WP_CONTENT_DIR)) ? $fileClean : false;
    $errorFrom['Unknown'] = $fileClean;

    $errorFrom = array_filter($errorFrom);
    $errorFromKey = key($errorFrom);
    $errorFromFile = addcslashes(reset($errorFrom), '\\');

    switch ($errorFromKey) {
            case 'Plugin':
                $errorFromBonus = trim(dirname(str_replace(realpath(WP_PLUGIN_DIR), '', $file)), '\\');
                $errorFromBonusArray = array_values(array_filter(explode('/', $errorFromBonus)));
                $slug = $errorFromBonusArray[0];

                $errorFromname = '';
                $plugins = get_plugins('/' . $slug);

                if ($plugin = reset($plugins)) {
                    $errorFromname = $plugin['Name'];

                    return [
                        'type'         => 'plugin',
                        'slug'         => $slug,
                        'name'         => $plugin['Name'],
                        'title'        => $plugin['Title'],
                        'description'  => $plugin['Description'],
                        'version'      => $plugin['Version'],
                        'author'       => $plugin['Author'],
                        'author_uri'   => $plugin['AuthorURI'],
                        'uri'          => $plugin['PluginURI'],
                        'domain_path'  => $plugin['DomainPath'],
                        'network'      => $plugin['Network'],
                        'author_name'  => $plugin['AuthorName'],
                    ];
                }
                break;
            case 'Parent Theme':
            case 'Child Theme':
                $theme = wp_get_theme();
                if (!$theme) {
                    return null;
                }

                return [
                    'type'         => 'theme',
                    'name'         => $theme->name,
                    'title'        => $theme->title,
                    'description'  => $theme->description,
                    'version'      => $theme->version,
                    'author'       => $theme->author,
                    'author_uri'   => $theme->author_uri,
                    'parent_theme' => $theme->parent_theme,
                    'template'     => $theme->template,
                    'stylesheet'   => $theme->stylesheet,
                ];
            break;
        }

    return null;
}

add_action('action_wp_umbrella_send_errors', 'wp_umbrella_send_errors', 10, 4);

function wp_umbrella_send_errors($message, $file, $code, $line)
{
    if (!isset($file, $code, $line, $message)) {
        return;
    }

    try {
        $data = wp_umbrella_get_data_current_from_current_file($file);

        if (null === $data) {
            return;
        }

        $data['file'] = $file;
        $data['line'] = $line;
        $data['code'] = $code;
        $data['message'] = $message;
        $data['php_version'] = phpversion();
        $data['wordpress_version'] = get_bloginfo('version');
        wp_remote_post('https://wp-health-cron.herokuapp.com/errors', [
            'headers' => [
                'Content-Type'  => 'application/json',
                'Authorization' => wp_umbrella_get_option('api_key'),
            ],
            'body'    => json_encode($data),
        ]);
    } catch (Exception $e) {
    }
}
