<?php

namespace WPHealth\Core;

defined('ABSPATH') or die('Cheatin&#8217; uh?');

use WPHealth\Core\Container\ContainerSymfony;
use WPHealth\Core\Container\ManageContainer;
use WPHealth\Core\Hooks\ActivationHook;
use WPHealth\Core\Hooks\DeactivationHook;
use WPHealth\Core\Hooks\ExecuteHooks;
use WPHealth\Core\Hooks\ExecuteHooksBackend;
use WPHealth\Core\Hooks\ExecuteHooksFrontend;

abstract class Kernel
{
    protected static $container = null;

    protected static $data = ['slug' => null, 'file' => null];

    public static function setContainer(ManageContainer $container)
    {
        self::$container = self::getDefaultContainer();
    }

    protected static function getDefaultContainer()
    {
        return new ContainerSymfony();
    }

    public static function getContainer()
    {
        if (null === self::$container) {
            self::$container = self::getDefaultContainer();
        }

        return self::$container;
    }

    public static function handleHooksPlugin()
    {
        require_once WP_UMBRELLA_DIR . '/wp-umbrella-functions.php';
        require_once WP_UMBRELLA_DIR . '/src/Async/ActionSchedulerSendErrors.php';
        require_once WP_UMBRELLA_DIR . '/vendor/woocommerce/action-scheduler/action-scheduler.php';

        switch (current_filter()) {
            case 'plugins_loaded':

                load_plugin_textdomain('wp-health', false, WP_UMBRELLA_LANGUAGES);

                foreach (self::getContainer()->getServicesByTag('hooks') as $id => $tags) {
                    $class = self::getContainer()->getBuilder()->get($id);

                    switch (true) {
                        case $class instanceof ExecuteHooksBackend:
                            if (is_admin()) {
                                $class->hooks();
                            }
                            break;

                        case $class instanceof ExecuteHooksFrontend:
                            if (!is_admin()) {
                                $class->hooks();
                            }
                            break;

                        case $class instanceof ExecuteHooks:
                            $class->hooks();
                            break;
                    }
                }
                break;
            case 'activate_' . self::$data['slug'] . '/' . self::$data['slug'] . '.php':
                foreach (self::getContainer()->getServicesByTag('hooks') as $id => $tags) {
                    $class = self::getContainer()->get($id);
                    if ($class instanceof ActivationHook) {
                        $class->activate();
                    }
                }
                break;
            case 'deactivate_' . self::$data['slug'] . '/' . self::$data['slug'] . '.php':
                foreach (self::getContainer()->getServicesByTag('hooks') as $id => $tags) {
                    $class = self::getContainer()->get($id);
                    if ($class instanceof DeactivationHook) {
                        $class->deactivate();
                    }
                }
                break;
        }
    }

    protected static function buildActions()
    {
        /****************
         * All actions
         ****************/

        self::getContainer()->set('TrackingError', '\WPHealth\Actions\TrackingError');
        self::getContainer()->getBuilder()->getDefinition('TrackingError')->addTag('hooks');

        self::getContainer()->set('ActiveAndDeactivateHandlerMonitor', '\WPHealth\Actions\ActiveAndDeactivateHandlerMonitor', [
            self::getContainer()->get('Monitors'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ActiveAndDeactivateHandlerMonitor')->addTag('hooks');

        /****************
         * Admin actions
         ****************/
        self::getContainer()->set('OptionAction', '\WPHealth\Actions\Admin\Option', [
            self::getContainer()->get('Option'),
        ]);

        self::getContainer()->getBuilder()->getDefinition('OptionAction')->addTag('hooks');

        self::getContainer()->set('PagesAction', '\WPHealth\Actions\Admin\Pages', [
            self::getContainer()->get('Option'),
            self::getContainer()->get('Owner'),
        ]);

        self::getContainer()->set('EnqueueAction', '\WPHealth\Actions\Admin\Enqueue', [
            self::getContainer()->get('Owner'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('EnqueueAction')->addTag('hooks');

        self::getContainer()->set('PluginLinks', '\WPHealth\Actions\Admin\PluginLinks');
        self::getContainer()->getBuilder()->getDefinition('PluginLinks')->addTag('hooks');

        self::getContainer()->set('PrepareErrorHandler', '\WPHealth\Actions\Admin\PrepareErrorHandler');
        self::getContainer()->getBuilder()->getDefinition('PrepareErrorHandler')->addTag('hooks');

        /****************
         * Ajax actions
         ****************/
        self::getContainer()->getBuilder()->getDefinition('PagesAction')->addTag('hooks');

        self::getContainer()->set('RegisterAction', '\WPHealth\Actions\Admin\Ajax\Register', [
            self::getContainer()->get('Register'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('RegisterAction')->addTag('hooks');

        self::getContainer()->set('ValidationApiKeyAction', '\WPHealth\Actions\Admin\Ajax\ValidationApiKey', [
            self::getContainer()->get('Option'),
            self::getContainer()->get('Owner'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ValidationApiKeyAction')->addTag('hooks');

        self::getContainer()->set('ApiMonitorAction', '\WPHealth\Actions\Admin\Ajax\ApiMonitor', [
            self::getContainer()->get('Monitors'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ApiMonitorAction')->addTag('hooks');

        self::getContainer()->set('NoConfiguratinoNoticeAction', '\WPHealth\Actions\Admin\Notices\NoConfiguration');
        self::getContainer()->getBuilder()->getDefinition('NoConfiguratinoNoticeAction')->addTag('hooks');

        self::getContainer()->set('ProxyAction', '\WPHealth\Actions\Admin\Ajax\Proxy', [
            self::getContainer()->get('Proxy'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ProxyAction')->addTag('hooks');

        self::getContainer()->set('ProjectEmailNotificationAction', '\WPHealth\Actions\Admin\Ajax\ProjectEmailNotification', [
            self::getContainer()->get('EmailNotification'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ProjectEmailNotificationAction')->addTag('hooks');

        self::getContainer()->set('ProjectWebhookSlackAction', '\WPHealth\Actions\Admin\Ajax\ProjectWebhookSlack', [
            self::getContainer()->get('WebhookSlack'),
        ]);
        self::getContainer()->getBuilder()->getDefinition('ProjectWebhookSlackAction')->addTag('hooks');

        self::getContainer()->set('SupportAction', '\WPHealth\Actions\Admin\Ajax\Support');
        self::getContainer()->getBuilder()->getDefinition('SupportAction')->addTag('hooks');

        self::getContainer()->set('AllowTrackingAction', '\WPHealth\Actions\Admin\Ajax\AllowTracking');
        self::getContainer()->getBuilder()->getDefinition('AllowTrackingAction')->addTag('hooks');

        self::getContainer()->set('PreventDeactivateAction', '\WPHealth\Actions\Admin\Ajax\PreventDeactivate');
        self::getContainer()->getBuilder()->getDefinition('PreventDeactivateAction')->addTag('hooks');
    }

    protected static function buildServices()
    {
        self::getContainer()->set('Option', '\WPHealth\Services\Option');
        self::getContainer()->set('Register', '\WPHealth\Services\Register', [
            self::getContainer()->get('Option'),
        ]);
        self::getContainer()->set('Owner', '\WPHealth\Services\Api\Owner');
        self::getContainer()->set('Monitors', '\WPHealth\Services\Api\Monitors');
        self::getContainer()->set('Regions', '\WPHealth\Services\Api\Regions');
        self::getContainer()->set('Proxy', '\WPHealth\Services\Api\Proxy');
        self::getContainer()->set('EmailNotification', '\WPHealth\Services\Api\EmailNotification');
        self::getContainer()->set('WebhookSlack', '\WPHealth\Services\Api\WebhookSlack');
        self::getContainer()->set('ErrorHandler', '\WPHealth\Services\ErrorHandler');
        self::getContainer()->set('Healthcheck', '\WPHealth\Services\Healthcheck');
        self::getContainer()->set('WordPressData', '\WPHealth\Services\WordPressData');
    }

    /**
     * Build Container.
     */
    public static function buildContainer()
    {
        self::buildServices();
        self::buildActions();
    }

    public static function execute($data)
    {
        self::buildContainer();

        self::$data = array_merge(self::$data, $data);
        add_action('plugins_loaded', [__CLASS__, 'handleHooksPlugin']);
        register_activation_hook($data['file'], [__CLASS__, 'handleHooksPlugin']);
        register_deactivation_hook($data['file'], [__CLASS__, 'handleHooksPlugin']);
    }
}
