<?php

namespace WPHealth\Healthcheck;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Helpers\HealthcheckCategory;
use WPHealth\Helpers\HealthcheckState;

class Website
{
    /**
     * Website use SSL protocol ?
     *
     * @return array
     */
    public function isSsl()
    {
        $data = [
            'key'      => 'is_ssl',
            'label'    => __('SSL Certificate Checker', 'wp-health'),
            'category' => [HealthcheckCategory::SECURITY],
        ];

        if (is_ssl()) {
            return array_merge($data, [
                'message' => __('You have a SSL certificate. Great!', 'wp-health'),
                'code'    => HealthcheckState::GOOD,
            ]);
        }

        return array_merge($data, [
            'message' => __('Warning, your site does not use SSL certificate. Some browsers will label your site as "not secure" and this is also penalizing for SEO. Contact your host to get one or our support so that we can redirect you to a competent person.', 'wp-health'),
            'code'    => HealthcheckState::BAD,
        ]);
    }
}
