<?php

namespace WPHealth\Helpers;

if (!defined('ABSPATH')) {
    exit;
}

abstract class HealthcheckCategory
{
    const SECURITY = 'security';

    const SEO = 'seo';

    const PERFORMANCE = 'performance';

    public static function getCategories()
    {
        return apply_filters('wp_umbrella_get_categories_tips', [
            [
                'label' => __('Security', 'wp-health'),
                'key'   => self::SECURITY,
            ],
            [
                'label' => __('SEO', 'wp-health'),
                'key'   => self::SEO,
            ],
            [
                'label' => __('Performance', 'wp-health'),
                'key'   => self::PERFORMANCE,
            ],
        ]);
    }
}
