<?php

namespace WPHealth\Services\Api;

if (!defined('ABSPATH')) {
    exit;
}

class EmailNotification extends BaseClient
{
    public function createOrUpdate($data)
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        try {
            $response = wp_remote_post(WP_UMBRELLA_API_URL . '/api/external/projects/notifications', [
                'headers' => $this->getHeaders(),
                'body'    => json_encode($data),
                'timeout' => 50,
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }
}
