<?php

namespace WPHealth\Services\Api;

if (!defined('ABSPATH')) {
    exit;
}

class Monitors extends BaseClient
{
    /**
     * Get all monitors by project.
     *
     * @return array
     */
    public function getMonitors()
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        try {
            $response = wp_remote_get(WP_UMBRELLA_API_URL . '/api/external/projects/monitors', [
                'headers' => $this->getHeaders(),
                'timeout' => 50,
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }

    /**
     * Get one monitor.
     *
     * @param int $idMonitor
     *
     * @return object
     */
    public function getMonitor($idMonitor)
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        try {
            $response = wp_remote_get(WP_UMBRELLA_API_URL . '/api/external/projects/monitors/' . $idMonitor, [
                'headers' => $this->getHeaders(),
                'timeout' => 50,
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }

    /**
     * @param int   $idMonitor
     * @param array $data
     *
     * @return object
     */
    public function updateMonitor($idMonitor, $data)
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        try {
            $response = wp_remote_request(WP_UMBRELLA_API_URL . '/api/external/projects/monitors/' . $idMonitor, [
                'method'  => 'PUT',
                'headers' => $this->getHeaders(),
                'body'    => json_encode($data),
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }

    /**
     * Update all monitors by project.
     *
     * @param array $data
     *
     * @return array
     */
    public function updateMonitors($data)
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        try {
            $response = wp_remote_request(WP_UMBRELLA_API_URL . '/api/external/projects/monitors', [
                'method'  => 'PUT',
                'headers' => $this->getHeaders(),
                'body'    => json_encode($data),
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }
}
