<?php

namespace WPHealth\Services\Api;

if (!defined('ABSPATH')) {
    exit;
}

class Owner extends BaseClient
{
    /**
     * @param string $apiKey
     *
     * @return array
     */
    public function getOwnerByApiKey($apiKey)
    {
        try {
            $response = wp_remote_get(WP_UMBRELLA_API_URL . '/api/external/projects/owner', [
                'headers' => $this->getHeaders($apiKey),
                'timeout' => 50,
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);
        if (isset($body['code'])) {
            return null;
        }

        return $body;
    }

    public function getOwnerImplicitApiKey()
    {
        if (!wp_umbrella_get_api_key()) {
            return null;
        }

        return $this->getOwnerByApiKey(wp_umbrella_get_option('api_key'));
    }
}
