<?php

namespace WPHealth\Services\Api;

if (!defined('ABSPATH')) {
    exit;
}

class Regions extends BaseClient
{
    /**
     * @return array
     */
    public function getRegions()
    {
        try {
            $response = wp_remote_get(WP_UMBRELLA_API_URL . '/api/public/regions', [
                'headers' => $this->getHeaders(),
            ]);
        } catch (\Exception $e) {
            return null;
        }

        $body = json_decode(wp_remote_retrieve_body($response), true);

        return $body;
    }
}
