<?php

namespace WPHealth\Services;

if (!defined('ABSPATH')) {
    exit;
}

use WPHealth\Healthcheck\Website as HealthcheckWebsite;
use WPHealth\Healthcheck\WordPress as HealthcheckWordPress;

class Healthcheck
{
    public function getData()
    {
        if (!file_exists(ABSPATH . 'wp-admin/includes/class-wp-debug-data.php')) {
            return [];
        }

        if (!class_exists('WP_Debug_Data')) {
            require_once ABSPATH . 'wp-admin/includes/class-wp-debug-data.php';
        }

        return \WP_Debug_Data::debug_data();
    }

    public function getTips()
    {
        $wordpressHealthcheck = new HealthcheckWordPress();
        $webisteHealthcheck = new HealthcheckWebsite();

        return apply_filters('wp_umbrella_wordpress_tips', [
            $wordpressHealthcheck->isUpToDate(),
            $wordpressHealthcheck->isIndexable(),
            $wordpressHealthcheck->getTestPHPVersion(),
            $wordpressHealthcheck->isDebugModeActive(),
            $webisteHealthcheck->isSsl(),
        ]);
    }
}
